/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.util.HashSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class LayoutNetworkTask
extends AbstractTask {
    private TaskMonitor taskMonitor;
    private AnnotationSet annotationSet;
    private CyNetworkView view;
    private AutoAnnotationParameters params;
    private CyLayoutAlgorithmManager layoutManager;
    private SynchronousTaskManager<?> syncTaskManager;

    public LayoutNetworkTask(AnnotationSet annotationSet, AutoAnnotationParameters params) {
        this.annotationSet = annotationSet;
        this.params = params;
        this.view = params.getNetworkView();
        this.layoutManager = AutoAnnotationManager.getInstance().getLayoutManager();
        this.syncTaskManager = AutoAnnotationManager.getInstance().getSyncTaskManager();
    }

    private void layoutNodes() {
        CyLayoutAlgorithm attributeCircle = this.layoutManager.getLayout("attributes-layout");
        TaskIterator iterator = attributeCircle.createTaskIterator(this.view, attributeCircle.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, this.params.getClusterColumnName());
        this.syncTaskManager.execute(iterator);
        CyLayoutAlgorithm force_directed = this.layoutManager.getLayout("force-directed");
        for (Cluster cluster : this.annotationSet.getClusterMap().values()) {
            HashSet<View> nodeViewSet = new HashSet<View>();
            for (CyNode node : cluster.getNodes()) {
                nodeViewSet.add(this.view.getNodeView(node));
            }
            if (nodeViewSet.size() <= 4) continue;
            iterator = force_directed.createTaskIterator(this.view, force_directed.createLayoutContext(), nodeViewSet, null);
            this.syncTaskManager.execute(iterator);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setStatusMessage("Laying out nodes...");
        this.layoutNodes();
    }
}

