/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.util.HashMap;
import java.util.Map;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class DrawClusterLabelTask
extends AbstractTask {
    private Cluster cluster;
    private TaskMonitor taskMonitor;

    public DrawClusterLabelTask(Cluster cluster) {
        this.cluster = cluster;
    }

    public void drawTextLabel() {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        AnnotationSet parent = this.cluster.getParent();
        CyNetworkView view = parent.getView();
        boolean constantFontSize = parent.isConstantFontSize();
        int fontSize = parent.getFontSize();
        double[] labelPosition = parent.getLabelPosition();
        boolean showLabel = parent.isShowLabel();
        AnnotationFactory<TextAnnotation> textFactory = autoAnnotationManager.getTextFactory();
        AnnotationManager annotationManager = autoAnnotationManager.getAnnotationManager();
        double zoom = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        String labelText = this.cluster.getLabel();
        Map ellipseArgs = this.cluster.getEllipse().getArgMap();
        double xPos = Double.parseDouble((String)ellipseArgs.get("x"));
        double yPos = Double.parseDouble((String)ellipseArgs.get("y"));
        double width = Double.parseDouble((String)ellipseArgs.get("width"));
        double height = Double.parseDouble((String)ellipseArgs.get("height"));
        Integer labelFontSize = null;
        labelFontSize = constantFontSize ? Integer.valueOf(fontSize) : Integer.valueOf((int)Math.round(5.0 * Math.pow(this.cluster.getSize(), 0.4)));
        double labelWidth = 2.3;
        double labelHeight = 4.8;
        if (labelText != null && labelFontSize != null) {
            labelWidth = 2.3 * (double)labelFontSize.intValue() * (double)labelText.length();
            labelHeight = 4.8 * (double)labelFontSize.intValue();
        }
        double xOffset = labelPosition[0];
        double yOffset = labelPosition[1];
        xPos = yOffset == 0.5 && xOffset != 0.5 ? (double)((int)Math.round(xPos + width / zoom * xOffset + labelWidth * (xOffset - 1.0))) : (double)((int)Math.round(xPos + width / zoom * xOffset - labelWidth * xOffset));
        yPos = (int)Math.round(yPos + height / zoom * yOffset - labelHeight * (1.0 - yOffset) - 10.0 + yOffset * 20.0);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x", String.valueOf(xPos));
        arguments.put("y", String.valueOf(yPos));
        arguments.put("zoom", String.valueOf(zoom));
        arguments.put("canvas", "foreground");
        TextAnnotation textAnnotation = (TextAnnotation)textFactory.createAnnotation(TextAnnotation.class, view, arguments);
        if (textAnnotation != null && labelText != null) {
            textAnnotation.setText(labelText);
            textAnnotation.setFontSize(5.0 * zoom * (double)labelFontSize.intValue());
            this.cluster.setTextAnnotation(textAnnotation);
            if (showLabel) {
                annotationManager.addAnnotation((Annotation)textAnnotation);
            }
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Drawing cluster Text Label");
        this.drawTextLabel();
    }
}

