/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.action;

import java.util.HashSet;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.SelectClusterTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;

public class ClusterTableSelctionAction
implements ListSelectionListener {
    private AnnotationSet annotationSet;
    private JTable table;
    private HashSet<Integer> currentSelection;

    public ClusterTableSelctionAction(AnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
        this.table = annotationSet.getClusterTable();
        this.currentSelection = new HashSet();
    }

    public void valueChanged(ListSelectionEvent e) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        if (!e.getValueIsAdjusting()) {
            autoAnnotationManager.setClusterTableUpdating(true);
            int[] selectedRows = this.table.getSelectedRows();
            HashSet<Integer> newSelection = new HashSet<Integer>();
            TaskIterator currentTasks = new TaskIterator(new Task[0]);
            for (int selectedRow : selectedRows) {
                if (this.currentSelection.contains(selectedRow)) {
                    newSelection.add(selectedRow);
                }
                if (this.currentSelection.contains(selectedRow)) continue;
                newSelection.add(selectedRow);
                Cluster cluster = (Cluster)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(selectedRow), 0);
                if (this.annotationSet.isManualSelection()) {
                    if (selectedRows.length > 1) {
                        currentTasks.append((Task)new SelectClusterTask(cluster, 4));
                        continue;
                    }
                    currentTasks.append((Task)new SelectClusterTask(cluster, 2));
                    continue;
                }
                currentTasks.append((Task)new SelectClusterTask(cluster, 0));
            }
            HashSet<Integer> difference = new HashSet<Integer>();
            difference.addAll(this.currentSelection);
            difference.removeAll(newSelection);
            for (Integer todeselect : difference) {
                Cluster cluster;
                try {
                    cluster = (Cluster)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(todeselect), 0);
                }
                catch (IndexOutOfBoundsException e1) {
                    continue;
                }
                if (cluster == null) continue;
                if (this.annotationSet.isManualSelection()) {
                    currentTasks.append((Task)new SelectClusterTask(cluster, 3));
                    continue;
                }
                currentTasks.append((Task)new SelectClusterTask(cluster, 1));
            }
            this.currentSelection.clear();
            this.currentSelection.addAll(newSelection);
            CyNetwork selectedNetwork = autoAnnotationManager.getApplicationManager().getCurrentNetwork();
            if (!this.annotationSet.isManualSelection()) {
                if (currentTasks.hasNext()) {
                    Observer observer = new Observer();
                    autoAnnotationManager.getDialogTaskManager().execute(currentTasks, (TaskObserver)observer);
                    while (!observer.isFinished()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } else {
                if (currentTasks.hasNext()) {
                    autoAnnotationManager.getDialogTaskManager().execute(currentTasks);
                }
                this.annotationSet.setManualSelection(false);
            }
            autoAnnotationManager.setClusterTableUpdating(false);
        }
    }
}

