/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ExpressionFileReaderTask
extends AbstractTask {
    private String expressionFileName;
    private DataSet dataset;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public ExpressionFileReaderTask(DataSet dataset, StreamUtil streamUtil) {
        this.streamUtil = streamUtil;
        this.dataset = dataset;
        if (dataset.getExpressionSets() != null) {
            this.expressionFileName = dataset.getExpressionSets().getFilename();
        }
    }

    public void parse() throws IOException {
        boolean twoColumns = false;
        HashSet<Integer> datasetGenes = this.dataset.getDatasetGenes();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        InputStream reader = this.streamUtil.getInputStream(this.expressionFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        GeneExpressionMatrix expressionMatrix = this.dataset.getExpressionSets();
        HashMap<Integer, GeneExpression> expression = expressionMatrix.getExpressionMatrix();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            String Name = tokens[0].toUpperCase().trim();
            if (i == 0 && (expressionMatrix == null || expressionMatrix.getExpressionMatrix().isEmpty()) && expressionMatrix.getColumnNames() == null) {
                if (Name.equalsIgnoreCase("#1.2")) {
                    line = lines[2];
                    i = 2;
                } else {
                    line = lines[0];
                    int k = 0;
                    while (line.startsWith("#")) {
                        line = lines[++k];
                    }
                    i = k;
                }
                tokens = line.split("\t");
                if (tokens.length == 2) {
                    twoColumns = true;
                    try {
                        int temp = Integer.parseInt(tokens[1]);
                        i = -1;
                        tokens[0] = "Name";
                        tokens[1] = "Rank/Score";
                    }
                    catch (NumberFormatException v) {
                        try {
                            double temp2 = Double.parseDouble(tokens[1]);
                            i = -1;
                            tokens[0] = "Name";
                            tokens[1] = "Rank/Score";
                        }
                        catch (NumberFormatException v2) {
                            // empty catch block
                        }
                    }
                }
                expressionMatrix.setColumnNames(tokens);
                expressionMatrix.setNumConditions(expressionMatrix.getColumnNames().length);
                expressionMatrix.setExpressionMatrix(expression);
                continue;
            }
            if (genes.containsKey(Name)) {
                double newClosest;
                double newMin;
                Integer genekey = genes.get(Name);
                datasetGenes.add(genes.get(Name));
                String description = "";
                if (twoColumns) {
                    try {
                        Double.parseDouble(tokens[1]);
                    }
                    catch (NumberFormatException e) {
                        description = tokens[1];
                    }
                } else {
                    description = tokens[1];
                }
                GeneExpression expres = new GeneExpression(Name, description);
                expres.setExpression(tokens);
                double newMax = expres.newMax(expressionMatrix.getMaxExpression());
                if (newMax != -100.0) {
                    expressionMatrix.setMaxExpression(newMax);
                }
                if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                    expressionMatrix.setMinExpression(newMin);
                }
                if ((newClosest = expres.newclosesttoZero(expressionMatrix.getClosesttoZero())) != -100.0) {
                    expressionMatrix.setClosesttoZero(newClosest);
                }
                expression.put(genekey, expres);
            }
            int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
            long timeRemaining = this.maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing GCT file " + currentProgress + " of " + this.maxValue);
            }
            ++currentProgress;
        }
        expressionMatrix.setNumGenes(expressionMatrix.getExpressionMatrix().size());
        expressionMatrix.rowNormalizeMatrix();
    }

    private String[] setClasses(String classFile) throws IOException {
        File f = new File(classFile);
        if (!f.exists()) {
            return null;
        }
        if (!classFile.equalsIgnoreCase(null)) {
            InputStream reader = this.streamUtil.getInputStream(classFile);
            String fullText2 = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
            String[] lines2 = fullText2.split("\r\n?|\n");
            String[] classes = lines2[2].split("\\s");
            return classes;
        }
        String[] def_pheno = new String[]{"Na_pos", "NA_neg"};
        return def_pheno;
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setTitle("Parsing GCT file");
        this.parse();
    }
}

