/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.ClusterTableModel;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.UpdateAnnotationsTaskFactory;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class DeleteClusterTask
extends AbstractTask {
    private AutoAnnotationParameters params;
    private AnnotationSet annotationSet;
    private Cluster currentCluster;

    public DeleteClusterTask(AutoAnnotationParameters params) {
        this.params = params;
    }

    public DeleteClusterTask(AutoAnnotationParameters params, Cluster currentCluster) {
        this.params = params;
        this.currentCluster = currentCluster;
    }

    public DeleteClusterTask(AnnotationSet annotationSet, Cluster currentCluster) {
        this.annotationSet = annotationSet;
        this.currentCluster = currentCluster;
    }

    public void run(TaskMonitor arg0) throws Exception {
        if (this.annotationSet == null) {
            this.annotationSet = this.params.getSelectedAnnotationSet();
        }
        if (this.currentCluster == null) {
            this.deleteAction();
        } else {
            this.destroyCluster(this.currentCluster);
        }
    }

    public void deleteAction() {
        JTable clusterTable = this.annotationSet.getClusterTable();
        int[] selectedRows = clusterTable.getSelectedRows();
        if (selectedRows.length < 1) {
            JOptionPane.showMessageDialog(null, "Please select at least one cluster", "Error Message", 0);
        } else {
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
            block0: for (int rowIndex = 0; rowIndex < clusterTable.getRowCount(); ++rowIndex) {
                Cluster cluster = (Cluster)clusterTable.getModel().getValueAt(clusterTable.convertRowIndexToModel(rowIndex), 0);
                for (int selectedRow : selectedRows) {
                    if (rowIndex != selectedRow) continue;
                    selectedClusters.add(cluster);
                    continue block0;
                }
            }
            for (Cluster cluster : selectedClusters) {
                this.destroyCluster(cluster);
            }
            autoAnnotationManager.getDialogTaskManager().execute(new UpdateAnnotationsTaskFactory(this.annotationSet).createTaskIterator());
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }

    public void destroyCluster(Cluster clusterToDestroy) {
        this.destroyCloud(clusterToDestroy);
        clusterToDestroy.erase();
        if (this.annotationSet != null) {
            this.annotationSet.getClusterMap().remove(clusterToDestroy.getClusterNumber());
            ((ClusterTableModel)this.annotationSet.getClusterTable().getModel()).removeClusterFromTable(clusterToDestroy);
        }
    }

    public void destroyCloud(Cluster clusterToDestroy) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
        SynchronousTaskManager<?> syncTaskManager = autoAnnotationManager.getSyncTaskManager();
        ArrayList<String> commands = new ArrayList<String>();
        String command = "wordcloud delete cloudName=\"" + clusterToDestroy.getCloudName() + "\"";
        commands.add(command);
        TaskIterator task = executor.createTaskIterator(commands, null);
        syncTaskManager.execute(task);
    }
}

