/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.VisualizeClusterAnnotationTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class SelectClusterTask
extends AbstractTask {
    public static final int SELECTCLUSTER_WITHNODES = 0;
    public static final int DESELECTCLUSTER_WITHNODES = 1;
    public static final int SELECTCLUSTER_NONODES = 2;
    public static final int DESELECTCLUSTER_NONODES = 3;
    private Cluster cluster;
    private int selection = 0;
    private TaskMonitor taskMonitor = null;

    public SelectClusterTask(Cluster cluster, int selection) {
        this.cluster = cluster;
        this.selection = selection;
    }

    private void selectCluster(Cluster cluster) {
        if (cluster.getEllipse() != null) {
            cluster.getEllipse().setBorderColor((Paint)Color.YELLOW);
            cluster.getEllipse().setBorderWidth((double)(3 * cluster.getParent().getEllipseWidth()));
        }
        if (cluster.getTextAnnotation() != null) {
            cluster.getTextAnnotation().setTextColor(Color.YELLOW);
        }
    }

    private void deselectCluster(Cluster cluster) {
        if (cluster.getEllipse() != null) {
            cluster.getEllipse().setBorderColor((Paint)Color.DARK_GRAY);
            cluster.getEllipse().setBorderWidth((double)cluster.getParent().getEllipseWidth());
        }
        if (cluster.getTextAnnotation() != null) {
            cluster.getTextAnnotation().setTextColor(Color.BLACK);
        }
        cluster.getParent().updateCoordinates();
        if (cluster.coordinatesChanged()) {
            cluster.erase();
            VisualizeClusterAnnotationTaskFactory visualizeCluster = new VisualizeClusterAnnotationTaskFactory(cluster);
            AutoAnnotationManager.getInstance().getDialogTaskManager().execute(visualizeCluster.createTaskIterator());
        }
    }

    private void updateCloud(String command) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command);
        TaskIterator task = AutoAnnotationManager.getInstance().getCommandExecutor().createTaskIterator(commands, null);
        AutoAnnotationManager.getInstance().getSyncTaskManager().execute(task);
    }

    public void selectCluster_withnodes() {
        if (!this.cluster.isSelected()) {
            CyNetwork network = (CyNetwork)this.cluster.getParent().getView().getModel();
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            autoAnnotationManager.flushPayloadEvents();
            boolean heatMapUpdating = true;
            while (heatMapUpdating) {
                heatMapUpdating = autoAnnotationManager.isHeatMapUpdating();
            }
            this.cluster.setSelected(true);
            if (this.cluster.isCollapsed()) {
                network.getRow((CyIdentifiable)this.cluster.getGroupNode()).set("selected", (Object)true);
            } else {
                for (CyNode node : this.cluster.getNodes()) {
                    network.getRow((CyIdentifiable)node).set("selected", (Object)true);
                }
            }
            this.updateCloud("wordcloud select cloudName=\"" + this.cluster.getCloudName() + "\"");
            this.selectCluster(this.cluster);
        }
    }

    public void deselectCluster_withnodes() {
        if (this.cluster.isSelected()) {
            CyNetwork network = (CyNetwork)this.cluster.getParent().getView().getModel();
            this.cluster.setSelected(false);
            if (this.cluster.isCollapsed()) {
                network.getRow((CyIdentifiable)this.cluster.getGroupNode()).set("selected", (Object)false);
            } else {
                for (CyNode node : this.cluster.getNodes()) {
                    network.getRow((CyIdentifiable)node).set("selected", (Object)false);
                }
            }
            this.deselectCluster(this.cluster);
        }
    }

    public void selectCluster_nonodes() {
        if (!this.cluster.isSelected()) {
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            autoAnnotationManager.flushPayloadEvents();
            boolean heatMapUpdating = true;
            while (heatMapUpdating) {
                heatMapUpdating = autoAnnotationManager.isHeatMapUpdating();
            }
            this.cluster.setSelected(true);
            System.out.println("wordcloud select cloudName=\"" + this.cluster.getCloudName() + "\" updateNodeSelection=false");
            this.updateCloud("wordcloud select cloudName=\"" + this.cluster.getCloudName() + "\" updateNodeSelection=false");
            this.selectCluster(this.cluster);
        }
    }

    public void deselectCluster_nonodes() {
        if (this.cluster.isSelected()) {
            this.cluster.setSelected(false);
            this.deselectCluster(this.cluster);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        if (this.selection == 0) {
            this.selectCluster_withnodes();
        } else if (this.selection == 1) {
            this.deselectCluster_withnodes();
        } else if (this.selection == 3) {
            this.deselectCluster_nonodes();
        } else if (this.selection == 2) {
            this.selectCluster_nonodes();
        }
    }
}

