/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.util;

public class LinearNumberInterpolator {
    private final double lowerDomain;
    private final double lowerRange;
    private final double upperDomain;
    private final double upperRange;

    public LinearNumberInterpolator(double lowerDomain, double upperDomain, double lowerRange, double upperRange) {
        this.lowerDomain = lowerDomain;
        this.lowerRange = lowerRange;
        this.upperDomain = upperDomain;
        this.upperRange = upperRange;
    }

    public double getRangeValue(double domainValue) {
        if (this.lowerDomain == this.upperDomain) {
            return this.lowerRange;
        }
        double frac = (domainValue - this.lowerDomain) / (this.upperDomain - this.lowerDomain);
        return frac * this.upperRange + (1.0 - frac) * this.lowerRange;
    }

    public LinearNumberInterpolator withDomainCutoff(final double lowerValue, final double upperValue) {
        return new LinearNumberInterpolator(this.lowerDomain, this.upperDomain, this.lowerRange, this.upperRange){

            @Override
            public double getRangeValue(double domainValue) {
                if (domainValue < LinearNumberInterpolator.this.lowerDomain) {
                    return lowerValue;
                }
                if (domainValue > LinearNumberInterpolator.this.upperDomain) {
                    return upperValue;
                }
                return super.getRangeValue(domainValue);
            }
        };
    }
}

