/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractCharList;

public class CharArrayList
extends AbstractCharList {
    protected char[] elements;

    public CharArrayList() {
        this(10);
    }

    public CharArrayList(char[] cArray) {
        this.elements(cArray);
    }

    public CharArrayList(int n) {
        this(new char[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        CharArrayList charArrayList = new CharArrayList((char[])this.elements.clone());
        charArrayList.setSizeRaw(this.size);
        return charArrayList;
    }

    public char[] elements() {
        return this.elements;
    }

    public AbstractCharList elements(char[] cArray) {
        this.elements = cArray;
        this.size = cArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        CharArrayList charArrayList = (CharArrayList)object;
        if (this.size() != charArrayList.size()) {
            return false;
        }
        char[] cArray = this.elements();
        char[] cArray2 = charArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (cArray[n] == cArray2[n]) continue;
            return false;
        }
        return true;
    }

    public char get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public char getQuick(int n) {
        return this.elements[n];
    }

    public AbstractCharList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new CharArrayList(0);
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = new char[n2 - n + 1];
        System.arraycopy(this.elements, n, cArray, 0, n2 - n + 1);
        return new CharArrayList(cArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractCharList abstractCharList, int n3) {
        if (!(abstractCharList instanceof CharArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractCharList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            CharArrayList.checkRangeFromTo(n, n2, this.size());
            CharArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractCharList.size());
            System.arraycopy(((CharArrayList)abstractCharList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, char c) {
        this.elements[n] = c;
    }
}

