/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.actions.ParametersPanelActionListener;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.view.LegendPanel;
import org.baderlab.csplugins.enrichmentmap.view.SliderBarPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.OpenBrowser;

public class ParametersPanel
extends JPanel
implements CytoPanelComponent {
    public static int summaryPanelWidth = 150;
    public static int summaryPanelHeight = 1000;
    private JCheckBox heatmapAutofocusCheckbox;
    private EnrichmentMapParameters emParams;
    private EnrichmentMap map;
    private OpenBrowser browser;
    private CyApplicationManager cyApplicationManager;

    public ParametersPanel(OpenBrowser browser, CyApplicationManager cyApplicationManager) {
        this.browser = browser;
        this.cyApplicationManager = cyApplicationManager;
    }

    public void initializeSliders(EnrichmentMap map) {
        if (map != null) {
            map.getParams().initSliders();
        }
    }

    public void updatePanel(EnrichmentMap map) {
        this.map = map;
        this.emParams = map.getParams();
        EnrichmentMapParameters params = map.getParams();
        this.removeAll();
        this.revalidate();
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout(0, 3));
        JPanel legends = this.createLegend(params, map);
        main.add((Component)legends, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setAlignmentX(0.0f);
        if (params.getMethod().equalsIgnoreCase("GSEA")) {
            final String reportFileDataset1 = this.resolveGseaReportFilePath(params, 1);
            final String reportFileDataset2 = this.resolveGseaReportFilePath(params, 2);
            if (reportFileDataset1 != null) {
                JButton openReport1Button = new JButton("Open GSEA report Dataset 1");
                openReport1Button.setAlignmentX(0.0f);
                openReport1Button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ParametersPanel.this.browser.openURL("file://" + reportFileDataset1);
                    }
                });
                if (!new File(reportFileDataset1).canRead()) {
                    openReport1Button.setEnabled(false);
                    openReport1Button.setToolTipText("Report file not found: " + reportFileDataset1);
                }
                centerPanel.add(openReport1Button);
            }
            if (reportFileDataset2 != null) {
                JButton openReport2Button = new JButton("Open GSEA-report Dataset 2");
                openReport2Button.setAlignmentX(0.0f);
                openReport2Button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ParametersPanel.this.browser.openURL("file://" + reportFileDataset2);
                    }
                });
                if (!new File(reportFileDataset2).canRead()) {
                    openReport2Button.setEnabled(false);
                    openReport2Button.setToolTipText("Report file not found: " + reportFileDataset2);
                }
                centerPanel.add(openReport2Button);
            }
        }
        JTextPane runInfo = new JTextPane();
        runInfo.setEditable(false);
        runInfo.setContentType("text/html");
        runInfo.setText(this.getRunInfo(params));
        CollapsiblePanel runInfoPanel = new CollapsiblePanel("current Parameters");
        runInfoPanel.setCollapsed(true);
        runInfoPanel.getContentPane().add(runInfo);
        centerPanel.add(runInfoPanel);
        main.add((Component)centerPanel, "Center");
        CollapsiblePanel preferences = new CollapsiblePanel("advanced Preferences");
        preferences.setCollapsed(true);
        JPanel prefsPanel = new JPanel();
        prefsPanel.setLayout(new BoxLayout(prefsPanel, 1));
        this.heatmapAutofocusCheckbox = new JCheckBox(new AbstractAction("Heatmap autofocus"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ParametersPanel.this.emParams.isDisableHeatmapAutofocus()) {
                            ParametersPanel.this.emParams.setDisableHeatmapAutofocus(false);
                        } else {
                            ParametersPanel.this.emParams.setDisableHeatmapAutofocus(true);
                        }
                        ParametersPanel.this.heatmapAutofocusCheckbox.setSelected(!ParametersPanel.this.emParams.isDisableHeatmapAutofocus());
                    }
                });
            }
        });
        this.heatmapAutofocusCheckbox.setSelected(!params.isDisableHeatmapAutofocus());
        prefsPanel.add(this.heatmapAutofocusCheckbox);
        ButtonGroup sorting_methods = new ButtonGroup();
        JPanel sortingPanel = new JPanel();
        sortingPanel.setLayout(new BoxLayout(sortingPanel, 1));
        JRadioButton hc = new JRadioButton(HeatMapParameters.sort_hierarchical_cluster);
        hc.setActionCommand(HeatMapParameters.sort_hierarchical_cluster);
        hc.setSelected(false);
        JRadioButton nosort = new JRadioButton(HeatMapParameters.sort_none);
        nosort.setActionCommand(HeatMapParameters.sort_none);
        nosort.setSelected(false);
        JRadioButton ranks = new JRadioButton(HeatMapParameters.sort_rank);
        ranks.setActionCommand(HeatMapParameters.sort_rank);
        ranks.setSelected(false);
        JRadioButton columns = new JRadioButton(HeatMapParameters.sort_column);
        columns.setActionCommand(HeatMapParameters.sort_column);
        columns.setSelected(false);
        if (params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) {
            hc.setSelected(true);
        }
        if (params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_none)) {
            nosort.setSelected(true);
        }
        if (params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_rank)) {
            ranks.setSelected(true);
        }
        if (params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_column)) {
            columns.setSelected(true);
        }
        hc.addActionListener(new ParametersPanelActionListener(map));
        sorting_methods.add(hc);
        nosort.addActionListener(new ParametersPanelActionListener(map));
        sorting_methods.add(nosort);
        ranks.addActionListener(new ParametersPanelActionListener(map));
        sorting_methods.add(ranks);
        columns.addActionListener(new ParametersPanelActionListener(map));
        sorting_methods.add(columns);
        sortingPanel.add(new JLabel("Default Sorting Order:"));
        sortingPanel.add(hc);
        sortingPanel.add(ranks);
        sortingPanel.add(columns);
        sortingPanel.add(nosort);
        preferences.getContentPane().add((Component)sortingPanel, "Center");
        preferences.getContentPane().add((Component)prefsPanel, "North");
        ButtonGroup distance_metric = new ButtonGroup();
        JPanel dm_Panel = new JPanel();
        dm_Panel.setLayout(new BoxLayout(dm_Panel, 1));
        JRadioButton pearson = new JRadioButton(HeatMapParameters.pearson_correlation);
        pearson.setActionCommand(HeatMapParameters.pearson_correlation);
        pearson.setSelected(false);
        JRadioButton cosine = new JRadioButton(HeatMapParameters.cosine);
        cosine.setActionCommand(HeatMapParameters.cosine);
        cosine.setSelected(false);
        JRadioButton euclidean = new JRadioButton(HeatMapParameters.euclidean);
        euclidean.setActionCommand(HeatMapParameters.euclidean);
        euclidean.setSelected(false);
        if (params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.pearson_correlation)) {
            pearson.setSelected(true);
        }
        if (params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.cosine)) {
            cosine.setSelected(true);
        }
        if (params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.euclidean)) {
            euclidean.setSelected(true);
        }
        pearson.addActionListener(new ParametersPanelActionListener(map));
        distance_metric.add(pearson);
        cosine.addActionListener(new ParametersPanelActionListener(map));
        distance_metric.add(cosine);
        euclidean.addActionListener(new ParametersPanelActionListener(map));
        distance_metric.add(euclidean);
        dm_Panel.add(new JLabel("Default Distance Metric:"));
        dm_Panel.add(pearson);
        dm_Panel.add(cosine);
        dm_Panel.add(euclidean);
        preferences.getContentPane().add((Component)dm_Panel, "South");
        main.add((Component)preferences, "South");
        JScrollPane jScrollPane = new JScrollPane(main);
        this.add(jScrollPane);
        this.revalidate();
    }

    private String getRunInfo(EnrichmentMapParameters params) {
        String runInfoText = "<html>";
        runInfoText = runInfoText + "<b>P-value Cut-off:</b>" + params.getPvalue() + "<br>";
        runInfoText = runInfoText + "<b>FDR Q-value Cut-off:</b>" + params.getQvalue() + "<br>";
        if (params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            runInfoText = runInfoText + "<b>Jaccard Cut-off:</b>" + params.getSimilarityCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Jaccard Index<br>";
        } else if (params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            runInfoText = runInfoText + "<b>Overlap Cut-off:</b>" + params.getSimilarityCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Overlap Index<br>";
        } else if (params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            runInfoText = runInfoText + "<b>Jaccard Overlap Combined Cut-off:</b>" + params.getSimilarityCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Jaccard Overlap Combined Index (k constant = " + params.getCombinedConstant() + ")<br>";
        }
        runInfoText = runInfoText + "<font size=-1><b>Genesets File:</b>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 1").getGMTFileName()) + "<br>";
        runInfoText = runInfoText + "<b>Dataset 1 Data Files:</b> " + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 1").getEnrichmentFileName1()) + ",<br>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 1").getEnrichmentFileName2()) + "<br>";
        if (params.isTwoDatasets()) {
            runInfoText = runInfoText + "<b>Dataset 2 Data Files:</b> " + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 2").getEnrichmentFileName1()) + ",<br>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 2").getEnrichmentFileName2()) + "<br>";
        }
        if (params.isData()) {
            runInfoText = runInfoText + "<b>Data file:</b>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 1").getExpressionFileName()) + "<br>";
        }
        if (this.map.getParams().getFiles().containsKey("Dataset 1") && this.map.getParams().getFiles().get("Dataset 1").getGseaHtmlReportFile() != null) {
            runInfoText = runInfoText + "<b>GSEA Report 1:</b>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 1").getGseaHtmlReportFile()) + "<br>";
        }
        if (this.map.getParams().getFiles().containsKey("Dataset 2") && this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile() != null) {
            runInfoText = runInfoText + "<b>GSEA Report 2:</b>" + this.shortenPathname(this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile()) + "<br>";
        }
        runInfoText = runInfoText + "</font></html>";
        return runInfoText;
    }

    private JPanel createLegend(EnrichmentMapParameters params, EnrichmentMap map) {
        JPanel legends = new JPanel();
        this.setPreferredSize(new Dimension(summaryPanelWidth, summaryPanelHeight / 2));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        legends.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 0;
        c.gridheight = 1;
        c.anchor = 21;
        c.insets = new Insets(5, 30, 5, 2);
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 0;
        URL nodeIconURL = this.getClass().getResource("node_color_small.png");
        if (nodeIconURL != null) {
            ImageIcon nodeIcon = new ImageIcon(nodeIconURL);
            JLabel nodeColorLabel = new JLabel(nodeIcon);
            gridbag.setConstraints(nodeColorLabel, c);
            legends.add(nodeColorLabel);
        }
        LegendPanel node_legend = new LegendPanel(EnrichmentMapVisualStyle.max_phenotype1, EnrichmentMapVisualStyle.max_phenotype2, map.getDataset("Dataset 1").getEnrichments().getPhenotype1(), map.getDataset("Dataset 1").getEnrichments().getPhenotype2());
        node_legend.setToolTipText("Phenotype * (1-P_value)");
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(node_legend, c);
        legends.add(node_legend);
        if (params.isTwoDatasets()) {
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(5, 30, 5, 2);
            URL nodeborderIconURL = this.getClass().getResource("node_border_color_small.png");
            if (nodeborderIconURL != null) {
                ImageIcon nodeborderIcon = new ImageIcon(nodeborderIconURL);
                JLabel nodeborderColorLabel = new JLabel(nodeborderIcon);
                gridbag.setConstraints(nodeborderColorLabel, c);
                legends.add(nodeborderColorLabel);
            }
            LegendPanel node_legend2 = new LegendPanel(EnrichmentMapVisualStyle.max_phenotype1, EnrichmentMapVisualStyle.max_phenotype2, map.getDataset("Dataset 2").getEnrichments().getPhenotype1(), map.getDataset("Dataset 2").getEnrichments().getPhenotype2());
            node_legend2.setToolTipText("Phenotype * (1-P_value)");
            c.gridx = 0;
            c.gridy = 3;
            c.insets = new Insets(0, 0, 0, 0);
            gridbag.setConstraints(node_legend2, c);
            legends.add(node_legend2);
        }
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 21;
        SliderBarPanel pvalueSlider = params.getPvalueSlider();
        gridbag.setConstraints(pvalueSlider, c);
        legends.add(pvalueSlider);
        if (params.isFDR()) {
            SliderBarPanel qvalueSlider = params.getQvalueSlider();
            c.gridx = 0;
            c.gridy = 5;
            gridbag.setConstraints(qvalueSlider, c);
            legends.add(qvalueSlider);
            SliderBarPanel similaritySlider = params.getSimilaritySlider();
            c.gridx = 0;
            c.gridy = 6;
            gridbag.setConstraints(similaritySlider, c);
            legends.add(similaritySlider);
        } else {
            SliderBarPanel similaritySlider = params.getSimilaritySlider();
            c.gridx = 0;
            c.gridy = 5;
            gridbag.setConstraints(similaritySlider, c);
            legends.add(similaritySlider);
        }
        return legends;
    }

    private String shortenPathname(String pathname) {
        if (pathname != null) {
            String[] tokens = pathname.split("\\" + File.separator);
            int num_tokens = tokens.length;
            String new_pathname = num_tokens >= 2 ? "..." + File.separator + tokens[num_tokens - 2] + File.separator + tokens[num_tokens - 1] : pathname;
            return new_pathname;
        }
        return pathname;
    }

    private String resolveGseaReportFilePath(EnrichmentMapParameters params, int dataset) {
        String reportFile = null;
        String netwAttrName = null;
        if (dataset == 1) {
            if (this.map.getParams().getFiles().containsKey("Dataset 1")) {
                reportFile = this.map.getParams().getFiles().get("Dataset 1").getGseaHtmlReportFile();
                netwAttrName = "GSEA_Report_Dataset1_folder";
            }
        } else if (this.map.getParams().getFiles().containsKey("Dataset 2")) {
            reportFile = this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile();
            netwAttrName = "GSEA_Report_Dataset2_folder";
        }
        if (reportFile != null && new File(reportFile).canRead()) {
            return reportFile;
        }
        if (netwAttrName != null) {
            CyNetwork network = this.cyApplicationManager.getCurrentNetwork();
            CyTable networkTable = network.getDefaultNetworkTable();
            String tryPath = (String)networkTable.getRow((Object)network.getSUID()).get(netwAttrName, String.class);
            String tryReportFile = tryPath + File.separator + "index.html";
            if (new File(tryReportFile).canRead()) {
                return tryReportFile;
            }
            if (reportFile == null || reportFile.equalsIgnoreCase("null")) {
                return null;
            }
            return reportFile;
        }
        return null;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.EAST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Legend";
    }
}

