/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.task.Hypergeometric;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class FilterSignatureGSTask
extends AbstractTask {
    private final EnrichmentMap map;
    private final PostAnalysisParameters paParams;
    private final PostAnalysisInputPanel paPanel;

    public FilterSignatureGSTask(EnrichmentMap map, PostAnalysisParameters paParams, PostAnalysisInputPanel paPanel) {
        this.map = map;
        this.paParams = paParams;
        this.paPanel = paPanel;
    }

    private void filterSignatureGS(TaskMonitor taskMonitor) {
        try {
            DefaultListModel<String> signatureSetNames = this.paParams.getSignatureSetNames();
            DefaultListModel<String> selectedSignatureSetNames = this.paParams.getSelectedSignatureSetNames();
            signatureSetNames.clear();
            HashMap<String, GeneSet> genesets_in_map = this.map.getAllGenesetsOfInterest();
            Object[] setNamesArray = this.paParams.getSignatureGenesets().getGenesets().keySet().toArray(new String[0]);
            Arrays.sort(setNamesArray);
            FilterMetric filterMetric = null;
            for (int i = 0; i < setNamesArray.length; ++i) {
                int percentComplete = (int)((double)i / (double)setNamesArray.length * 100.0);
                taskMonitor.setStatusMessage("Analyzing geneset " + (i + 1) + " of " + setNamesArray.length);
                taskMonitor.setProgress((double)percentComplete);
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                Object signatureGeneset = setNamesArray[i];
                if (selectedSignatureSetNames.contains(signatureGeneset)) continue;
                boolean matchfound = false;
                if (this.paParams.isFilter()) {
                    if (filterMetric == null) {
                        filterMetric = this.createFilterMetric(this.paParams);
                        filterMetric.init();
                    }
                    for (String mapGeneset : genesets_in_map.keySet()) {
                        HashSet<Integer> mapset = new HashSet<Integer>(genesets_in_map.get(mapGeneset).getGenes());
                        int original_size = mapset.size();
                        HashSet<Integer> paset = new HashSet<Integer>(this.paParams.getSignatureGenesets().getGenesets().get(signatureGeneset).getGenes());
                        mapset.retainAll(paset);
                        matchfound = filterMetric.match(original_size, mapset, paset);
                        if (!matchfound) continue;
                        break;
                    }
                } else {
                    matchfound = true;
                }
                if (!matchfound || signatureSetNames.contains(signatureGeneset)) continue;
                signatureSetNames.addElement((String)signatureGeneset);
                if (this.paPanel == null) continue;
                this.paPanel.setAvSigCount(signatureSetNames.size());
            }
        }
        catch (InterruptedException e) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "loading of GMT files cancelled");
        }
    }

    private FilterMetric createFilterMetric(PostAnalysisParameters paParams) {
        switch (paParams.getSignature_filterMetric()) {
            default: {
                return new NumberFilterMetric();
            }
            case PERCENT: {
                return new PercentFilterMetric();
            }
            case SPECIFIC: {
                return new SpecificFilterMetric();
            }
            case HYPERGEOM: {
                return new HypergeomFilterMetric();
            }
            case MANN_WHIT: 
        }
        return new MannWhitFilterMetric();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("filtering Signature Gene set file");
        this.filterSignatureGS(taskMonitor);
    }

    private class MannWhitFilterMetric
    implements FilterMetric {
        private Ranking ranks;

        private MannWhitFilterMetric() {
        }

        @Override
        public void init() {
            HashMap<String, DataSet> data_sets = FilterSignatureGSTask.this.map.getDatasets();
            DataSet dataset = (DataSet)data_sets.get(FilterSignatureGSTask.this.paParams.getSignature_dataSet());
            this.ranks = new Ranking();
            if (dataset != null) {
                this.ranks = dataset.getExpressionSets().getRanks().get(FilterSignatureGSTask.this.paParams.getSignature_rankFile());
            }
        }

        @Override
        public boolean match(int original_size, Set<Integer> mapset, Set<Integer> paset) {
            Map<Integer, Double> gene2score = this.ranks.getGene2Score();
            Object[] overlap_gene_ids = mapset.toArray();
            if (overlap_gene_ids.length > 0) {
                double[] overlap_gene_scores = new double[overlap_gene_ids.length];
                for (int p = 0; p < overlap_gene_ids.length; ++p) {
                    overlap_gene_scores[p] = gene2score.get(overlap_gene_ids[p]);
                }
                MannWhitneyUTest mann_whit = new MannWhitneyUTest();
                double[] scores = this.ranks.getScores();
                double mannPval = mann_whit.mannWhitneyUTest(overlap_gene_scores, scores);
                if (mannPval <= FilterSignatureGSTask.this.paParams.getSignature_Mann_Whit_Cutoff()) {
                    return true;
                }
            }
            return false;
        }
    }

    private class HypergeomFilterMetric
    implements FilterMetric {
        int N;

        private HypergeomFilterMetric() {
        }

        @Override
        public void init() {
            this.N = FilterSignatureGSTask.this.paParams.getUniverseSize();
        }

        @Override
        public boolean match(int original_size, Set<Integer> mapset, Set<Integer> paset) {
            double hyperPval;
            int n = paset.size();
            int m = original_size;
            int k = mapset.size();
            try {
                hyperPval = k > 0 ? Hypergeometric.hyperGeomPvalue_sum(this.N, n, m, k, 0) : 1.0;
            }
            catch (ArithmeticException e) {
                e.printStackTrace();
                return false;
            }
            return hyperPval <= FilterSignatureGSTask.this.paParams.getSignature_Hypergeom_Cutoff();
        }
    }

    private class SpecificFilterMetric
    implements FilterMetric {
        private SpecificFilterMetric() {
        }

        @Override
        public void init() {
        }

        @Override
        public boolean match(int original_size, Set<Integer> mapset, Set<Integer> paset) {
            Double relative_per = (double)mapset.size() / Integer.valueOf(paset.size()).doubleValue();
            return relative_per >= Double.valueOf((double)FilterSignatureGSTask.this.paParams.getFilterValue() / 100.0);
        }
    }

    private class NumberFilterMetric
    implements FilterMetric {
        private NumberFilterMetric() {
        }

        @Override
        public void init() {
        }

        @Override
        public boolean match(int original_size, Set<Integer> mapset, Set<Integer> paset) {
            Double relative_per = (double)mapset.size() / Integer.valueOf(paset.size()).doubleValue();
            return relative_per >= Double.valueOf((double)FilterSignatureGSTask.this.paParams.getFilterValue() / 100.0);
        }
    }

    private class PercentFilterMetric
    implements FilterMetric {
        private PercentFilterMetric() {
        }

        @Override
        public void init() {
        }

        @Override
        public boolean match(int original_size, Set<Integer> mapset, Set<Integer> paset) {
            Double relative_per = (double)mapset.size() / (double)original_size;
            return relative_per >= Double.valueOf((double)FilterSignatureGSTask.this.paParams.getFilterValue() / 100.0);
        }
    }

    private static interface FilterMetric {
        public void init();

        public boolean match(int var1, Set<Integer> var2, Set<Integer> var3);
    }
}

