/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfo;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfoNumberComparator;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class Cluster
implements Comparable<Cluster> {
    private int clusterNumber;
    private String cloudName;
    private CyGroup group;
    private HashMap<CyNode, double[]> nodesToCoordinates;
    private int size = 0;
    private String label;
    private TextAnnotation textAnnotation;
    private ShapeAnnotation ellipse;
    private AnnotationSet parent;
    private boolean selected = false;
    private ArrayList<WordInfo> wordInfos;
    private HashMap<CyNode, Double> nodesToRadii;
    private HashMap<CyNode, Double> nodesToCentralities;
    private String mostCentralNodeLabel;
    private boolean coordinatesChanged = true;
    private double[] bounds = new double[4];
    private Set<CyNode> nodes;

    public Cluster() {
        this.wordInfos = new ArrayList();
        this.nodesToCoordinates = new HashMap();
        this.nodesToRadii = new HashMap();
        this.nodesToCentralities = new HashMap();
        this.nodes = new HashSet<CyNode>();
    }

    public Cluster(int clusterNumber, AnnotationSet parent) {
        this.clusterNumber = clusterNumber;
        this.parent = parent;
        this.cloudName = parent.getName() + " Cloud " + clusterNumber;
        this.wordInfos = new ArrayList();
        this.nodesToCoordinates = new HashMap();
        this.nodesToRadii = new HashMap();
        this.nodesToCentralities = new HashMap();
        this.nodes = new HashSet<CyNode>();
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public CyGroup getGroup() {
        return this.group;
    }

    public AnnotationSet getParent() {
        return this.parent;
    }

    public double[] getBounds() {
        if (this.coordinatesChanged) {
            double xmin = 1.0E8;
            double ymin = 1.0E8;
            double xmax = -1.0E8;
            double ymax = -1.0E8;
            for (double[] coordinates : this.nodesToCoordinates.values()) {
                xmin = coordinates[0] < xmin ? coordinates[0] : xmin;
                xmax = coordinates[0] > xmax ? coordinates[0] : xmax;
                ymin = coordinates[1] < ymin ? coordinates[1] : ymin;
                ymax = coordinates[1] > ymax ? coordinates[1] : ymax;
            }
            this.bounds[0] = xmin;
            this.bounds[1] = xmax;
            this.bounds[2] = ymin;
            this.bounds[3] = ymax;
            this.coordinatesChanged = false;
        }
        return this.bounds;
    }

    public void setParent(AnnotationSet annotationSet) {
        this.parent = annotationSet;
    }

    public boolean isCollapsed() {
        if (this.group != null) {
            return this.group.isCollapsed((CyNetwork)this.parent.getView().getModel());
        }
        return false;
    }

    public CyNode getGroupNode() {
        if (this.group != null) {
            return this.group.getGroupNode();
        }
        return null;
    }

    public HashMap<CyNode, double[]> getNodesToCoordinates() {
        return this.nodesToCoordinates;
    }

    public HashMap<CyNode, Double> getNodesToRadii() {
        return this.nodesToRadii;
    }

    public void addNodeCoordinates(CyNode node, double[] coordinates) {
        if (!this.nodesToCoordinates.containsKey(node)) {
            ++this.size;
            if (this.group != null && this.group.getGroupNode() != node) {
                ArrayList<CyNode> nodeToAdd = new ArrayList<CyNode>();
                nodeToAdd.add(node);
                this.group.addNodes(nodeToAdd);
            }
            this.nodes.add(node);
            this.nodesToCoordinates.put(node, coordinates);
        } else if (this.coordinatesHaveChanged(this.nodesToCoordinates.get(node), coordinates)) {
            this.nodesToCoordinates.put(node, coordinates);
            this.coordinatesChanged = true;
        }
    }

    public void updateCoordinates() {
        View nodeView;
        boolean hasNodeViews = false;
        for (CyNode node : this.getNodes()) {
            View nodeView2 = this.parent.getView().getNodeView(node);
            if (nodeView2 != null) {
                hasNodeViews = true;
                double[] coordinates = new double[]{(Double)nodeView2.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION), (Double)nodeView2.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)};
                double nodeRadius = (Double)nodeView2.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
                double[] default_coordinates = new double[]{0.0, 0.0};
                double[] previous_coordinates = this.nodesToCoordinates.containsKey(node) ? this.nodesToCoordinates.get(node) : default_coordinates;
                if (!this.coordinatesHaveChanged(coordinates, previous_coordinates)) continue;
                this.setCoordinatesChanged(true);
                this.addNodeCoordinates(node, coordinates);
                this.addNodeRadius(node, nodeRadius);
                continue;
            }
            if (this.nodesToCoordinates.containsKey(node)) {
                this.nodesToCoordinates.remove(node);
            }
            if (!this.nodesToRadii.containsKey(node)) continue;
            this.nodesToRadii.remove(node);
        }
        if (!hasNodeViews && (nodeView = this.parent.getView().getNodeView(this.getGroupNode())) != null) {
            hasNodeViews = true;
            double[] coordinates = new double[]{(Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION), (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)};
            double nodeRadius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
            this.setCoordinatesChanged(true);
            this.addNodeCoordinates(this.getGroupNode(), coordinates);
            this.addNodeRadius(this.getGroupNode(), nodeRadius);
        }
    }

    private boolean coordinatesHaveChanged(double[] oldCoordinates, double[] newCoordinates) {
        return oldCoordinates == null || Math.abs(oldCoordinates[0] - newCoordinates[0]) > 0.01 && Math.abs(oldCoordinates[1] - newCoordinates[1]) > 0.01;
    }

    public void addNodeRadius(CyNode node, double radius) {
        this.nodesToRadii.put(node, radius);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setGroup(CyGroup group) {
        this.group = group;
    }

    public int getSize() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public ShapeAnnotation getEllipse() {
        return this.ellipse;
    }

    public void setEllipse(ShapeAnnotation ellipse) {
        this.ellipse = ellipse;
    }

    public TextAnnotation getTextAnnotation() {
        return this.textAnnotation;
    }

    public void setTextAnnotation(TextAnnotation textAnnotation) {
        this.textAnnotation = textAnnotation;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void erase() {
        this.eraseText();
        this.eraseEllipse();
    }

    public void eraseText() {
        if (this.textAnnotation != null) {
            this.textAnnotation.removeAnnotation();
        }
    }

    public void eraseEllipse() {
        if (this.ellipse != null) {
            this.ellipse.removeAnnotation();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public ArrayList<WordInfo> getWordInfos() {
        return this.wordInfos;
    }

    public void setWordInfos(ArrayList<WordInfo> wordInfos) {
        this.wordInfos = wordInfos;
    }

    public void setNodesToCentralities(HashMap<CyNode, Double> nodesToCentralities) {
        this.nodesToCentralities = nodesToCentralities;
    }

    public String getMostCentralNodeLabel() {
        if (this.mostCentralNodeLabel == null) {
            CyNode maxNode = this.nodesToCoordinates.keySet().iterator().next();
            double maxCentrality = -1.0;
            for (CyNode node : this.nodesToCentralities.keySet()) {
                double centrality = this.nodesToCentralities.get(node);
                if (!(centrality > maxCentrality)) continue;
                maxNode = node;
                maxCentrality = centrality;
            }
            this.mostCentralNodeLabel = (String)((CyNetwork)this.parent.getView().getModel()).getRow((CyIdentifiable)maxNode).get(this.parent.getNameColumnName(), String.class);
        }
        return this.mostCentralNodeLabel;
    }

    public void removeGroup() {
        this.group = null;
    }

    @Override
    public int compareTo(Cluster cluster2) {
        return this.label.compareTo(cluster2.getLabel());
    }

    public Set<CyNode> getNodes() {
        return this.nodes;
    }

    public void removeNode(CyNode nodeToRemove) {
        if (this.nodesToCoordinates.containsKey(nodeToRemove) || this.nodes.contains(nodeToRemove) || this.nodesToRadii.containsKey(nodeToRemove)) {
            if (this.nodes.contains(nodeToRemove)) {
                this.nodes.remove(nodeToRemove);
            }
            if (this.nodesToCoordinates.containsKey(nodeToRemove)) {
                this.nodesToCoordinates.remove(nodeToRemove);
            }
            if (this.nodesToRadii.containsKey(nodeToRemove)) {
                this.nodesToRadii.remove(nodeToRemove);
            }
            if (this.group != null) {
                ArrayList<CyNode> node = new ArrayList<CyNode>();
                node.add(nodeToRemove);
                this.group.removeNodes(new ArrayList(node));
            }
            --this.size;
        }
    }

    public void swallow(Cluster cluster2) {
        HashMap<CyNode, double[]> cluster2NodesToCoordinates = cluster2.getNodesToCoordinates();
        HashMap<CyNode, Double> cluster2NodesToRadii = cluster2.getNodesToRadii();
        for (CyNode cyNode : cluster2NodesToCoordinates.keySet()) {
            this.addNodeCoordinates(cyNode, cluster2NodesToCoordinates.get(cyNode));
            this.addNodeRadius(cyNode, cluster2NodesToRadii.get(cyNode));
        }
        for (Map.Entry entry : cluster2.getNodesToCoordinates().entrySet()) {
            this.addNodeCoordinates((CyNode)entry.getKey(), (double[])entry.getValue());
        }
    }

    public String makeLabel(ArrayList<WordInfo> wordInfos, String mostCentralNodeLabel, double sameClusterBonus, double centralityBonus, List<Integer> wordSizeThresholds, int maxWords) {
        ArrayList<WordInfo> wordInfosCopy = new ArrayList<WordInfo>();
        for (WordInfo wordInfo : wordInfos) {
            wordInfosCopy.add(wordInfo.clone());
        }
        if (wordInfosCopy.size() == 0) {
            return "";
        }
        Collections.sort(wordInfosCopy);
        WordInfo biggestWord = (WordInfo)wordInfosCopy.get(0);
        ArrayList<WordInfo> label = new ArrayList<WordInfo>();
        label.add(biggestWord);
        int numWords = 1;
        WordInfo nextWord = biggestWord;
        wordInfosCopy.remove(0);
        for (WordInfo word : wordInfosCopy) {
            if (!mostCentralNodeLabel.toLowerCase().contains(word.getWord())) continue;
            word.setSize(word.getSize() + centralityBonus);
        }
        while (numWords < maxWords && wordInfosCopy.size() > 0) {
            for (WordInfo word : wordInfosCopy) {
                if (word.getCluster() != nextWord.getCluster()) continue;
                word.setSize(word.getSize() + sameClusterBonus);
            }
            Collections.sort(wordInfosCopy);
            double wordSizeThreshold = nextWord.getSize() * (double)wordSizeThresholds.get(numWords - 1).intValue() / 100.0;
            nextWord = (WordInfo)wordInfosCopy.get(0);
            wordInfosCopy.remove(0);
            if (!(nextWord.getSize() > wordSizeThreshold)) break;
            label.add(nextWord);
            ++numWords;
        }
        Collections.sort(label, WordInfoNumberComparator.getInstance());
        return this.join(label, " ");
    }

    private String join(List<WordInfo> stringList, String separator) {
        String joined = "";
        for (int index = 0; index < stringList.size(); ++index) {
            joined = index == 0 ? joined + stringList.get(index).getWord() : joined + separator + stringList.get(index).getWord();
        }
        return joined;
    }

    public String toSessionString() {
        String sessionString = "";
        sessionString = sessionString + this.clusterNumber + "\n";
        sessionString = sessionString + this.label + "\n";
        sessionString = sessionString + this.selected + "\n";
        if (this.ellipse != null) {
            Map ellipseArgs = this.ellipse.getArgMap();
            for (String property : ellipseArgs.keySet()) {
                sessionString = sessionString + property + "\t" + (String)ellipseArgs.get(property) + "\n";
            }
        }
        if (this.textAnnotation != null) {
            sessionString = sessionString + "Text Annotations\n";
            Map textArgs = this.textAnnotation.getArgMap();
            for (String property : textArgs.keySet()) {
                sessionString = sessionString + property + "\t" + (String)textArgs.get(property) + "\n";
            }
            sessionString = sessionString + "End of annotations\n";
        }
        if (this.group != null && this.group.isCollapsed((CyNetwork)this.parent.getView().getModel())) {
            this.group.expand((CyNetwork)this.parent.getView().getModel());
        }
        this.updateCoordinates();
        for (CyNode node : this.nodesToCoordinates.keySet()) {
            long nodeID = node.getSUID();
            double[] coordinates = this.nodesToCoordinates.get(node);
            double nodeX = coordinates[0];
            double nodeY = coordinates[1];
            double nodeRadius = this.nodesToRadii.get(node);
            double nodeCentrality = this.nodesToCentralities.get(node);
            sessionString = sessionString + nodeID + "\t" + nodeX + "\t" + nodeY + "\t" + nodeRadius + "\t" + nodeCentrality + "\n";
        }
        sessionString = sessionString + "End of nodes\n";
        sessionString = sessionString + "End of cluster\n";
        return sessionString;
    }

    public void load(ArrayList<String> text, CySession session) {
        String[] splitLine;
        this.clusterNumber = Integer.valueOf(text.get(0));
        this.cloudName = this.parent.getName() + " Cloud " + this.clusterNumber;
        this.label = text.get(1);
        this.selected = Boolean.valueOf(text.get(2));
        int lineNumber = 3;
        String line = text.get(lineNumber);
        HashMap<String, String> ellipseMap = new HashMap<String, String>();
        while (!line.equals("Text Annotations")) {
            String[] splitLine2 = line.split("\t");
            ellipseMap.put(splitLine2[0], splitLine2[1]);
            line = text.get(++lineNumber);
        }
        this.ellipse = (ShapeAnnotation)AutoAnnotationManager.getInstance().getShapeFactory().createAnnotation(ShapeAnnotation.class, this.parent.getView(), ellipseMap);
        line = text.get(++lineNumber);
        HashMap<String, String> textMap = new HashMap<String, String>();
        while (!line.equals("End of annotations")) {
            splitLine = line.split("\t");
            textMap.put(splitLine[0], splitLine[1]);
            line = text.get(++lineNumber);
        }
        this.textAnnotation = (TextAnnotation)AutoAnnotationManager.getInstance().getTextFactory().createAnnotation(TextAnnotation.class, this.parent.getView(), textMap);
        line = text.get(++lineNumber);
        while (!line.equals("End of nodes")) {
            splitLine = line.split("\t");
            CyNode node = (CyNode)session.getObject(Long.valueOf(splitLine[0]), CyNode.class);
            double[] nodeCoordinates = new double[]{Double.valueOf(splitLine[1]), Double.valueOf(splitLine[2])};
            this.addNodeCoordinates(node, nodeCoordinates);
            double nodeRadius = Double.valueOf(splitLine[3]);
            this.addNodeRadius(node, nodeRadius);
            double nodeCentrality = Double.valueOf(splitLine[4]);
            this.nodesToCentralities.put(node, nodeCentrality);
            line = text.get(++lineNumber);
        }
    }

    public String toString() {
        return this.label;
    }

    public boolean coordinatesChanged() {
        return this.coordinatesChanged;
    }

    public void setCoordinatesChanged(boolean b) {
        this.coordinatesChanged = b;
    }
}

