/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import javax.swing.DefaultListModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;

public class PostAnalysisParameters {
    private boolean isSignatureDiscovery = false;
    private boolean isKnownSignature = true;
    private String signatureGMTFileName = "";
    private int signature_absNumber_Cutoff;
    private double signature_Jaccard_Cutoff;
    private double signature_Overlap_Cutoff;
    private double signature_DirOverlap_Cutoff;
    private double signature_Hypergeom_Cutoff;
    private double signature_Mann_Whit_Cutoff;
    private CutoffMetric signature_CutoffMetric;
    private int default_signature_absNumber_Cutoff = 5;
    private double default_signature_Jaccard_Cutoff = 0.125;
    private double default_signature_Overlap_Cutoff = 0.25;
    private double default_signature_DirOverlap_Cutoff = 0.25;
    private double default_signature_Hypergeom_Cutoff = 0.05;
    private CutoffMetric default_signature_CutoffMetric = CutoffMetric.ABS_NUMBER;
    private SetOfGeneSets signatureGenesets;
    private DefaultListModel<String> signatureSetNames;
    private DefaultListModel<String> selectedSignatureSetNames;
    private double currentNodePlacementY_Offset = 0.0;
    private boolean filter = false;
    private int filterValue;
    private int default_filter_value = 50;
    private FilterMetric default_signature_filterMetric = FilterMetric.HYPERGEOM;
    private FilterMetric signature_filterMetric;
    private FilterMetric default_signature_rankTest;
    private FilterMetric signature_rankTest = this.default_signature_rankTest = FilterMetric.MANN_WHIT;
    private double default_signature_Mann_Whit_Cutoff = 0.05;
    private String signature_rankFile;
    private String signature_dataSet;
    private int universeSize;
    private String attributePrefix = null;

    public PostAnalysisParameters() {
        this.signature_absNumber_Cutoff = this.default_signature_absNumber_Cutoff;
        this.signature_Jaccard_Cutoff = this.default_signature_Jaccard_Cutoff;
        this.signature_Overlap_Cutoff = this.default_signature_Overlap_Cutoff;
        this.signature_DirOverlap_Cutoff = this.default_signature_DirOverlap_Cutoff;
        this.signature_Hypergeom_Cutoff = this.default_signature_Hypergeom_Cutoff;
        this.signature_CutoffMetric = this.default_signature_CutoffMetric;
        this.signature_Mann_Whit_Cutoff = this.default_signature_Mann_Whit_Cutoff;
        this.signatureGenesets = new SetOfGeneSets();
        this.signatureSetNames = new DefaultListModel();
        this.selectedSignatureSetNames = new DefaultListModel();
        this.filterValue = this.default_filter_value;
        this.signature_filterMetric = this.default_signature_filterMetric;
    }

    public void copyFrom(PostAnalysisParameters source) {
        this.isSignatureDiscovery = source.isSignatureDiscovery();
        this.isKnownSignature = source.isKnownSignature();
        this.universeSize = source.getUniverseSize();
        this.signatureGMTFileName = source.getSignatureGMTFileName();
        this.signature_absNumber_Cutoff = source.getSignature_absNumber_Cutoff();
        this.signature_Jaccard_Cutoff = source.getSignature_Jaccard_Cutoff();
        this.signature_Overlap_Cutoff = source.getSignature_Overlap_Cutoff();
        this.signature_DirOverlap_Cutoff = source.getSignature_DirOverlap_Cutoff();
        this.signature_Hypergeom_Cutoff = source.getSignature_Hypergeom_Cutoff();
        this.signature_Mann_Whit_Cutoff = source.getSignature_Mann_Whit_Cutoff();
        this.signature_CutoffMetric = source.getSignature_CutoffMetric();
        this.signature_rankTest = source.getSignature_rankTest();
        this.signature_dataSet = source.getSignature_dataSet();
        this.signatureGenesets = source.getSignatureGenesets();
        this.signatureSetNames = source.getSignatureSetNames();
        this.selectedSignatureSetNames = source.getSelectedSignatureSetNames();
        this.currentNodePlacementY_Offset = source.getCurrentNodePlacementY_Offset();
        this.filterValue = source.getFilterValue();
        this.attributePrefix = source.getAttributePrefix();
    }

    public String checkMinimalRequirements() {
        StringBuilder errors = new StringBuilder();
        errors.append(this.checkGMTfiles());
        if (this.selectedSignatureSetNames.isEmpty()) {
            errors.append("No Signature Genesets selected \n");
        }
        switch (this.signature_CutoffMetric) {
            case ABS_NUMBER: {
                if (this.signature_absNumber_Cutoff > 0) break;
                errors.append("Number of Genes Cutoff must be a positive, non-zero integer \n");
                break;
            }
            case OVERLAP: {
                if (!(this.signature_Overlap_Cutoff < 0.0) && !(this.signature_Overlap_Cutoff > 1.0)) break;
                errors.append("Overlap Cutoff must be a decimal Number between 0.0 and 1.0 \n");
                break;
            }
            case JACCARD: {
                if (!(this.signature_Jaccard_Cutoff < 0.0) && !(this.signature_Jaccard_Cutoff > 1.0)) break;
                errors.append("Jaccard Cutoff must be a decimal Number between 0.0 and 1.0 \n");
                break;
            }
            case DIR_OVERLAP: {
                if (!(this.signature_DirOverlap_Cutoff < 0.0) && !(this.signature_DirOverlap_Cutoff > 1.0)) break;
                errors.append("Directed Overlap Cutoff must be a decimal Number between 0.0 and 1.0 \n");
                break;
            }
            default: {
                errors.append("Invalid Cutoff metric \n");
            }
        }
        return errors.toString();
    }

    public String checkGMTfiles() {
        String signatureGMTFileName = this.getSignatureGMTFileName();
        if (signatureGMTFileName.isEmpty() || !EnrichmentMapParameters.checkFile(signatureGMTFileName)) {
            return "Signature GMT file can not be found \n";
        }
        return "";
    }

    public void setSignatureGMTFileName(String signatureGMTFileName) {
        this.signatureGMTFileName = signatureGMTFileName;
    }

    public String getSignatureGMTFileName() {
        return this.signatureGMTFileName;
    }

    public int getSignature_absNumber_Cutoff() {
        return this.signature_absNumber_Cutoff;
    }

    public double getSignature_Jaccard_Cutoff() {
        return this.signature_Jaccard_Cutoff;
    }

    public double getSignature_Overlap_Cutoff() {
        return this.signature_Overlap_Cutoff;
    }

    public double getSignature_DirOverlap_Cutoff() {
        return this.signature_DirOverlap_Cutoff;
    }

    public void setSignature_Hypergeom_Cutoff(double signature_Hypergeom_Cutoff) {
        this.signature_Hypergeom_Cutoff = signature_Hypergeom_Cutoff;
    }

    public double getSignature_Hypergeom_Cutoff() {
        return this.signature_Hypergeom_Cutoff;
    }

    public CutoffMetric getSignature_CutoffMetric() {
        return this.signature_CutoffMetric;
    }

    public void setSignatureHub(boolean isSignatureDiscovery) {
        this.isSignatureDiscovery = isSignatureDiscovery;
        this.isKnownSignature = !this.isSignatureDiscovery;
    }

    public double getDefault_signature_Hypergeom_Cutoff() {
        return this.default_signature_Hypergeom_Cutoff;
    }

    public boolean isSignatureDiscovery() {
        return this.isSignatureDiscovery;
    }

    public void setSignatureGenesets(SetOfGeneSets signatureGenesets) {
        this.signatureGenesets = signatureGenesets;
    }

    public SetOfGeneSets getSignatureGenesets() {
        return this.signatureGenesets;
    }

    public DefaultListModel<String> getSignatureSetNames() {
        return this.signatureSetNames;
    }

    public DefaultListModel<String> getSelectedSignatureSetNames() {
        return this.selectedSignatureSetNames;
    }

    public void setCurrentNodePlacementY_Offset(double currentNodePlacementY_Offset) {
        this.currentNodePlacementY_Offset = currentNodePlacementY_Offset;
    }

    public double getCurrentNodePlacementY_Offset() {
        return this.currentNodePlacementY_Offset;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public int getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(int filterValue) {
        this.filterValue = filterValue;
    }

    public FilterMetric getSignature_filterMetric() {
        return this.signature_filterMetric;
    }

    public void setSignature_filterMetric(FilterMetric signature_filterMetric) {
        this.signature_filterMetric = signature_filterMetric;
    }

    public FilterMetric getDefault_signature_filterMetric() {
        return this.default_signature_filterMetric;
    }

    public double getDefault_signature_Mann_Whit_Cutoff() {
        return this.default_signature_Mann_Whit_Cutoff;
    }

    public double getSignature_Mann_Whit_Cutoff() {
        return this.signature_Mann_Whit_Cutoff;
    }

    public void setSignature_Mann_Whit_Cutoff(double signature_Mann_Whit_Cutoff) {
        this.signature_Mann_Whit_Cutoff = signature_Mann_Whit_Cutoff;
    }

    public String getSignature_rankFile() {
        return this.signature_rankFile;
    }

    public void setSignature_rankFile(String signature_rankFile) {
        this.signature_rankFile = signature_rankFile;
    }

    public String getSignature_dataSet() {
        return this.signature_dataSet;
    }

    public void setSignature_dataSet(String signature_dataSet) {
        this.signature_dataSet = signature_dataSet;
    }

    public boolean isKnownSignature() {
        return this.isKnownSignature;
    }

    public FilterMetric getSignature_rankTest() {
        return this.signature_rankTest;
    }

    public void setSignature_rankTest(FilterMetric signature_rankTest) {
        this.signature_rankTest = signature_rankTest;
    }

    public FilterMetric getDefault_signature_rankTest() {
        return this.default_signature_rankTest;
    }

    public int getUniverseSize() {
        return this.universeSize;
    }

    public void setUniverseSize(int universeSize) {
        this.universeSize = universeSize;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public static final class FilterMetric
    extends Enum<FilterMetric> {
        public static final /* enum */ FilterMetric HYPERGEOM = new FilterMetric("Hypergeometric Test");
        public static final /* enum */ FilterMetric MANN_WHIT = new FilterMetric("Mann-Whitney");
        public static final /* enum */ FilterMetric PERCENT = new FilterMetric("Overlap X percent of EM gs");
        public static final /* enum */ FilterMetric NUMBER = new FilterMetric("Overlap has at least X genes");
        public static final /* enum */ FilterMetric SPECIFIC = new FilterMetric("Overlap X percent of Signature gs");
        public final String display;
        private static final /* synthetic */ FilterMetric[] $VALUES;

        public static FilterMetric[] values() {
            return (FilterMetric[])$VALUES.clone();
        }

        private FilterMetric(String display) {
            this.display = display;
        }

        static {
            $VALUES = new FilterMetric[]{HYPERGEOM, MANN_WHIT, PERCENT, NUMBER, SPECIFIC};
        }
    }

    public static final class CutoffMetric
    extends Enum<CutoffMetric> {
        public static final /* enum */ CutoffMetric ABS_NUMBER = new CutoffMetric("Number of Common Genes");
        public static final /* enum */ CutoffMetric JACCARD = new CutoffMetric("Jaccard Coefficient");
        public static final /* enum */ CutoffMetric OVERLAP = new CutoffMetric("Overlap Coefficient");
        public static final /* enum */ CutoffMetric DIR_OVERLAP = new CutoffMetric("Directed Overlap");
        public final String display;
        private static final /* synthetic */ CutoffMetric[] $VALUES;

        public static CutoffMetric[] values() {
            return (CutoffMetric[])$VALUES.clone();
        }

        private CutoffMetric(String display) {
            this.display = display;
        }

        static {
            $VALUES = new CutoffMetric[]{ABS_NUMBER, JACCARD, OVERLAP, DIR_OVERLAP};
        }
    }
}

