/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class BitsStreamGenerator
implements Serializable,
RandomGenerator {
    private double nextGaussian = Double.NaN;

    protected abstract int next(int var1);

    public void nextBytes(byte[] bytes) {
        int random;
        int i;
        int iEnd = bytes.length - 3;
        for (i = 0; i < iEnd; i += 4) {
            random = this.next(32);
            bytes[i] = (byte)(random & 0xFF);
            bytes[i + 1] = (byte)(random >> 8 & 0xFF);
            bytes[i + 2] = (byte)(random >> 16 & 0xFF);
            bytes[i + 3] = (byte)(random >> 24 & 0xFF);
        }
        random = this.next(32);
        while (i < bytes.length) {
            bytes[i++] = (byte)(random & 0xFF);
            random >>= 8;
        }
    }

    public int nextInt(int n) throws IllegalArgumentException {
        if (n > 0) {
            int val;
            int bits;
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
            }
            return val;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public long nextLong() {
        long high = (long)this.next(32) << 32;
        long low = (long)this.next(32) & 0xFFFFFFFFL;
        return high | low;
    }

    public void clear() {
        this.nextGaussian = Double.NaN;
    }
}

