/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class AbstractRandomGenerator
implements RandomGenerator {
    public void nextBytes(byte[] bytes) {
        int bytesOut = 0;
        while (bytesOut < bytes.length) {
            int randInt = this.nextInt();
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    randInt >>= 8;
                }
                bytes[bytesOut++] = (byte)randInt;
                if (bytesOut != bytes.length) continue;
                return;
            }
        }
    }

    public int nextInt() {
        return (int)((2.0 * this.nextDouble() - 1.0) * 2.147483647E9);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        int result = (int)(this.nextDouble() * (double)n);
        return result < n ? result : n - 1;
    }

    public long nextLong() {
        return (long)((2.0 * this.nextDouble() - 1.0) * 9.223372036854776E18);
    }

    public abstract double nextDouble();
}

