/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.exception.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.exception.util.ArgUtils;
import org.apache.commons.math3.exception.util.Localizable;

public class ExceptionContext
implements Serializable {
    private Throwable throwable;
    private List<Localizable> msgPatterns;
    private List<Object[]> msgArguments;
    private Map<String, Object> context;

    public ExceptionContext(Throwable throwable) {
        this.throwable = throwable;
        this.msgPatterns = new ArrayList<Localizable>();
        this.msgArguments = new ArrayList<Object[]>();
        this.context = new HashMap<String, Object>();
    }

    public void addMessage(Localizable pattern, Object ... arguments) {
        this.msgPatterns.add(pattern);
        this.msgArguments.add(ArgUtils.flatten(arguments));
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.buildMessage(locale, ": ");
    }

    private String buildMessage(Locale locale, String separator) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int len = this.msgPatterns.size();
        for (int i = 0; i < len; ++i) {
            Localizable pat = this.msgPatterns.get(i);
            Object[] args = this.msgArguments.get(i);
            MessageFormat fmt = new MessageFormat(pat.getLocalizedString(locale), locale);
            sb.append(fmt.format(args));
            if (++count >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

