/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractLongList;

public class LongArrayList
extends AbstractLongList {
    protected long[] elements;

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(long[] lArray) {
        this.elements(lArray);
    }

    public LongArrayList(int n) {
        this(new long[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        LongArrayList longArrayList = new LongArrayList((long[])this.elements.clone());
        longArrayList.setSizeRaw(this.size);
        return longArrayList;
    }

    public long[] elements() {
        return this.elements;
    }

    public AbstractLongList elements(long[] lArray) {
        this.elements = lArray;
        this.size = lArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        LongArrayList longArrayList = (LongArrayList)object;
        if (this.size() != longArrayList.size()) {
            return false;
        }
        long[] lArray = this.elements();
        long[] lArray2 = longArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (lArray[n] == lArray2[n]) continue;
            return false;
        }
        return true;
    }

    public long get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public long getQuick(int n) {
        return this.elements[n];
    }

    public AbstractLongList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new LongArrayList(0);
        }
        LongArrayList.checkRangeFromTo(n, n2, this.size);
        long[] lArray = new long[n2 - n + 1];
        System.arraycopy(this.elements, n, lArray, 0, n2 - n + 1);
        return new LongArrayList(lArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractLongList abstractLongList, int n3) {
        if (!(abstractLongList instanceof LongArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractLongList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            LongArrayList.checkRangeFromTo(n, n2, this.size());
            LongArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractLongList.size());
            System.arraycopy(((LongArrayList)abstractLongList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, long l) {
        this.elements[n] = l;
    }
}

