/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractDoubleList;

public class DoubleArrayList
extends AbstractDoubleList {
    protected double[] elements;

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(double[] dArray) {
        this.elements(dArray);
    }

    public DoubleArrayList(int n) {
        this(new double[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        DoubleArrayList doubleArrayList = new DoubleArrayList((double[])this.elements.clone());
        doubleArrayList.setSizeRaw(this.size);
        return doubleArrayList;
    }

    public DoubleArrayList copy() {
        return (DoubleArrayList)this.clone();
    }

    public double[] elements() {
        return this.elements;
    }

    public AbstractDoubleList elements(double[] dArray) {
        this.elements = dArray;
        this.size = dArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (this.size() != doubleArrayList.size()) {
            return false;
        }
        double[] dArray = this.elements();
        double[] dArray2 = doubleArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (dArray[n] == dArray2[n]) continue;
            return false;
        }
        return true;
    }

    public double get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public double getQuick(int n) {
        return this.elements[n];
    }

    public AbstractDoubleList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = new double[n2 - n + 1];
        System.arraycopy(this.elements, n, dArray, 0, n2 - n + 1);
        return new DoubleArrayList(dArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractDoubleList abstractDoubleList, int n3) {
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractDoubleList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            DoubleArrayList.checkRangeFromTo(n, n2, this.size());
            DoubleArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractDoubleList.size());
            System.arraycopy(((DoubleArrayList)abstractDoubleList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, double d) {
        this.elements[n] = d;
    }
}

