/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractByteList;

public class ByteArrayList
extends AbstractByteList {
    protected byte[] elements;

    public ByteArrayList() {
        this(10);
    }

    public ByteArrayList(byte[] byArray) {
        this.elements(byArray);
    }

    public ByteArrayList(int n) {
        this(new byte[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        ByteArrayList byteArrayList = new ByteArrayList((byte[])this.elements.clone());
        byteArrayList.setSizeRaw(this.size);
        return byteArrayList;
    }

    public byte[] elements() {
        return this.elements;
    }

    public AbstractByteList elements(byte[] byArray) {
        this.elements = byArray;
        this.size = byArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ByteArrayList byteArrayList = (ByteArrayList)object;
        if (this.size() != byteArrayList.size()) {
            return false;
        }
        byte[] byArray = this.elements();
        byte[] byArray2 = byteArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public byte get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public byte getQuick(int n) {
        return this.elements[n];
    }

    public AbstractByteList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ByteArrayList(0);
        }
        ByteArrayList.checkRangeFromTo(n, n2, this.size);
        byte[] byArray = new byte[n2 - n + 1];
        System.arraycopy(this.elements, n, byArray, 0, n2 - n + 1);
        return new ByteArrayList(byArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractByteList abstractByteList, int n3) {
        if (!(abstractByteList instanceof ByteArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractByteList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            ByteArrayList.checkRangeFromTo(n, n2, this.size());
            ByteArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractByteList.size());
            System.arraycopy(((ByteArrayList)abstractByteList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, byte by) {
        this.elements[n] = by;
    }
}

