/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.cytoscape.application.swing.CySwingApplication;

public class PostAnalysisWeightPanel
extends CollapsiblePanel {
    private final CySwingApplication application;
    private PostAnalysisParameters paParams;
    private EnrichmentMap map;
    private int universeGmt;
    private int universeExpression;
    private int universeIntersection;
    private JComboBox<String> datasetCombo;
    private JComboBox<String> rankingCombo;
    private JComboBox<String> rankTestCombo;
    private JFormattedTextField rankTestTextField;
    private JRadioButton gmtRadioButton;
    private JRadioButton intersectionRadioButton;
    private JRadioButton expressionSetRadioButton;
    private JRadioButton userDefinedRadioButton;
    private JFormattedTextField universeSelectionTextField;
    private DefaultComboBoxModel<String> rankingModel;
    private DefaultComboBoxModel<String> datasetModel;

    public PostAnalysisWeightPanel(CySwingApplication application) {
        super("Edge Weight Calculation Parameters");
        this.application = application;
        this.createPanel();
    }

    private void createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.datasetCombo = new JComboBox();
        this.datasetModel = new DefaultComboBoxModel();
        this.datasetCombo.setModel(this.datasetModel);
        this.datasetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dataset = (String)PostAnalysisWeightPanel.this.datasetCombo.getSelectedItem();
                if (dataset == null) {
                    return;
                }
                PostAnalysisWeightPanel.this.paParams.setSignature_dataSet(dataset);
                PostAnalysisWeightPanel.this.updateUniverseSize();
            }
        });
        panel.add(this.datasetCombo);
        this.rankingModel = new DefaultComboBoxModel();
        this.rankingCombo = new JComboBox();
        this.rankingCombo.setModel(this.rankingModel);
        this.rankingCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostAnalysisWeightPanel.this.paParams.setSignature_rankFile((String)PostAnalysisWeightPanel.this.rankingCombo.getSelectedItem());
            }
        });
        panel.add(this.rankingCombo);
        DecimalFormat decFormat = new DecimalFormat();
        decFormat.setParseIntegerOnly(false);
        this.rankTestTextField = new JFormattedTextField(decFormat);
        this.rankTestTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.rankTestCombo = new JComboBox();
        this.rankTestCombo.addItem(PostAnalysisParameters.FilterMetric.MANN_WHIT.display);
        this.rankTestCombo.addItem(PostAnalysisParameters.FilterMetric.HYPERGEOM.display);
        this.rankTestCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostAnalysisParameters.FilterMetric.MANN_WHIT.display.equals(PostAnalysisWeightPanel.this.rankTestCombo.getSelectedItem())) {
                    PostAnalysisWeightPanel.this.paParams.setSignature_rankTest(PostAnalysisParameters.FilterMetric.MANN_WHIT);
                    PostAnalysisWeightPanel.this.rankTestTextField.setValue(PostAnalysisWeightPanel.this.paParams.getSignature_Mann_Whit_Cutoff());
                } else if (PostAnalysisParameters.FilterMetric.HYPERGEOM.display.equals(PostAnalysisWeightPanel.this.rankTestCombo.getSelectedItem())) {
                    PostAnalysisWeightPanel.this.paParams.setSignature_rankTest(PostAnalysisParameters.FilterMetric.HYPERGEOM);
                    PostAnalysisWeightPanel.this.rankTestTextField.setValue(PostAnalysisWeightPanel.this.paParams.getSignature_Hypergeom_Cutoff());
                }
            }
        });
        panel.add(this.rankTestCombo);
        JPanel cutoffLabel = new JPanel();
        cutoffLabel.add(new JLabel("Select Cutoff:"));
        panel.add(cutoffLabel);
        JPanel cutoffPanel = new JPanel();
        cutoffPanel.setLayout(new BoxLayout(cutoffPanel, 0));
        cutoffPanel.add(this.rankTestCombo);
        cutoffPanel.add(this.rankTestTextField);
        panel.add(cutoffPanel);
        CollapsiblePanel universeSelectionPanel = new CollapsiblePanel("Advanced Hypergeometric Universe");
        universeSelectionPanel.setCollapsed(true);
        universeSelectionPanel.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        JPanel radioButtonsPanel = new JPanel();
        radioButtonsPanel.setLayout(gridbag);
        this.gmtRadioButton = new JRadioButton();
        this.gmtRadioButton.setActionCommand("GMT");
        this.gmtRadioButton.addActionListener(new UniverseSelectActionListener());
        this.gmtRadioButton.setSelected(true);
        this.expressionSetRadioButton = new JRadioButton();
        this.expressionSetRadioButton.setActionCommand("Expression Set");
        this.expressionSetRadioButton.addActionListener(new UniverseSelectActionListener());
        this.intersectionRadioButton = new JRadioButton();
        this.intersectionRadioButton.setActionCommand("Intersection");
        this.intersectionRadioButton.addActionListener(new UniverseSelectActionListener());
        this.userDefinedRadioButton = new JRadioButton("User Defined");
        this.userDefinedRadioButton.setActionCommand("User Defined");
        this.userDefinedRadioButton.addActionListener(new UniverseSelectActionListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.gmtRadioButton);
        buttonGroup.add(this.expressionSetRadioButton);
        buttonGroup.add(this.intersectionRadioButton);
        buttonGroup.add(this.userDefinedRadioButton);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        gridbag.setConstraints(this.gmtRadioButton, c);
        radioButtonsPanel.add(this.gmtRadioButton);
        c.gridy = 1;
        gridbag.setConstraints(this.expressionSetRadioButton, c);
        radioButtonsPanel.add(this.expressionSetRadioButton);
        c.gridy = 2;
        gridbag.setConstraints(this.intersectionRadioButton, c);
        radioButtonsPanel.add(this.intersectionRadioButton);
        c.gridy = 3;
        c.gridwidth = 2;
        gridbag.setConstraints(this.userDefinedRadioButton, c);
        radioButtonsPanel.add(this.userDefinedRadioButton);
        c.gridx = 2;
        DecimalFormat intFormat = new DecimalFormat();
        intFormat.setParseIntegerOnly(true);
        this.universeSelectionTextField = new JFormattedTextField(intFormat);
        this.universeSelectionTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.universeSelectionTextField.setEnabled(false);
        gridbag.setConstraints(this.universeSelectionTextField, c);
        radioButtonsPanel.add(this.universeSelectionTextField);
        universeSelectionPanel.getContentPane().add((Component)radioButtonsPanel, "Center");
        panel.add(universeSelectionPanel);
        this.getContentPane().add((Component)panel, "North");
    }

    void resetPanel() {
        this.gmtRadioButton.setSelected(true);
        this.rankTestCombo.setSelectedItem(this.paParams.getDefault_signature_rankTest().display);
    }

    void updateContents(EnrichmentMap currentMap, PostAnalysisParameters paParams) {
        this.map = currentMap;
        this.paParams = paParams;
        HashMap<String, DataSet> datasetMap = this.map.getDatasets();
        Object[] datasetArray = datasetMap.keySet().toArray(new String[datasetMap.size()]);
        Arrays.sort(datasetArray);
        this.datasetModel.removeAllElements();
        for (Object dataset : datasetArray) {
            this.datasetModel.addElement((String)dataset);
        }
        HashMap<String, Ranking> rankingMap = this.map.getAllRanks();
        Object[] rankingArray = rankingMap.keySet().toArray(new String[rankingMap.size()]);
        Arrays.sort(rankingArray);
        this.rankingModel.removeAllElements();
        for (Object ranking : rankingArray) {
            this.rankingModel.addElement((String)ranking);
        }
        this.updateUniverseSize();
        this.rankTestCombo.setSelectedItem(paParams.getDefault_signature_rankTest().display);
    }

    private void updateUniverseSize() {
        String signature_dataSet = this.paParams.getSignature_dataSet();
        GeneExpressionMatrix expressionSets = this.map.getDataset(signature_dataSet).getExpressionSets();
        this.universeGmt = this.map.getNumberOfGenes();
        this.universeExpression = expressionSets.getExpressionUniverse();
        this.universeIntersection = expressionSets.getExpressionMatrix().size();
        this.gmtRadioButton.setText("GMT (" + this.universeGmt + ")");
        this.expressionSetRadioButton.setText("Expression Set (" + this.universeExpression + ")");
        this.intersectionRadioButton.setText("Intersection (" + this.universeIntersection + ")");
        this.universeSelectionTextField.setValue(this.universeExpression);
        if (this.gmtRadioButton.isSelected()) {
            this.paParams.setUniverseSize(this.universeGmt);
        } else if (this.expressionSetRadioButton.isSelected()) {
            this.paParams.setUniverseSize(this.universeExpression);
        } else if (this.intersectionRadioButton.isSelected()) {
            this.paParams.setUniverseSize(this.universeIntersection);
        } else {
            this.paParams.setUniverseSize((Integer)this.universeSelectionTextField.getValue());
        }
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            if (source == PostAnalysisWeightPanel.this.rankTestTextField) {
                Number val = (Number)PostAnalysisWeightPanel.this.rankTestTextField.getValue();
                if (val == null || val.doubleValue() < 0.0) {
                    JOptionPane.showMessageDialog(PostAnalysisWeightPanel.this.application.getJFrame(), "Universe value must be greater than zero", "Parameter out of bounds", 2);
                    val = 1;
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setValue(val);
                }
                if (PostAnalysisWeightPanel.this.rankTestCombo.getSelectedItem().equals(PostAnalysisParameters.FilterMetric.MANN_WHIT.display)) {
                    PostAnalysisWeightPanel.this.paParams.setSignature_Mann_Whit_Cutoff(val.doubleValue());
                }
                if (PostAnalysisWeightPanel.this.rankTestCombo.getSelectedItem().equals(PostAnalysisParameters.FilterMetric.HYPERGEOM.display)) {
                    PostAnalysisWeightPanel.this.paParams.setSignature_Hypergeom_Cutoff(val.doubleValue());
                }
            } else if (source == PostAnalysisWeightPanel.this.universeSelectionTextField) {
                Number val = (Number)PostAnalysisWeightPanel.this.universeSelectionTextField.getValue();
                if (val == null || val.intValue() < 0) {
                    JOptionPane.showMessageDialog(PostAnalysisWeightPanel.this.application.getJFrame(), "Universe value must be greater than zero", "Parameter out of bounds", 2);
                    val = 1;
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setValue(val);
                }
                PostAnalysisWeightPanel.this.paParams.setUniverseSize(val.intValue());
            }
        }
    }

    private class UniverseSelectActionListener
    implements ActionListener {
        private UniverseSelectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int size = 0;
            switch (e.getActionCommand()) {
                case "GMT": {
                    size = PostAnalysisWeightPanel.this.universeGmt;
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setEnabled(false);
                    break;
                }
                case "Expression Set": {
                    size = PostAnalysisWeightPanel.this.universeExpression;
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setEnabled(false);
                    break;
                }
                case "Intersection": {
                    size = PostAnalysisWeightPanel.this.universeIntersection;
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setEnabled(false);
                    break;
                }
                case "User Defined": {
                    size = ((Number)PostAnalysisWeightPanel.this.universeSelectionTextField.getValue()).intValue();
                    PostAnalysisWeightPanel.this.universeSelectionTextField.setEnabled(true);
                }
            }
            PostAnalysisWeightPanel.this.paParams.setUniverseSize(size);
        }
    }
}

