/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.LoadSignatureSetsActionListener;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisWeightPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisKnownSignaturePanel
extends JPanel {
    private final PostAnalysisInputPanel parentPanel;
    private final CyApplicationManager cyApplicationManager;
    private final CySwingApplication application;
    private final StreamUtil streamUtil;
    private final DialogTaskManager dialog;
    private final FileUtil fileUtil;
    private EnrichmentMap map;
    private PostAnalysisParameters paParams;
    private PostAnalysisWeightPanel weightPanel;
    private JFormattedTextField knownSignatureGMTFileNameTextField;

    public PostAnalysisKnownSignaturePanel(PostAnalysisInputPanel parentPanel, CyApplicationManager cyApplicationManager, CySwingApplication application, StreamUtil streamUtil, DialogTaskManager dialog, FileUtil fileUtil) {
        this.parentPanel = parentPanel;
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.streamUtil = streamUtil;
        this.dialog = dialog;
        this.fileUtil = fileUtil;
        this.createKnownSignatureOptionsPanel();
    }

    private void createKnownSignatureOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        CollapsiblePanel gmtPanel = this.createKnownSignatureGMTPanel();
        gmtPanel.setCollapsed(false);
        this.weightPanel = new PostAnalysisWeightPanel(this.application);
        this.weightPanel.setCollapsed(false);
        this.add(gmtPanel);
        this.add(this.weightPanel);
    }

    private CollapsiblePanel createKnownSignatureGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene-Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel SigGMTLabel = new JLabel("SigGMT:"){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        SigGMTLabel.setToolTipText(PostAnalysisInputPanel.gmtTip);
        JButton selectSigGMTFileButton = new JButton();
        this.knownSignatureGMTFileNameTextField = new JFormattedTextField();
        this.knownSignatureGMTFileNameTextField.setColumns(15);
        this.knownSignatureGMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.knownSignatureGMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectSigGMTFileButton.setText("...");
        selectSigGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectSigGMTFileButton.setActionCommand("Known Signature");
        selectSigGMTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisKnownSignaturePanel.this.selectSignatureGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel SigGMTPanel = new JPanel();
        SigGMTPanel.setLayout(new BorderLayout());
        SigGMTPanel.add((Component)SigGMTLabel, "West");
        SigGMTPanel.add((Component)this.knownSignatureGMTFileNameTextField, "Center");
        SigGMTPanel.add((Component)selectSigGMTFileButton, "East");
        panel.add(SigGMTPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private void selectSignatureGMTFileButtonActionPerformed(ActionEvent evt) {
        File file = this.parentPanel.chooseGMTFile(this.knownSignatureGMTFileNameTextField);
        if (file != null) {
            LoadSignatureSetsActionListener loadAction = new LoadSignatureSetsActionListener(this.parentPanel, this.application, this.cyApplicationManager, (TaskManager<?, ?>)this.dialog, this.streamUtil);
            loadAction.setSelectAll(true);
            loadAction.actionPerformed(evt);
        }
    }

    void resetPanel() {
        this.paParams.setSignatureGenesets(new SetOfGeneSets());
        this.knownSignatureGMTFileNameTextField.setText("");
        this.knownSignatureGMTFileNameTextField.setValue("");
        this.knownSignatureGMTFileNameTextField.setToolTipText(null);
        this.weightPanel.resetPanel();
    }

    void updateContents(EnrichmentMap currentMap, PostAnalysisParameters paParams) {
        this.map = currentMap;
        this.paParams = paParams;
        this.weightPanel.updateContents(currentMap, paParams);
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField) {
                String value = PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    PostAnalysisKnownSignaturePanel.this.paParams.setSignatureGMTFileName(value);
                } else if (!PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (PostAnalysisInputPanel.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(PostAnalysisKnownSignaturePanel.this.application.getJFrame(), message, "File name change entered is not a valid file name", 2);
                        PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField.setForeground(PostAnalysisInputPanel.checkFile(value));
                    } else {
                        PostAnalysisKnownSignaturePanel.this.paParams.setSignatureGMTFileName(value);
                        PostAnalysisKnownSignaturePanel.this.paParams.getSignatureSetNames().clear();
                        PostAnalysisKnownSignaturePanel.this.paParams.getSelectedSignatureSetNames().clear();
                    }
                }
            }
            if (invalid) {
                JOptionPane.showMessageDialog(PostAnalysisKnownSignaturePanel.this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

