/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Scanner;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class LoadGOOntologyTask
extends AbstractTask {
    CyNetwork current_network;
    File file;
    private StreamUtil streamUtil;

    public LoadGOOntologyTask(CyNetwork current_network, File file, StreamUtil streamUtil) {
        this.current_network = current_network;
        this.file = file;
        this.streamUtil = streamUtil;
    }

    public void run(TaskMonitor arg0) throws Exception {
        InputStream reader = this.streamUtil.getInputStream(this.file.getAbsolutePath());
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 3) continue;
            String node1_name = tokens[0];
            String node2_name = tokens[2];
            CyNode node1 = LoadGOOntologyTask.getUniqueNodeWithValue(this.current_network, this.current_network.getDefaultNodeTable(), "name", node1_name);
            CyNode node2 = LoadGOOntologyTask.getUniqueNodeWithValue(this.current_network, this.current_network.getDefaultNodeTable(), "name", node2_name);
            if (node1 == null || node2 == null) {
                if (node1 == null) {
                    System.out.println("Couldn't find " + node1_name + "in the network");
                }
                if (node2 != null) continue;
                System.out.println("Couldn't find " + node2_name + "in the network");
                continue;
            }
            CyEdge edge = this.current_network.addEdge(node1, node2, false);
            String edge_type = tokens[1];
            CyRow current_edgerow = this.current_network.getDefaultEdgeTable().getRow((Object)edge.getSUID());
            current_edgerow.set("name", (Object)(node1_name + "_" + edge_type + "_" + node2_name));
            current_edgerow.set("interaction", (Object)edge_type);
        }
    }

    private static CyNode getUniqueNodeWithValue(CyNetwork net, CyTable table, String colname, Object value) {
        Collection matchingRows = table.getMatchingRows(colname, value);
        if (matchingRows.size() > 1 || matchingRows.size() <= 0) {
            return null;
        }
        String primaryKeyColname = table.getPrimaryKey().getName();
        for (CyRow row : matchingRows) {
            CyNode node;
            Long nodeId = (Long)row.get(primaryKeyColname, Long.class);
            if (nodeId == null || (node = net.getNode(nodeId.longValue())) == null) continue;
            return node;
        }
        return null;
    }
}

