/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;

public class BuildDiseaseSignatureTaskResult {
    private final Set<CyEdge> existingEdges;
    private final CyNetwork network;
    private final CyNetworkView networkView;
    private final boolean warnUserBypassStyle;
    private final int createdEdgeCount;
    private final int passedCutoffCount;
    private final boolean cancelled;

    private BuildDiseaseSignatureTaskResult(Builder builder) {
        this.existingEdges = new HashSet<CyEdge>(builder.existingEdges);
        this.warnUserBypassStyle = builder.warnUserBypassStyle;
        this.network = builder.network;
        this.networkView = builder.networkView;
        this.createdEdgeCount = builder.createdEdgeCount;
        this.passedCutoffCount = builder.passedCutoffCount;
        this.cancelled = builder.cancelled;
    }

    public Set<CyEdge> getExistingEdgesFailingCutoff() {
        return Collections.unmodifiableSet(this.existingEdges);
    }

    public boolean isWarnUserBypassStyle() {
        return this.warnUserBypassStyle;
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public int getPassedCutoffCount() {
        return this.passedCutoffCount;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static class Builder {
        private Set<CyEdge> existingEdges = new HashSet<CyEdge>();
        private boolean warnUserBypassStyle;
        private CyNetwork network;
        private CyNetworkView networkView;
        private int createdEdgeCount = 0;
        private int passedCutoffCount = 0;
        private boolean cancelled;

        public void addExistingEdgeFailsCutoff(CyEdge edge) {
            if (edge != null) {
                this.existingEdges.add(edge);
            }
        }

        public void incrementCreatedEdgeCount() {
            ++this.createdEdgeCount;
        }

        public void incrementPassedCutoffCount() {
            ++this.passedCutoffCount;
        }

        public void setWarnUserBypassStyle(boolean warn) {
            this.warnUserBypassStyle = warn;
        }

        public void setNetwork(CyNetwork network) {
            this.network = network;
        }

        public void setNetworkView(CyNetworkView networkView) {
            this.networkView = networkView;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public BuildDiseaseSignatureTaskResult build() {
            return new BuildDiseaseSignatureTaskResult(this);
        }
    }
}

