/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import cern.colt.list.ObjectArrayList;
import cern.jet.stat.quantile.DoubleBuffer;
import cern.jet.stat.quantile.DoubleBufferSet;
import cern.jet.stat.quantile.DoubleQuantileFinder;

abstract class DoubleQuantileEstimator
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleBufferSet bufferSet;
    protected DoubleBuffer currentBufferToFill;
    protected int totalElementsFilled;

    protected DoubleQuantileEstimator() {
    }

    public Object clone() {
        DoubleQuantileEstimator doubleQuantileEstimator = (DoubleQuantileEstimator)super.clone();
        if (this.bufferSet != null) {
            doubleQuantileEstimator.bufferSet = (DoubleBufferSet)doubleQuantileEstimator.bufferSet.clone();
            if (this.currentBufferToFill != null) {
                int n = new ObjectArrayList(this.bufferSet.buffers).indexOf(this.currentBufferToFill, true);
                doubleQuantileEstimator.currentBufferToFill = doubleQuantileEstimator.bufferSet.buffers[n];
            }
        }
        return doubleQuantileEstimator;
    }

    public long memory() {
        return this.bufferSet.memory();
    }

    public long size() {
        return this.totalElementsFilled;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        int n = this.bufferSet.b();
        int n2 = this.bufferSet.k();
        return string + "(mem=" + this.memory() + ", b=" + n + ", k=" + n2 + ", size=" + this.size() + ", totalSize=" + this.bufferSet.totalSize() + ")";
    }
}

