/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractFloatList;

public class FloatArrayList
extends AbstractFloatList {
    protected float[] elements;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(float[] fArray) {
        this.elements(fArray);
    }

    public FloatArrayList(int n) {
        this(new float[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        FloatArrayList floatArrayList = new FloatArrayList((float[])this.elements.clone());
        floatArrayList.setSizeRaw(this.size);
        return floatArrayList;
    }

    public float[] elements() {
        return this.elements;
    }

    public AbstractFloatList elements(float[] fArray) {
        this.elements = fArray;
        this.size = fArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloatArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        FloatArrayList floatArrayList = (FloatArrayList)object;
        if (this.size() != floatArrayList.size()) {
            return false;
        }
        float[] fArray = this.elements();
        float[] fArray2 = floatArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (fArray[n] == fArray2[n]) continue;
            return false;
        }
        return true;
    }

    public float get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public float getQuick(int n) {
        return this.elements[n];
    }

    public AbstractFloatList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList.checkRangeFromTo(n, n2, this.size);
        float[] fArray = new float[n2 - n + 1];
        System.arraycopy(this.elements, n, fArray, 0, n2 - n + 1);
        return new FloatArrayList(fArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractFloatList abstractFloatList, int n3) {
        if (!(abstractFloatList instanceof FloatArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractFloatList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            FloatArrayList.checkRangeFromTo(n, n2, this.size());
            FloatArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractFloatList.size());
            System.arraycopy(((FloatArrayList)abstractFloatList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, float f) {
        this.elements[n] = f;
    }
}

