/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.WidthFunction;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

public class EdgeWidthDialog
extends JDialog {
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final TaskManager<?, ?> taskManager;
    private final CyNetwork network;
    private final double similarityCutoff;
    private final String prefix;
    private JFormattedTextField emLowerWidthText;
    private JFormattedTextField emUpperWidthText;
    private JFormattedTextField lessThan100Text;
    private JFormattedTextField lessThan10Text;
    private JFormattedTextField greaterThanText;

    public EdgeWidthDialog(CySwingApplication application, CyApplicationManager applicationManager, VisualMappingFunctionFactory vmfFactoryContinuous, TaskManager<?, ?> taskManager) {
        super((Frame)application.getJFrame(), true);
        this.network = applicationManager.getCurrentNetwork();
        this.taskManager = taskManager;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        EnrichmentMap map = EnrichmentMapManager.getInstance().getMap(this.network.getSUID());
        this.similarityCutoff = map.getParams().getSimilarityCutOff();
        this.prefix = map.getParams().getAttributePrefix();
        this.setTitle("EnrichmentMap Edge Width");
        this.setResizable(false);
        this.createContents();
        this.setTextFieldValues(WidthFunction.EdgeWidthParams.restore(this.network));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    private void createContents() {
        JPanel parent = new JPanel();
        parent.setLayout(new BorderLayout());
        parent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(parent);
        String networkName = (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
        JLabel networkLabel = new JLabel("Network: " + networkName);
        networkLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        JPanel genesetOverlapPanel = this.createGenesetOverlapPanel();
        JPanel signatureSetPanel = this.createSignatureSetPanel();
        JPanel widthPanel = new JPanel();
        widthPanel.setLayout(new BoxLayout(widthPanel, 1));
        widthPanel.add(genesetOverlapPanel);
        widthPanel.add(Box.createVerticalStrut(5));
        widthPanel.add(signatureSetPanel);
        JPanel buttonPanel = this.createButtonPanel();
        parent.add((Component)networkLabel, "North");
        parent.add((Component)widthPanel, "Center");
        parent.add((Component)buttonPanel, "South");
    }

    private static GridBagConstraints gridBagConstraints(int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = new Insets(5, 5, 0, 0);
        return gbc;
    }

    private JPanel createGenesetOverlapPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Geneset Overlap"));
        panel.setLayout(new GridBagLayout());
        JLabel similarityLabel = new JLabel("Similarity Coefficient     ");
        GridBagConstraints gbc = EdgeWidthDialog.gridBagConstraints(0, 0);
        gbc.weightx = 1.0;
        panel.add((Component)similarityLabel, gbc);
        JLabel lowerBound = new JLabel(String.format("%.1f", this.similarityCutoff));
        gbc = EdgeWidthDialog.gridBagConstraints(1, 0);
        panel.add((Component)lowerBound, gbc);
        JLabel upperBound = new JLabel("1.0");
        gbc = EdgeWidthDialog.gridBagConstraints(2, 0);
        panel.add((Component)upperBound, gbc);
        JLabel spacer = new JLabel("");
        gbc = EdgeWidthDialog.gridBagConstraints(3, 0);
        panel.add((Component)spacer, gbc);
        JLabel widthLabel = new JLabel("Width");
        gbc = EdgeWidthDialog.gridBagConstraints(0, 1);
        panel.add((Component)widthLabel, gbc);
        this.emLowerWidthText = new JFormattedTextField(new DecimalFormat());
        this.emLowerWidthText.setPreferredSize(new Dimension(50, this.emLowerWidthText.getPreferredSize().height));
        gbc = EdgeWidthDialog.gridBagConstraints(1, 1);
        gbc.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.emLowerWidthText, gbc);
        this.emUpperWidthText = new JFormattedTextField(new DecimalFormat());
        this.emUpperWidthText.setPreferredSize(new Dimension(50, this.emUpperWidthText.getPreferredSize().height));
        gbc = EdgeWidthDialog.gridBagConstraints(2, 1);
        gbc.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.emUpperWidthText, gbc);
        JLabel mappingText = new JLabel("(continuous mapping) ");
        gbc = EdgeWidthDialog.gridBagConstraints(3, 1);
        panel.add((Component)mappingText, gbc);
        return panel;
    }

    private JPanel createSignatureSetPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Signature Set (Post Analysis)"));
        panel.setLayout(new GridBagLayout());
        JLabel pValueLabel = new JLabel("p-value   ");
        GridBagConstraints gbc = EdgeWidthDialog.gridBagConstraints(0, 0);
        gbc.weightx = 1.0;
        panel.add((Component)pValueLabel, gbc);
        JLabel lessThan100 = new JLabel("<= cutoff/100     ");
        gbc = EdgeWidthDialog.gridBagConstraints(1, 0);
        panel.add((Component)lessThan100, gbc);
        JLabel lessThan10 = new JLabel("<= cutoff/10     ");
        gbc = EdgeWidthDialog.gridBagConstraints(2, 0);
        panel.add((Component)lessThan10, gbc);
        JLabel greaterThan = new JLabel("> cutoff/10     ");
        gbc = EdgeWidthDialog.gridBagConstraints(3, 0);
        panel.add((Component)greaterThan, gbc);
        JLabel widthLabel = new JLabel("Width");
        gbc = EdgeWidthDialog.gridBagConstraints(0, 1);
        panel.add((Component)widthLabel, gbc);
        this.lessThan100Text = new JFormattedTextField(new DecimalFormat());
        this.lessThan100Text.setPreferredSize(new Dimension(50, this.lessThan100Text.getPreferredSize().height));
        gbc = EdgeWidthDialog.gridBagConstraints(1, 1);
        gbc.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.lessThan100Text, gbc);
        this.lessThan10Text = new JFormattedTextField(new DecimalFormat());
        this.lessThan10Text.setPreferredSize(new Dimension(50, this.lessThan10Text.getPreferredSize().height));
        gbc = EdgeWidthDialog.gridBagConstraints(2, 1);
        gbc.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.lessThan10Text, gbc);
        this.greaterThanText = new JFormattedTextField(new DecimalFormat());
        this.greaterThanText.setPreferredSize(new Dimension(50, this.greaterThanText.getPreferredSize().height));
        gbc = EdgeWidthDialog.gridBagConstraints(3, 1);
        gbc.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)this.greaterThanText, gbc);
        return panel;
    }

    private void setTextFieldValues(WidthFunction.EdgeWidthParams widthParams) {
        this.emUpperWidthText.setValue(widthParams.em_upper);
        this.emLowerWidthText.setValue(widthParams.em_lower);
        this.lessThan100Text.setValue(widthParams.pa_lessThan100);
        this.lessThan10Text.setValue(widthParams.pa_lessThan10);
        this.greaterThanText.setValue(widthParams.pa_greater);
    }

    private JPanel createButtonPanel() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JPanel defautsPanel = new JPanel(new FlowLayout(4));
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        JButton restoreDefaultsButton = new JButton("Restore Defaults");
        restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeWidthDialog.this.setTextFieldValues(WidthFunction.EdgeWidthParams.defaultValues());
            }
        });
        defautsPanel.add(restoreDefaultsButton);
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeWidthDialog.this.dispose();
            }
        });
        JButton createButton = new JButton("OK");
        buttonPanel.add(createButton);
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double emLowerWidth = ((Number)EdgeWidthDialog.this.emLowerWidthText.getValue()).doubleValue();
                double emUpperWidth = ((Number)EdgeWidthDialog.this.emUpperWidthText.getValue()).doubleValue();
                double lessThan100 = ((Number)EdgeWidthDialog.this.lessThan100Text.getValue()).doubleValue();
                double lessThan10 = ((Number)EdgeWidthDialog.this.lessThan10Text.getValue()).doubleValue();
                double greaterThan = ((Number)EdgeWidthDialog.this.greaterThanText.getValue()).doubleValue();
                WidthFunction.EdgeWidthParams params = new WidthFunction.EdgeWidthParams(emLowerWidth, emUpperWidth, lessThan100, lessThan10, greaterThan);
                params.save(EdgeWidthDialog.this.network);
                Task task = new Task(){

                    public void run(TaskMonitor taskMonitor) throws Exception {
                        taskMonitor.setTitle("EnrichmentMap");
                        taskMonitor.setStatusMessage("Calculating Post-Analysis Edge Widths");
                        WidthFunction widthFunction = new WidthFunction(EdgeWidthDialog.this.vmfFactoryContinuous);
                        widthFunction.setEdgeWidths(EdgeWidthDialog.this.network, EdgeWidthDialog.this.prefix, taskMonitor);
                    }

                    public void cancel() {
                    }
                };
                EdgeWidthDialog.this.taskManager.execute(new TaskIterator(new Task[]{task}));
                EdgeWidthDialog.this.dispose();
            }
        });
        parentPanel.add((Component)defautsPanel, "West");
        parentPanel.add((Component)buttonPanel, "East");
        return parentPanel;
    }
}

