/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cern.jet.stat.Gamma;

public class Hypergeometric {
    private Hypergeometric() {
    }

    public static double hyperGeomPvalue(int N, int n, int m, int k) throws ArithmeticException {
        double log_p = Hypergeometric.binomialLog(m, k) + Hypergeometric.binomialLog(N - m, n - k) - Hypergeometric.binomialLog(N, n);
        return Math.exp(log_p);
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k, int mode) throws ArithmeticException {
        double sum = 0.0;
        switch (mode) {
            case 0: {
                int kMax = Math.min(n, m);
                for (int k_prime = k; k_prime <= kMax; ++k_prime) {
                    sum += Hypergeometric.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 1: {
                int kMax = Math.min(n, m);
                for (int k_prime = k + 1; k_prime <= kMax; ++k_prime) {
                    sum += Hypergeometric.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 2: {
                for (int k_prime = k; k_prime >= 0; --k_prime) {
                    sum += Hypergeometric.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 3: {
                for (int k_prime = k - 1; k_prime >= 0; --k_prime) {
                    sum += Hypergeometric.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
        }
        return sum;
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k) throws ArithmeticException {
        return Hypergeometric.hyperGeomPvalue_sum(N, n, m, k, 0);
    }

    public static double binomialLog(int n, int k) throws ArithmeticException {
        return Gamma.logGamma((double)n + 1.0) - Gamma.logGamma((double)k + 1.0) - Gamma.logGamma((double)(n - k) + 1.0);
    }
}

