/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.ConcurrentModificationException;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisVisualStyle;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CreatePostAnalysisVisualStyleTask
extends AbstractTask {
    private final EnrichmentMap map;
    private final CyApplicationManager applicationManager;
    private final VisualMappingManager visualMappingManager;
    private final VisualStyleFactory visualStyleFactory;
    private final CyEventHelper eventHelper;
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;
    private BuildDiseaseSignatureTaskResult taskResult;

    public CreatePostAnalysisVisualStyleTask(EnrichmentMap map, CyApplicationManager applicationManager, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, CyEventHelper eventHelper, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.map = map;
        this.applicationManager = applicationManager;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.eventHelper = eventHelper;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
    }

    public void setBuildDiseaseSignatureTaskResult(BuildDiseaseSignatureTaskResult result) {
        this.taskResult = result;
    }

    private VisualStyle attemptToGetExistingStyle(String vs_name) {
        for (VisualStyle vs : this.visualMappingManager.getAllVisualStyles()) {
            if (vs.getTitle() == null || !vs.getTitle().equals(vs_name)) continue;
            return vs;
        }
        return null;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("EnrichmentMap");
        taskMonitor.setStatusMessage("Create Post-Analysis Visual Style");
        if (this.taskResult == null) {
            return;
        }
        String prefix = this.map.getParams().getAttributePrefix();
        String vs_name = prefix + "Post_analysis_style";
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        PostAnalysisVisualStyle pa_vs = new PostAnalysisVisualStyle(this.map.getParams(), this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough);
        pa_vs.applyNetworkSpeficifProperties(this.taskResult, prefix, taskMonitor);
        VisualStyle vs = this.attemptToGetExistingStyle(vs_name);
        if (vs == null) {
            vs = this.visualStyleFactory.createVisualStyle(vs_name);
            pa_vs.createVisualStyle(vs, prefix);
            this.visualMappingManager.addVisualStyle(vs);
        }
        this.visualMappingManager.setCurrentVisualStyle(vs);
        try {
            vs.apply(view);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.eventHelper.flushPayloadEvents();
        view.updateView();
    }
}

