/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import org.baderlab.csplugins.brainlib.DistanceMetric;

public class PearsonCorrelation
extends DistanceMetric {
    @Override
    public double calc(Object expr1, Object expr2) {
        Double[] x = (Double[])expr1;
        Double[] y = (Double[])expr2;
        double result = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_xy = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum_x += x[i].doubleValue();
            sum_y += y[i].doubleValue();
            sum_xy += x[i] * y[i];
            sum_sq_x += x[i] * x[i];
            sum_sq_y += y[i] * y[i];
        }
        double numerator = (sum_xy /= (double)x.length) - (sum_x /= (double)x.length) * (sum_y /= (double)y.length);
        double denominator = Math.sqrt((sum_sq_x /= (double)x.length) - sum_x * sum_x) * Math.sqrt((sum_sq_y /= (double)y.length) - sum_y * sum_y);
        if (denominator == 0.0) {
            throw new RuntimeException("standard deviation is zero");
        }
        result = numerator / denominator;
        return 1.0 - result;
    }
}

