/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class HeatMapExporterTask
extends AbstractTask {
    final JTable jtable1;
    final JTableHeader header;
    final File file;

    public HeatMapExporterTask(JTable jtable1, JTableHeader header, File file) {
        this.jtable1 = jtable1;
        this.header = header;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("EnrichmentMap");
        taskMonitor.setStatusMessage("Exporting Heat Map");
        int headerHeight = this.header.getHeight();
        Rectangle pageSize = new Rectangle(this.jtable1.getWidth(), this.jtable1.getHeight() + headerHeight * 2);
        Document document = new Document(pageSize);
        try (FileOutputStream stream = new FileOutputStream(this.file);){
            PdfWriter writer = PdfWriter.getInstance(document, stream);
            try {
                document.open();
                PdfContentByte canvas = writer.getDirectContent();
                float width = pageSize.getWidth();
                float height = pageSize.getHeight();
                Graphics2D g1 = canvas.createGraphics(width, headerHeight);
                this.header.paint(g1);
                g1.dispose();
                taskMonitor.setProgress(0.25);
                Graphics2D g2 = canvas.createGraphics(width, height);
                this.jtable1.paint(g2);
                g2.dispose();
                taskMonitor.setProgress(0.5);
                Graphics2D g3 = canvas.createGraphics(width, headerHeight);
                this.header.paint(g3);
                g3.dispose();
                taskMonitor.setProgress(0.75);
            }
            finally {
                document.close();
                writer.close();
                taskMonitor.setProgress(0.99);
            }
        }
        catch (DocumentException exp) {
            throw new IOException(exp);
        }
    }
}

