/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.parsers.RanksFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

public class HeatMapActionListener
implements ActionListener {
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private FileUtil fileUtil;
    private StreamUtil streamUtil;
    private CySwingApplication application;
    private HeatMapParameters hmParams;
    private JComboBox box;
    private EnrichmentMapParameters params;
    private EnrichmentMap map;

    public HeatMapActionListener(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel, JComboBox box, HeatMapParameters hmParams, EnrichmentMap map, FileUtil fileUtil, StreamUtil streamUtil, CySwingApplication application) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.fileUtil = fileUtil;
        this.application = application;
        this.streamUtil = streamUtil;
        this.hmParams = hmParams;
        this.box = box;
        this.params = map.getParams();
        this.map = map;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        boolean updateAscendingButton = false;
        this.edgeOverlapPanel.clearPanel();
        this.nodeOverlapPanel.clearPanel();
        String select = (String)this.box.getSelectedItem();
        if (select.equalsIgnoreCase("Data As Is")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.ASIS);
        } else if (select.equalsIgnoreCase("Row Normalize Data")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.ROWNORM);
        } else if (select.equalsIgnoreCase("Log Transform Data")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.LOGTRANSFORM);
        } else if (select.equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) {
            this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
            this.hmParams.setSortIndex(-1);
        } else if (select.equalsIgnoreCase("Add Rankings ... ")) {
            HashMap<String, Ranking> all_ranks = this.map.getAllRanks();
            FileChooserFilter filter_rnk = new FileChooserFilter("rnk Files", "rnk");
            FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
            FileChooserFilter filter_xls = new FileChooserFilter("xls Files", "xls");
            ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
            all_filters.add(filter_rnk);
            all_filters.add(filter_txt);
            all_filters.add(filter_xls);
            File file = this.fileUtil.getFile((Component)this.application.getJFrame(), "Import rank File", 0, all_filters);
            if (file != null) {
                String ranks_name = JOptionPane.showInputDialog(this.nodeOverlapPanel, "What would you like to name these Rankings?", "My Rankings");
                boolean noname = true;
                while (noname) {
                    noname = false;
                    Iterator<String> j = all_ranks.keySet().iterator();
                    while (j.hasNext()) {
                        String current_name = j.next().toString();
                        if (!current_name.equalsIgnoreCase(ranks_name)) continue;
                        noname = true;
                        ranks_name = JOptionPane.showInputDialog(this.nodeOverlapPanel, (Object)"Sorry that name already exists.Please choose another name.");
                    }
                }
                RanksFileReaderTask ranking1 = new RanksFileReaderTask(file.getAbsolutePath(), this.map.getDataset("Dataset 1"), ranks_name, true, this.streamUtil);
                try {
                    ranking1.parse(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                boolean[] ascending = this.hmParams.getAscending();
                boolean[] new_ascending = new boolean[ascending.length + 1];
                System.arraycopy(ascending, 0, new_ascending, 0, ascending.length);
                new_ascending[new_ascending.length - 1] = true;
                this.hmParams.setAscending(new_ascending);
            }
        } else if (select.equalsIgnoreCase(HeatMapParameters.sort_none)) {
            this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            this.hmParams.setSortIndex(-1);
            this.hmParams.setRankFileIndex("");
        } else if (select.contains(HeatMapParameters.sort_column)) {
            this.hmParams.setRankFileIndex("");
            this.hmParams.setSort(HeatMapParameters.Sort.COLUMN);
            if (this.hmParams.isSortbycolumn_event_triggered()) {
                this.hmParams.setSortbycolumn_event_triggered(false);
                this.hmParams.flipAscending(this.hmParams.getSortIndex());
            }
        } else {
            HashSet<String> ranks = this.map.getAllRankNames();
            int i = 0;
            int columns = 0;
            columns = this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename()) ? this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length + this.map.getDataset("Dataset 2").getExpressionSets().getColumnNames().length - 2 : this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length;
            Iterator<String> j = ranks.iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (ranks_name.equalsIgnoreCase(select)) {
                    this.hmParams.setSort(HeatMapParameters.Sort.RANK);
                    this.hmParams.setRankFileIndex(ranks_name);
                    this.hmParams.setSortIndex(columns + i);
                    updateAscendingButton = true;
                }
                ++i;
            }
        }
        if (updateAscendingButton && this.hmParams.isSortbycolumn_event_triggered()) {
            this.hmParams.setSortbycolumn_event_triggered(false);
            this.hmParams.flipAscending(this.hmParams.getSortIndex());
        }
        this.hmParams.ResetColorGradient_ds1();
        if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
            this.hmParams.ResetColorGradient_ds2();
        }
        this.edgeOverlapPanel.updatePanel();
        this.nodeOverlapPanel.updatePanel();
    }
}

