/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.model;

import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DrawClusterLabelTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ClusterTableModel
extends AbstractTableModel
implements TableModelListener {
    private static final long serialVersionUID = -1277709187563893042L;
    private String[] columnNames;
    private Vector<Object> dataVector;
    private TreeMap<Integer, Cluster> clusters;
    Class<?>[] types = new Class[]{Object.class, Integer.class};

    public ClusterTableModel(String[] columnNames, Object[][] data, TreeMap<Integer, Cluster> clusters) {
        this.columnNames = columnNames;
        this.clusters = new TreeMap();
        this.clusters.putAll(clusters);
        this.dataVector = new Vector(data.length);
        for (int r = 0; r < data.length; ++r) {
            this.dataVector.add(this.convertToVector(data[r]));
        }
    }

    public Integer getClusterId(int row) {
        String clusterName = this.getValueAt(row, 0).toString();
        for (Map.Entry<Integer, Cluster> entry : this.clusters.entrySet()) {
            if (!clusterName.equals(entry.getValue().getLabel())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public Integer getRowIndexOfCluster(Cluster cluster) {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            if (!cluster.equals(this.getValueAt(rowIndex, 0))) continue;
            return rowIndex;
        }
        return -1;
    }

    public void removeClusterFromTable(Cluster cluster) {
        this.removeRow(this.getRowIndexOfCluster(cluster));
    }

    public void addClusterToTable(Cluster cluster) {
        Object[] newRow = new Object[]{cluster, cluster.getSize()};
        this.addRow(newRow);
        this.clusters.put(cluster.getClusterNumber(), cluster);
    }

    public void updateClusterInTable(Cluster cluster) {
        int clusterIndex = this.getRowIndexOfCluster(cluster);
        if (clusterIndex != -1 && !this.getValueAt(clusterIndex, 1).equals(cluster.getSize())) {
            this.setValueAt(cluster.getSize(), clusterIndex, 1);
        }
    }

    public void updateTable(TreeMap<Integer, Cluster> newclusters) {
        boolean i = false;
        for (Cluster cluster : newclusters.values()) {
            int clusterIndex = this.getRowIndexOfCluster(cluster);
            if (clusterIndex != -1 && !this.getValueAt(clusterIndex, 1).equals(cluster.getSize())) {
                this.setValueAt(cluster.getSize(), clusterIndex, 1);
                continue;
            }
            if (clusterIndex != -1) continue;
            Object[] newRow = new Object[]{cluster, cluster.getSize()};
            this.addRow(newRow);
            this.clusters.put(cluster.getClusterNumber(), cluster);
        }
        for (Cluster cluster : this.clusters.values()) {
            if (newclusters.containsValue(cluster)) continue;
            this.removeRow(this.getRowIndexOfCluster(cluster));
        }
        this.clusters = newclusters;
    }

    public void addRow(Object[] newrow) {
        int rowIndex = this.dataVector.size();
        this.dataVector.add(this.convertToVector(newrow));
        this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, 1));
    }

    public void removeRow(int row) {
        if (row < this.dataVector.size() && row != -1) {
            this.dataVector.remove(row);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Vector)this.dataVector.get(rowIndex)).get(columnIndex);
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int clusterID = this.getClusterId(rowIndex);
        Cluster currentCluster = this.clusters.get(clusterID);
        currentCluster.setLabel(aValue.toString());
        currentCluster.eraseText();
        DrawClusterLabelTask drawlabel = new DrawClusterLabelTask(currentCluster);
        AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new TaskIterator(new Task[]{drawlabel}));
    }

    private Vector<Object> convertToVector(Object[] data) {
        if (data == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(data.length);
        for (int i = 0; i < data.length; ++i) {
            vector.add(data[i]);
        }
        return vector;
    }
}

