/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.view.SliderBarPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class SliderBarActionListener
implements ChangeListener {
    private CyApplicationManager applicationManager;
    private SliderBarPanel panel;
    private ArrayList<HiddenNodes> hiddenNodes;
    private ArrayList<CyEdge> hiddenEdges;
    private String attrib_dataset1;
    private String attrib_dataset2;
    private boolean onlyEdges = false;

    public SliderBarActionListener(SliderBarPanel panel, String attrib1, String attrib2, boolean onlyEdges, CyApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
        this.panel = panel;
        this.hiddenNodes = new ArrayList();
        this.hiddenEdges = new ArrayList();
        this.attrib_dataset1 = attrib1;
        this.attrib_dataset2 = attrib2;
        this.onlyEdges = onlyEdges;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.onlyEdges) {
            this.hideEdgesOnly(e);
            return;
        }
        JSlider source = (JSlider)e.getSource();
        Double max_cutoff = (double)source.getValue() / this.panel.getPrecision();
        Double min_cutoff = (double)source.getMinimum() / this.panel.getPrecision();
        this.panel.setLabel(source.getValue());
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        CyTable attributes = network.getDefaultNodeTable();
        List nodes = network.getNodeList();
        EnrichmentMapParameters params = EnrichmentMapManager.getInstance().getMap(network.getSUID()).getParams();
        String prefix = params.getAttributePrefix();
        for (CyNode i : nodes) {
            Object edges;
            CyNode currentNode = network.getNode(i.getSUID().longValue());
            View currentView = view.getNodeView(currentNode);
            if (attributes.getColumn(prefix + "GS_Type") != null && !"ENR".equalsIgnoreCase((String)network.getRow((CyIdentifiable)currentNode).get(prefix + "GS_Type", String.class))) continue;
            Double pvalue_dataset1 = (Double)network.getRow((CyIdentifiable)currentNode).get(prefix + this.attrib_dataset1, Double.class);
            if (pvalue_dataset1 == null) {
                pvalue_dataset1 = 0.99;
            }
            if (!(pvalue_dataset1 > max_cutoff) && !(pvalue_dataset1 < min_cutoff)) continue;
            if (params.isTwoDatasets()) {
                Double pvalue_dataset2 = (Double)network.getRow((CyIdentifiable)currentNode).get(prefix + this.attrib_dataset2, Double.class);
                if (pvalue_dataset2 == null) {
                    pvalue_dataset2 = 0.99;
                }
                if (!(pvalue_dataset2 > max_cutoff) && !(pvalue_dataset2 < min_cutoff)) continue;
                edges = network.getAdjacentEdgeList(currentNode, CyEdge.Type.ANY);
                Iterator iterator = edges.iterator();
                while (iterator.hasNext()) {
                    CyEdge m;
                    CyEdge currentEdge = m = (CyEdge)iterator.next();
                    this.hiddenEdges.add(network.getEdge(currentEdge.getSUID().longValue()));
                    View currentEdgeView = view.getEdgeView(currentEdge);
                    currentEdgeView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
                }
                this.hiddenNodes.add(new HiddenNodes(currentNode, (Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION), (Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)));
                currentView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)false);
                continue;
            }
            List edges2 = network.getAdjacentEdgeList(currentNode, CyEdge.Type.ANY);
            edges = edges2.iterator();
            while (edges.hasNext()) {
                CyEdge m;
                CyEdge currentEdge = m = (CyEdge)edges.next();
                this.hiddenEdges.add(network.getEdge(currentEdge.getSUID().longValue()));
                View currentEdgeView = view.getEdgeView(currentEdge);
                currentEdgeView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
            }
            this.hiddenNodes.add(new HiddenNodes(currentNode, (Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION), (Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)));
            currentView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)false);
        }
        ArrayList<HiddenNodes> unhiddenNodes = new ArrayList<HiddenNodes>();
        ArrayList<CyEdge> unhiddenEdges = new ArrayList<CyEdge>();
        for (HiddenNodes currentHN : this.hiddenNodes) {
            CyNode currentNode = currentHN.getNode();
            Double pvalue_dataset1 = (Double)network.getRow((CyIdentifiable)currentNode).get(prefix + this.attrib_dataset1, Double.class);
            if (pvalue_dataset1 == null) {
                pvalue_dataset1 = 0.99;
            }
            if (pvalue_dataset1 <= max_cutoff && pvalue_dataset1 >= min_cutoff) {
                View currentNodeView = view.getNodeView(currentNode);
                currentNodeView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)true);
                currentNodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)currentHN.getX());
                currentNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)currentHN.getY());
                view.updateView();
                unhiddenNodes.add(currentHN);
            }
            if (!params.isTwoDatasets()) continue;
            Double pvalue_dataset2 = (Double)network.getRow((CyIdentifiable)currentNode).get(prefix + this.attrib_dataset2, Double.class);
            if (pvalue_dataset2 == null) {
                pvalue_dataset2 = 0.99;
            }
            if (!(pvalue_dataset2 <= max_cutoff) || !(pvalue_dataset2 >= min_cutoff)) continue;
            View currentNodeView = view.getNodeView(currentNode);
            currentNodeView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)true);
            currentNodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)currentHN.getX());
            currentNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)currentHN.getY());
            unhiddenNodes.add(currentHN);
        }
        for (CyEdge currentEdge : this.hiddenEdges) {
            View nodeSourceView = view.getNodeView(currentEdge.getSource());
            View nodeTargetView = view.getNodeView(currentEdge.getTarget());
            if (!((Boolean)nodeSourceView.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue() || !((Boolean)nodeTargetView.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
            View currentView = view.getEdgeView(currentEdge);
            currentView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)true);
            unhiddenEdges.add(currentEdge);
        }
        Iterator<Object> k = unhiddenNodes.iterator();
        while (k.hasNext()) {
            this.hiddenNodes.remove(k.next());
        }
        k = unhiddenEdges.iterator();
        while (k.hasNext()) {
            this.hiddenEdges.remove(k.next());
        }
        view.updateView();
    }

    public void hideEdgesOnly(ChangeEvent e) {
        View currentView;
        JSlider source = (JSlider)e.getSource();
        Double min_cutoff = (double)source.getValue() / this.panel.getPrecision();
        Double max_cutoff = (double)source.getMaximum() / this.panel.getPrecision();
        this.panel.setLabel(source.getValue());
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        CyTable attributes = network.getDefaultEdgeTable();
        List edges = network.getEdgeList();
        String prefix = EnrichmentMapManager.getInstance().getMap(network.getSUID()).getParams().getAttributePrefix();
        for (CyEdge i : edges) {
            CyEdge currentEdge = network.getEdge(i.getSUID().longValue());
            if (attributes.getColumn(prefix + "GS_Type") != null && !"ENR".equalsIgnoreCase((String)network.getRow((CyIdentifiable)currentEdge).get(prefix + "GS_Type", String.class))) continue;
            Double similarity_cutoff = (Double)network.getRow((CyIdentifiable)currentEdge).get(prefix + this.attrib_dataset1, Double.class);
            if (similarity_cutoff == null) {
                similarity_cutoff = 0.1;
            }
            if (!(similarity_cutoff > max_cutoff) && !(similarity_cutoff < min_cutoff)) continue;
            this.hiddenEdges.add(currentEdge);
            currentView = view.getEdgeView(currentEdge);
            currentView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
        }
        ArrayList<CyEdge> unhiddenEdges = new ArrayList<CyEdge>();
        for (CyEdge currentEdge : this.hiddenEdges) {
            Double similarity_curoff = (Double)network.getRow((CyIdentifiable)currentEdge).get(prefix + this.attrib_dataset1, Double.class);
            if (similarity_curoff == null) {
                similarity_curoff = 0.1;
            }
            if (!(similarity_curoff <= max_cutoff) || !(similarity_curoff >= min_cutoff)) continue;
            currentView = view.getEdgeView(currentEdge);
            currentView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)true);
            unhiddenEdges.add(currentEdge);
        }
        Iterator k = unhiddenEdges.iterator();
        while (k.hasNext()) {
            this.hiddenEdges.remove(k.next());
        }
        view.updateView();
    }

    private class HiddenNodes {
        CyNode node;
        double x;
        double y;

        public HiddenNodes(CyNode node, double x, double y) {
            this.node = node;
            this.x = x;
            this.y = y;
        }

        public CyNode getNode() {
            return this.node;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

