/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.heatmap.CellHighlightRenderer;
import org.baderlab.csplugins.enrichmentmap.heatmap.ColorRenderer;
import org.baderlab.csplugins.enrichmentmap.heatmap.ColumnHeaderVerticalRenderer;
import org.baderlab.csplugins.enrichmentmap.heatmap.ExpressionTableValue;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapActionListener;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapExporterTask;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapTableActionListener;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapTableModel;
import org.baderlab.csplugins.enrichmentmap.heatmap.RawExpressionValueRenderer;
import org.baderlab.csplugins.enrichmentmap.heatmap.RowNumberTable;
import org.baderlab.csplugins.enrichmentmap.heatmap.TableHeader;
import org.baderlab.csplugins.enrichmentmap.heatmap.TableSort;
import org.baderlab.csplugins.enrichmentmap.heatmap.task.HeatMapHierarchicalClusterTaskFactory;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.model.SignificantGene;
import org.baderlab.csplugins.enrichmentmap.parsers.DetermineEnrichmentResultFileReader;
import org.baderlab.csplugins.enrichmentmap.task.ResultTaskObserver;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;
import org.mskcc.colorgradient.ColorGradientWidget;

public class HeatMapPanel
extends JPanel
implements CytoPanelComponent {
    private CySwingApplication application;
    private CyApplicationManager applicationManager;
    private FileUtil fileUtil;
    private OpenBrowser openBrowser;
    private DialogTaskManager dialogTaskMonitor;
    private StreamUtil streamUtil;
    private static final long serialVersionUID = 1903063204304411983L;
    private Object[] columnNames;
    private Object[] columnNames2;
    private String[] phenotypes;
    private String[] phenotypes2;
    private Object[][] expValue;
    private JCheckBox showValues;
    private int numConditions = 0;
    private int numConditions2 = 0;
    private String[] hRow1;
    private String[] hRow2;
    private String[] rowGeneName;
    private int[] rowLength;
    private ColorGradientTheme[] rowTheme;
    private ColorGradientRange[] rowRange;
    private int[] halfRow1Length;
    private int[] halfRow2Length;
    private ColorGradientTheme[] themeHalfRow1;
    private ColorGradientTheme[] themeHalfRow2;
    private ColorGradientRange[] rangeHalfRow1;
    private ColorGradientRange[] rangeHalfRow2;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private HashMap<Integer, GeneExpression> currentExpressionSet;
    private HashMap<Integer, GeneExpression> currentExpressionSet2;
    private Ranking ranks;
    private boolean node = true;
    private boolean shownPearsonErrorMsg = false;
    private String Dataset1phenotype1;
    private String Dataset1phenotype2;
    private String Dataset2phenotype1;
    private String Dataset2phenotype2;
    private HeatMapParameters hmParams;
    private EnrichmentMapParameters params;
    private EnrichmentMap map;
    private JPopupMenu rightClickPopupMenu;
    private Map<String, Map<String, String>> linkoutProps;
    private boolean displayLeadingEdge = false;
    private boolean OnlyLeadingEdge = false;
    private double leadingEdgeScoreAtMax1 = 0.0;
    private double leadingEdgeScoreAtMax2 = 0.0;
    private int leadingEdgeRankAtMax1 = 0;
    private int leadingEdgeRankAtMax2 = 0;
    private JTable jTable1;
    private JTableHeader tableHdr;
    private JPanel northPanel;
    private JComboBox rankOptionComboBox;
    static final int Ascending = 0;
    static final int Descending = 1;
    private ImageIcon[] iconArrow = this.createExpandAndCollapseIcon();

    public HeatMapPanel(boolean node, CySwingApplication application, FileUtil fileUtil, CyApplicationManager applicationManager, OpenBrowser openBrowser, DialogTaskManager dialogTaskMonitor, StreamUtil streamUtil) {
        this.node = node;
        this.setLayout(new BorderLayout());
        this.initialize_linkouts();
        this.rightClickPopupMenu = new JPopupMenu();
        this.application = application;
        this.applicationManager = applicationManager;
        this.openBrowser = openBrowser;
        this.dialogTaskMonitor = dialogTaskMonitor;
        this.streamUtil = streamUtil;
        this.fileUtil = fileUtil;
    }

    public void resetVariables(EnrichmentMap map) {
        this.map = map;
        this.params = map.getParams();
        this.ranks = null;
        if (this.params.isData() || this.params.isData2()) {
            boolean[] ascending;
            GeneExpressionMatrix expression = map.getDataset("Dataset 1").getExpressionSets();
            this.numConditions = expression.getNumConditions();
            this.columnNames = expression.getColumnNames();
            this.phenotypes = expression.getPhenotypes();
            this.Dataset1phenotype1 = this.params.getFiles().get("Dataset 1").getPhenotype1();
            this.Dataset1phenotype2 = this.params.getFiles().get("Dataset 1").getPhenotype2();
            this.hmParams = this.params.getHmParams();
            if (expression.getRanks() != null) {
                ascending = new boolean[this.columnNames.length + map.getAllRankNames().size()];
                for (int k = ascending.length; k > ascending.length - map.getAllRankNames().size(); --k) {
                    ascending[k - 1] = true;
                }
            } else {
                ascending = new boolean[this.columnNames.length];
            }
            if (this.hmParams != null) {
                this.hmParams.setAscending(ascending);
            }
            this.displayLeadingEdge = false;
            this.leadingEdgeScoreAtMax1 = 0.0;
            this.leadingEdgeScoreAtMax2 = 0.0;
            this.leadingEdgeRankAtMax1 = 0;
            this.leadingEdgeRankAtMax2 = 0;
            if (this.node) {
                this.initializeLeadingEdge(this.params);
            }
            if (this.params.isData2() && map.getDataset("Dataset 2").getExpressionSets() != null && !map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                GeneExpressionMatrix expression2 = map.getDataset("Dataset 2").getExpressionSets();
                this.numConditions2 = expression2.getNumConditions();
                this.columnNames2 = expression2.getColumnNames();
                int additional_ranks = map.getAllRankNames() != null ? map.getAllRankNames().size() : 0;
                boolean[] ascending2 = new boolean[this.columnNames.length + (this.columnNames2.length - 2) + additional_ranks];
                for (int k = ascending2.length; k > ascending2.length - map.getAllRankNames().size(); --k) {
                    ascending2[k - 1] = true;
                }
                if (this.hmParams != null) {
                    this.hmParams.setAscending(ascending2);
                }
            }
            if (this.params.isData2() && map.getDataset("Dataset 2").getExpressionSets() != null) {
                this.phenotypes2 = map.getDataset("Dataset 2").getExpressionSets().getPhenotypes();
                this.Dataset2phenotype1 = this.params.getFiles().get("Dataset 2").getPhenotype1();
                this.Dataset2phenotype2 = this.params.getFiles().get("Dataset 2").getPhenotype2();
            }
        }
    }

    public void updatePanel(EnrichmentMap map) {
        this.resetVariables(map);
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.currentExpressionSet != null || this.currentExpressionSet2 != null) {
            int i;
            HeatMapTableModel OGT;
            Object[][] data;
            Object[] mergedcolumnNames = null;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                this.expValue = this.createSortedMergedTableData();
                data = this.createSortedMergedTableData(this.getExpValue());
                mergedcolumnNames = new String[this.columnNames.length + this.columnNames2.length - 2];
                System.arraycopy(this.columnNames, 0, mergedcolumnNames, 0, this.columnNames.length);
                System.arraycopy(this.columnNames2, 2, mergedcolumnNames, this.columnNames.length, this.columnNames2.length - 2);
                OGT = new HeatMapTableModel(mergedcolumnNames, data, this.expValue);
            } else {
                this.expValue = this.createSortedTableData();
                data = this.createSortedTableData(this.getExpValue());
                OGT = new HeatMapTableModel(this.columnNames, data, this.expValue);
            }
            CellHighlightRenderer highlightCellRenderer = new CellHighlightRenderer();
            TableSort sort = new TableSort(OGT);
            this.jTable1 = new JTable(sort);
            this.jTable1.addMouseListener(new HeatMapTableActionListener(this.jTable1, OGT, this.rightClickPopupMenu, this.linkoutProps, this.openBrowser));
            TableHeader header = new TableHeader(sort, this.jTable1, this.hmParams, this);
            this.tableHdr = this.jTable1.getTableHeader();
            this.tableHdr.addMouseListener(header);
            if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN) {
                boolean ascending = this.hmParams.isAscending(this.hmParams.getSortIndex());
                if (this.hmParams.getSortIndex() >= this.columnNames.length) {
                    this.hmParams.setSortbycolumnName((String)this.columnNames2[this.hmParams.getSortIndex() - this.columnNames.length + 2]);
                } else {
                    this.hmParams.setSortbycolumnName((String)this.columnNames[this.hmParams.getSortIndex()]);
                }
                header.sortByColumn(this.hmParams.getSortIndex(), ascending);
            }
            int defaultColumnwidth = 10;
            if (this.hmParams.isShowValues()) {
                this.jTable1.setDefaultRenderer(ExpressionTableValue.class, new RawExpressionValueRenderer());
                defaultColumnwidth = 50;
            } else {
                this.jTable1.setDefaultRenderer(ExpressionTableValue.class, new ColorRenderer());
            }
            this.jTable1.setDefaultRenderer(String.class, highlightCellRenderer);
            this.jTable1.setDefaultRenderer(SignificantGene.class, highlightCellRenderer);
            TableColumnModel tcModel = this.jTable1.getColumnModel();
            this.jTable1.setDragEnabled(false);
            this.jTable1.setCellSelectionEnabled(true);
            ColumnHeaderVerticalRenderer pheno1_renderer = new ColumnHeaderVerticalRenderer();
            pheno1_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype1);
            ColumnHeaderVerticalRenderer pheno2_renderer = new ColumnHeaderVerticalRenderer();
            pheno2_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype2);
            ColumnHeaderVerticalRenderer default_renderer = new ColumnHeaderVerticalRenderer();
            default_renderer.setBackground(Color.white);
            if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(defaultColumnwidth);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
                for (i = this.columnNames.length; i < this.columnNames.length + this.columnNames2.length - 2; ++i) {
                    tcModel.getColumn(i).setPreferredWidth(defaultColumnwidth);
                    if (this.phenotypes2 != null) {
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            } else {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(defaultColumnwidth);
                    if (this.phenotypes != null && this.phenotypes.length + 2 == this.columnNames.length) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset2phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset2phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            }
            this.jTable1.setColumnModel(tcModel);
            JScrollPane jScrollPane = new JScrollPane(this.jTable1);
            RowNumberTable rowTable = new RowNumberTable(this.jTable1);
            jScrollPane.setRowHeaderView(rowTable);
            if (this.columnNames.length > 20) {
                this.jTable1.setAutoResizeMode(0);
            }
            mainPanel.add(jScrollPane);
            mainPanel.revalidate();
            this.add((Component)this.createNorthPanel(), "North");
            this.add((Component)jScrollPane, "Center");
        }
        this.revalidate();
    }

    private Object[][] createSortedTableData(Object[][] expValue2) {
        this.expValue = expValue2;
        int[] HRow = this.getRowLength();
        ColorGradientTheme[] RowCRT = this.getRowTheme();
        ColorGradientRange[] RowCRR = this.getRowRange();
        String[] RowGene = this.getRowGeneName();
        int kValue = this.currentExpressionSet.size();
        Object[][] data = new Object[this.currentExpressionSet.size()][this.numConditions];
        for (int k = 0; k < kValue; ++k) {
            data[k][0] = this.expValue[k][0];
            data[k][1] = this.expValue[k][1];
            for (int j = 0; j < HRow[k]; ++j) {
                if (this.numConditions == 2) {
                    data[k][j + 1] = new ExpressionTableValue((Double)this.expValue[k][j + 1], this.getColor(RowCRT[k], RowCRR[k], RowGene[k], (Double)this.expValue[k][j + 1]));
                    continue;
                }
                data[k][j + 2] = new ExpressionTableValue((Double)this.expValue[k][j + 2], this.getColor(RowCRT[k], RowCRR[k], RowGene[k], (Double)this.expValue[k][j + 2]));
            }
        }
        return data;
    }

    private Color getColor(ColorGradientTheme theme, ColorGradientRange range, String gene, Double measurement) {
        if (theme == null || range == null || measurement == null) {
            return Color.GRAY;
        }
        float rLow = theme.getMinColor().getRed() / 255;
        float gLow = theme.getMinColor().getGreen() / 255;
        float bLow = theme.getMinColor().getBlue() / 255;
        float rMid = theme.getCenterColor().getRed() / 255;
        float gMid = theme.getCenterColor().getGreen() / 255;
        float bMid = theme.getCenterColor().getBlue() / 255;
        float rHigh = theme.getMaxColor().getRed() / 255;
        float gHigh = theme.getMaxColor().getGreen() / 255;
        float bHigh = theme.getMaxColor().getBlue() / 255;
        double median = range.getMinValue() >= 0.0 ? range.getMaxValue() / 2.0 : 0.0;
        if (measurement <= median) {
            float prop = (float)((double)((float)(measurement - range.getMinValue())) / (median - range.getMinValue()));
            float rVal = rLow + prop * (rMid - rLow);
            float gVal = gLow + prop * (gMid - gLow);
            float bVal = bLow + prop * (bMid - bLow);
            return new Color(rVal, gVal, bVal);
        }
        if (measurement > range.getMaxValue()) {
            measurement = range.getMaxValue();
        }
        float prop = (float)((double)((float)(measurement - median)) / (range.getMaxValue() - median));
        float rVal = rMid + prop * (rHigh - rMid);
        float gVal = gMid + prop * (gHigh - gMid);
        float bVal = bMid + prop * (bHigh - bMid);
        return new Color(rVal, gVal, bVal);
    }

    private Object[][] createSortedMergedTableData(Object[][] expValue) {
        this.expValue = expValue;
        int[] HRow1 = this.getHalfRow1Length();
        int[] HRow2 = this.getHalfRow2Length();
        ColorGradientTheme[] Row1CRT = this.getThemeHalfRow1();
        ColorGradientTheme[] Row2CRT = this.getThemeHalfRow2();
        ColorGradientRange[] Row1CRR = this.getRangeHalfRow1();
        ColorGradientRange[] Row2CRR = this.getRangeHalfRow2();
        String[] Row1gene = this.gethRow1();
        String[] Row2gene = this.gethRow2();
        int kValue = this.params.isTwoDistinctExpressionSets() ? expValue.length : Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        int totalConditions = this.numConditions == 2 && this.numConditions2 == 2 ? 3 : (this.numConditions == 2 ? 1 + this.numConditions2 : (this.numConditions2 == 2 ? 1 + this.numConditions : this.numConditions + this.numConditions2 - 2));
        Object[][] data = new Object[kValue][totalConditions];
        for (int k = 0; k < kValue; ++k) {
            int j;
            data[k][0] = expValue[k][0];
            data[k][1] = expValue[k][1];
            for (j = 0; j < HRow1[k]; ++j) {
                data[k][j + 2] = new ExpressionTableValue((Double)expValue[k][j + 2], this.getColor(Row1CRT[k], Row1CRR[k], Row1gene[k], (Double)expValue[k][j + 2]));
            }
            for (j = HRow1[k]; j < HRow2[k]; ++j) {
                data[k][j + 2] = new ExpressionTableValue((Double)expValue[k][j + 2], this.getColor(Row2CRT[k], Row2CRR[k], Row2gene[k], (Double)expValue[k][j + 2]));
            }
        }
        return data;
    }

    private Object[][] createSortedTableData() {
        this.expValue = new Object[this.currentExpressionSet.size()][this.numConditions];
        this.rowLength = new int[this.currentExpressionSet.size()];
        this.rowTheme = new ColorGradientTheme[this.currentExpressionSet.size()];
        this.rowGeneName = new String[this.currentExpressionSet.size()];
        this.rowRange = new ColorGradientRange[this.currentExpressionSet.size()];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap rank2keys = new HashMap();
        Ranking ranks = this.getRanks(this.currentExpressionSet);
        if (ranks == null) {
            ranks = this.getEmptyRanks(this.currentExpressionSet);
        }
        int topRank = -1;
        boolean isNegative = false;
        if (this.displayLeadingEdge && this.map.getDataset("Dataset 1").getExpressionSets().haveRanks() && (this.hmParams.getSort() == HeatMapParameters.Sort.RANK || this.params.getDefaultSortMethod().equalsIgnoreCase(this.hmParams.getSort().toString()))) {
            topRank = this.getTopRank();
            if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 1")) {
                isNegative = this.isNegativeGS(1);
            } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 2")) {
                isNegative = this.isNegativeGS(2);
            }
        }
        int n = 0;
        HashMap<Integer, Rank> current_ranks = ranks.getRanking();
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = current_ranks.containsKey(key) ? current_ranks.get(key).getRank() : Integer.valueOf(-1);
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        boolean ascending = this.hmParams.isAscending(this.hmParams.getSortIndex());
        if (ascending && isNegative && this.displayLeadingEdge && this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = false;
        } else if (!ascending && !isNegative && this.displayLeadingEdge && this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = true;
        }
        if (ascending) {
            Arrays.sort(ranks_subset);
        } else {
            Arrays.sort(ranks_subset, Collections.reverseOrder());
        }
        int k = 0;
        int previous = -1;
        boolean significant_gene = false;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            significant_gene = false;
            if ((Integer)ranks_subset[m] <= topRank && !isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            } else if ((Integer)ranks_subset[m] >= topRank && isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            }
            if (this.OnlyLeadingEdge && !significant_gene && topRank > 0) continue;
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer key : keys) {
                GeneExpression row = this.currentExpressionSet.get(key);
                Double[] expression_values = this.getExpression(row, 1);
                try {
                    this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(row.getName())) : Integer.valueOf(Integer.parseInt(row.getName()));
                }
                catch (NumberFormatException v) {
                    this.expValue[k][0] = significant_gene ? new SignificantGene(row.getName()) : row.getName();
                }
                this.expValue[k][1] = row.getDescription();
                this.rowLength[k] = row.getExpression().length;
                this.rowTheme[k] = this.hmParams.getTheme_ds1();
                this.rowRange[k] = this.hmParams.getRange_ds1();
                this.rowGeneName[k] = row.getName();
                for (int j = 0; j < row.getExpression().length; ++j) {
                    if (this.numConditions == 2) {
                        this.expValue[k][j + 1] = expression_values[j];
                        continue;
                    }
                    this.expValue[k][j + 2] = expression_values[j];
                }
                ++k;
            }
        }
        this.setRowTheme(this.rowTheme);
        this.setRowGeneName(this.rowGeneName);
        this.setRowRange(this.rowRange);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private Object[][] createSortedMergedTableData() {
        boolean ascending;
        HashMap<Integer, GeneExpression> expressionUsing;
        int totalConditions = this.numConditions == 2 && this.numConditions2 == 2 ? 3 : (this.numConditions == 2 ? 1 + this.numConditions2 : (this.numConditions2 == 2 ? 1 + this.numConditions : this.numConditions + this.numConditions2 - 2));
        if (this.currentExpressionSet.size() == 0) {
            expressionUsing = this.currentExpressionSet2;
        } else if (this.currentExpressionSet2.size() == 0) {
            expressionUsing = this.currentExpressionSet;
        } else {
            HashMap<Integer, GeneExpression> mergedExpression = new HashMap<Integer, GeneExpression>();
            mergedExpression.putAll(this.currentExpressionSet);
            for (Integer key : this.currentExpressionSet2.keySet()) {
                GeneExpression exp2 = this.currentExpressionSet2.get(key);
                if (mergedExpression.containsKey(key)) continue;
                mergedExpression.put(key, exp2);
            }
            expressionUsing = mergedExpression;
        }
        int kValue = this.params.isTwoDistinctExpressionSets() ? expressionUsing.size() : Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        this.expValue = new Object[kValue][totalConditions];
        this.hRow1 = new String[kValue];
        this.hRow2 = new String[kValue];
        this.halfRow1Length = new int[kValue];
        this.halfRow2Length = new int[kValue];
        this.rangeHalfRow1 = new ColorGradientRange[kValue];
        this.rangeHalfRow2 = new ColorGradientRange[kValue];
        this.themeHalfRow1 = new ColorGradientTheme[kValue];
        this.themeHalfRow2 = new ColorGradientTheme[kValue];
        Object[] ranks_subset = new Integer[kValue];
        HashMap<Object, ArrayList<Object>> rank2keys = new HashMap<Object, ArrayList<Object>>();
        Ranking ranks = this.getRanks(expressionUsing);
        if (ranks == null) {
            ranks = this.getEmptyRanks(expressionUsing);
        }
        int topRank = this.getTopRank();
        boolean isNegative = false;
        if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 1")) {
            isNegative = this.isNegativeGS(1);
        } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 2")) {
            isNegative = this.isNegativeGS(2);
        }
        int n = 0;
        int maxRank = 0;
        int missingRanksCount = 0;
        HashMap<Integer, Rank> current_ranks = ranks.getRanking();
        for (Integer key : expressionUsing.keySet()) {
            if (current_ranks.containsKey(key)) {
                ranks_subset[n] = current_ranks.get(key).getRank();
                if (ranks_subset[n] > maxRank) {
                    maxRank = (Integer)ranks_subset[n];
                }
            } else {
                ranks_subset[n] = -1;
                ++missingRanksCount;
            }
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        if (this.params.isTwoDistinctExpressionSets() && missingRanksCount > 0) {
            int fakeRank = 0;
            fakeRank = isNegative ? 1 : maxRank + 100;
            for (int s = 0; s < ranks_subset.length; ++s) {
                if ((Integer)ranks_subset[s] == -1) {
                    ranks_subset[s] = fakeRank;
                }
                rank2keys.put(fakeRank, (ArrayList<Object>)rank2keys.get(-1));
            }
        }
        if ((ascending = this.hmParams.isAscending(this.hmParams.getSortIndex())) && isNegative && this.displayLeadingEdge && this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = false;
        } else if (!ascending && !isNegative && this.displayLeadingEdge && this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = true;
        }
        if (ascending) {
            Arrays.sort(ranks_subset);
        } else {
            Arrays.sort(ranks_subset, Collections.reverseOrder());
        }
        int k = 0;
        int previous = -1;
        boolean significant_gene = false;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            significant_gene = false;
            if ((Integer)ranks_subset[m] <= topRank && !isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            } else if ((Integer)ranks_subset[m] >= topRank && isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            }
            if (this.OnlyLeadingEdge && !significant_gene && topRank > 0) continue;
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer currentKey : keys) {
                int j;
                GeneExpression halfRow1 = this.currentExpressionSet.get(currentKey);
                GeneExpression halfRow2 = this.currentExpressionSet2.get(currentKey);
                Double[] expression_values1 = this.getExpression(halfRow1, 1);
                Double[] expression_values2 = this.getExpression(halfRow2, 2);
                if (halfRow1 != null) {
                    try {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(halfRow1.getName())) : Integer.valueOf(Integer.parseInt(halfRow1.getName()));
                    }
                    catch (NumberFormatException v) {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(halfRow1.getName()) : halfRow1.getName();
                    }
                    this.expValue[k][1] = halfRow1.getDescription();
                } else if (halfRow2 != null) {
                    try {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(halfRow2.getName())) : Integer.valueOf(Integer.parseInt(halfRow2.getName()));
                    }
                    catch (NumberFormatException v) {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(halfRow2.getName()) : halfRow2.getName();
                    }
                    this.expValue[k][1] = halfRow2.getDescription();
                }
                this.halfRow1Length[k] = expression_values1.length;
                this.themeHalfRow1[k] = this.hmParams.getTheme_ds1();
                this.rangeHalfRow1[k] = this.hmParams.getRange_ds1();
                this.hRow1[k] = halfRow1 != null ? halfRow1.getName() : halfRow2.getName();
                for (j = 0; j < expression_values1.length; ++j) {
                    this.expValue[k][j + 2] = expression_values1[j];
                }
                this.halfRow2Length[k] = expression_values1.length + expression_values2.length;
                this.themeHalfRow2[k] = this.hmParams.getTheme_ds2();
                this.rangeHalfRow2[k] = this.hmParams.getRange_ds2();
                this.hRow2[k] = halfRow1 != null ? halfRow1.getName() : halfRow2.getName();
                for (j = expression_values1.length; j < expression_values1.length + expression_values2.length; ++j) {
                    this.expValue[k][j + 2] = expression_values2[j - expression_values1.length];
                }
                ++k;
            }
        }
        this.setThemeHalfRow1(this.themeHalfRow1);
        this.setRangeHalfRow1(this.rangeHalfRow1);
        this.setHalfRow1Length(this.halfRow1Length);
        this.sethRow1(this.hRow1);
        this.setThemeHalfRow2(this.themeHalfRow2);
        this.setRangeHalfRow2(this.rangeHalfRow2);
        this.setHalfRow2Length(this.halfRow2Length);
        this.sethRow2(this.hRow2);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private Double[] getExpression(GeneExpression row, int dataset) {
        Double[] expression_values1;
        block10: {
            block9: {
                expression_values1 = null;
                if (this.hmParams.getTransformation() == HeatMapParameters.Transformation.ROWNORM) {
                    if (row != null) {
                        expression_values1 = row.rowNormalize();
                    }
                } else if (this.hmParams.getTransformation() == HeatMapParameters.Transformation.LOGTRANSFORM) {
                    if (row != null) {
                        expression_values1 = row.rowLogTransform();
                    }
                } else if (row != null) {
                    expression_values1 = row.getExpression();
                }
                if (expression_values1 != null || dataset != 1) break block9;
                expression_values1 = new Double[this.columnNames.length - 2];
                for (int q = 0; q < expression_values1.length; ++q) {
                    expression_values1[q] = Double.NaN;
                }
                break block10;
            }
            if (expression_values1 != null || dataset != 2) break block10;
            expression_values1 = new Double[this.columnNames2.length - 2];
            for (int q = 0; q < expression_values1.length; ++q) {
                expression_values1[q] = Double.NaN;
            }
        }
        return expression_values1;
    }

    private JPanel showValuesPanel() {
        JPanel showValuesPanel = new JPanel();
        showValuesPanel.setMaximumSize(new Dimension(50, 100));
        showValuesPanel.setMinimumSize(new Dimension(50, 100));
        this.showValues = new JCheckBox("Show values");
        if (this.hmParams.isShowValues()) {
            this.showValues.setSelected(true);
        }
        this.showValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HeatMapPanel.this.showValuesStateChanged(evt);
            }
        });
        showValuesPanel.setLayout(new BorderLayout());
        showValuesPanel.add((Component)this.showValues, "South");
        return showValuesPanel;
    }

    private JPanel expressionLegendPanel() {
        JPanel expLegendPanel = new JPanel(new BorderLayout());
        expLegendPanel.setPreferredSize(new Dimension(200, 75));
        TitledBorder expBorder = BorderFactory.createTitledBorder("Expression legend");
        expBorder.setTitleJustification(1);
        expLegendPanel.setBorder(expBorder);
        if (this.currentExpressionSet2 != null && !this.currentExpressionSet2.isEmpty()) {
            ColorGradientWidget new_legend_ds1 = ColorGradientWidget.getInstance("", 100, 30, 5, 5, this.hmParams.getTheme_ds1(), this.hmParams.getRange_ds1(), true, ColorGradientWidget.LEGEND_POSITION.LEFT);
            ColorGradientWidget new_legend_ds2 = ColorGradientWidget.getInstance("", 100, 30, 5, 5, this.hmParams.getTheme_ds2(), this.hmParams.getRange_ds2(), true, ColorGradientWidget.LEGEND_POSITION.LEFT);
            expLegendPanel.add((Component)new_legend_ds1, "North");
            expLegendPanel.add((Component)new_legend_ds2, "South");
        } else {
            ColorGradientWidget new_legend = ColorGradientWidget.getInstance("", 200, 30, 5, 5, this.hmParams.getTheme_ds1(), this.hmParams.getRange_ds1(), true, ColorGradientWidget.LEGEND_POSITION.LEFT);
            expLegendPanel.add((Component)new_legend, "Center");
        }
        expLegendPanel.revalidate();
        return expLegendPanel;
    }

    private JPanel createNorthPanel() {
        this.northPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        JButton SaveExpressionSet = new JButton("Save Expression Set");
        SaveExpressionSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatMapPanel.this.saveExpressionSetActionPerformed(evt);
            }
        });
        JButton exportExpressionSet = new JButton("Export Expression Set (PDF)");
        exportExpressionSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatMapPanel.this.exportExpressionSetActionPerformed(evt);
            }
        });
        buttonPanel.add((Component)SaveExpressionSet, "North");
        buttonPanel.add((Component)exportExpressionSet, "South");
        this.addComponent(this.northPanel, this.expressionLegendPanel(), 0, 0, 2, 1, 10, 0);
        JPanel datatransformPanel = this.createDataTransformationOptionsPanel();
        datatransformPanel.add((Component)this.showValuesPanel(), "South");
        this.addComponent(this.northPanel, datatransformPanel, 2, 0, 1, 1, 10, 0);
        this.addComponent(this.northPanel, this.createSortOptionsPanel(), 3, 0, 2, 1, 10, 0);
        this.addComponent(this.northPanel, buttonPanel, 5, 0, 1, 1, 10, 0);
        this.northPanel.revalidate();
        return this.northPanel;
    }

    public JPanel createDataTransformationOptionsPanel() {
        TitledBorder HMBorder = BorderFactory.createTitledBorder("Normalization");
        HMBorder.setTitleJustification(1);
        JPanel heatmapOptions = new JPanel();
        heatmapOptions.setLayout(new BorderLayout());
        JComboBox<String> hmOptionComboBox = new JComboBox<String>();
        hmOptionComboBox.addItem(HeatMapParameters.asis);
        hmOptionComboBox.addItem(HeatMapParameters.rownorm);
        hmOptionComboBox.addItem(HeatMapParameters.logtrans);
        switch (this.hmParams.getTransformation()) {
            case ASIS: {
                hmOptionComboBox.setSelectedItem(HeatMapParameters.asis);
                break;
            }
            case ROWNORM: {
                hmOptionComboBox.setSelectedItem(HeatMapParameters.rownorm);
                break;
            }
            case LOGTRANSFORM: {
                hmOptionComboBox.setSelectedItem(HeatMapParameters.logtrans);
            }
        }
        hmOptionComboBox.addActionListener(new HeatMapActionListener(this.hmParams.getEdgeOverlapPanel(), this.hmParams.getNodeOverlapPanel(), hmOptionComboBox, this.hmParams, this.map, this.fileUtil, this.streamUtil, this.application));
        heatmapOptions.add(hmOptionComboBox, "North");
        heatmapOptions.setBorder(HMBorder);
        return heatmapOptions;
    }

    public JPanel createSortOptionsPanel() {
        TitledBorder RankBorder = BorderFactory.createTitledBorder("Sorting");
        HashSet<String> ranks = this.map.getAllRankNames();
        RankBorder.setTitleJustification(1);
        JPanel RankOptions = new JPanel();
        this.rankOptionComboBox = new JComboBox();
        JPanel ComboButton = new JPanel();
        this.rankOptionComboBox.addItem(HeatMapParameters.sort_hierarchical_cluster);
        if (ranks != null) {
            Iterator<String> j = ranks.iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                this.rankOptionComboBox.addItem(ranks_name);
            }
        }
        this.rankOptionComboBox.addItem(HeatMapParameters.sort_none);
        switch (this.hmParams.getSort()) {
            case DEFAULT: {
                this.rankOptionComboBox.setSelectedItem(this.map.getParams().getDefaultSortMethod());
                if (this.map.getParams().getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_rank)) {
                    this.hmParams.setSort(HeatMapParameters.Sort.RANK);
                    if (ranks != null) {
                        this.hmParams.setRankFileIndex(ranks.iterator().next());
                        this.hmParams.setSortIndex(this.hmParams.getAscending().length - ranks.size());
                        break;
                    }
                    this.rankOptionComboBox.setSelectedItem(HeatMapParameters.sort_none);
                    this.hmParams.setSort(HeatMapParameters.Sort.NONE);
                    break;
                }
                if (this.map.getParams().getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_none)) {
                    this.hmParams.setSort(HeatMapParameters.Sort.NONE);
                    break;
                }
                if (!this.map.getParams().getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) break;
                this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
                break;
            }
            case CLUSTER: {
                this.rankOptionComboBox.setSelectedItem(HeatMapParameters.sort_hierarchical_cluster);
                break;
            }
            case NONE: {
                this.rankOptionComboBox.setSelectedItem(HeatMapParameters.sort_none);
                break;
            }
            case RANK: {
                int k = 0;
                int columns = 0;
                columns = this.map.getParams().isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename()) ? this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length + this.map.getDataset("Dataset 2").getExpressionSets().getColumnNames().length - 2 : this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length;
                Iterator<String> j = ranks.iterator();
                while (j.hasNext()) {
                    String ranks_name = j.next().toString();
                    if (ranks_name.equalsIgnoreCase(this.hmParams.getRankFileIndex())) {
                        this.rankOptionComboBox.setSelectedItem(ranks_name);
                        this.hmParams.setSortIndex(columns + k);
                    }
                    ++k;
                }
                break;
            }
            case COLUMN: {
                this.rankOptionComboBox.addItem(HeatMapParameters.sort_column + ":" + this.hmParams.getSortbycolumnName());
                this.rankOptionComboBox.setSelectedItem(HeatMapParameters.sort_column + ":" + this.hmParams.getSortbycolumnName());
            }
        }
        this.rankOptionComboBox.addItem("Add Rankings ... ");
        ComboButton.add(this.rankOptionComboBox);
        if (this.hmParams.getSort() == HeatMapParameters.Sort.RANK || this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN) {
            JButton arrow = this.hmParams.isAscending(this.hmParams.getSortIndex()) ? this.createArrowButton(0) : this.createArrowButton(1);
            ComboButton.add(arrow);
            arrow.addActionListener(new ChangeSortAction(arrow));
        }
        this.rankOptionComboBox.addActionListener(new HeatMapActionListener(this.hmParams.getEdgeOverlapPanel(), this.hmParams.getNodeOverlapPanel(), this.rankOptionComboBox, this.hmParams, this.map, this.fileUtil, this.streamUtil, this.application));
        ComboButton.revalidate();
        RankOptions.add(ComboButton);
        RankOptions.setBorder(RankBorder);
        RankOptions.revalidate();
        return RankOptions;
    }

    private JButton createArrowButton(int direction) {
        JButton button = new JButton(this.iconArrow[direction]);
        button.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(2);
        button.setMargin(new Insets(0, 0, 3, 0));
        Font font = BorderFactory.createTitledBorder("Sample").getTitleFont();
        Color color = BorderFactory.createTitledBorder("Sample").getTitleColor();
        button.setFont(font);
        button.setForeground(color);
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        return button;
    }

    private ImageIcon[] createExpandAndCollapseIcon() {
        ImageIcon[] iconArrow = new ImageIcon[2];
        URL iconURL = this.getClass().getResource("arrow_up.gif");
        if (iconURL != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_down.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, this.insets, 0, 0);
        container.add(component, gbc);
    }

    private void saveExpressionSetActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_txt);
        File file = this.fileUtil.getFile((Component)this.application.getJFrame(), "Export Heatmap as txt File", 1, all_filters);
        if (file != null && file.toString() != null) {
            String fileName = file.toString();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
                file = new File(fileName);
            }
            int response = 0;
            if (file.exists()) {
                response = JOptionPane.showConfirmDialog(this, "The file already exists.  Would you like to overwrite it?");
            }
            if (response != 1 && response != 2 && (response == 0 || response == 0)) {
                try {
                    String[] currentColumns;
                    int response2;
                    if (this.displayLeadingEdge && this.hmParams.getSort() == HeatMapParameters.Sort.RANK && this.params.getMethod().equalsIgnoreCase("GSEA") && ((response2 = JOptionPane.showConfirmDialog(this, "Would you like to save the leading edge only?")) == 0 || response2 == 0)) {
                        this.OnlyLeadingEdge = true;
                    }
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                        currentColumns = new String[this.columnNames.length + this.columnNames2.length - 2];
                        System.arraycopy(this.columnNames, 0, currentColumns, 0, this.columnNames.length);
                        System.arraycopy(this.columnNames2, 2, currentColumns, this.columnNames.length, this.columnNames2.length - 2);
                    } else {
                        currentColumns = (String[])this.columnNames;
                    }
                    for (int j = 0; j < currentColumns.length; ++j) {
                        if (j == currentColumns.length - 1) {
                            output.write(currentColumns[j] + "\n");
                            continue;
                        }
                        output.write(currentColumns[j] + "\t");
                    }
                    Object[][] sortedExpression = this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename()) ? this.createSortedMergedTableData() : this.createSortedTableData();
                    for (int k = 0; k < sortedExpression.length; ++k) {
                        for (int l = 0; l < sortedExpression[k].length; ++l) {
                            if (sortedExpression[k][l] != null) {
                                output.write(sortedExpression[k][l].toString() + "\t");
                                continue;
                            }
                            output.write("\t");
                        }
                        output.write("\n");
                    }
                    output.flush();
                    output.close();
                    JOptionPane.showMessageDialog(this, "File " + fileName + " saved.");
                    this.OnlyLeadingEdge = false;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "unable to write to file " + fileName);
                }
            }
        }
    }

    private void exportExpressionSetActionPerformed(ActionEvent evt) {
        List<FileChooserFilter> filter = Collections.singletonList(new FileChooserFilter("pdf Files", "pdf"));
        File file = this.fileUtil.getFile((Component)this.application.getJFrame(), "Export Heatmap as PDF File", 1, filter);
        if (file != null && file.toString() != null) {
            String fileName = file.toString();
            if (!fileName.endsWith(".pdf")) {
                fileName = fileName + ".pdf";
                file = new File(fileName);
            }
            HeatMapExporterTask task = new HeatMapExporterTask(this.getjTable1(), this.getTableHeader(), file);
            this.dialogTaskMonitor.execute(new TaskIterator(new Task[]{task}));
        }
    }

    private void initializeLeadingEdge(EnrichmentMapParameters params) {
        Object[] nodes = params.getSelectedNodes().toArray();
        if (nodes.length == 1) {
            CyNetwork network = this.applicationManager.getCurrentNetwork();
            for (Object node1 : nodes) {
                HashMap<String, EnrichmentResult> results2;
                CyNode current_node = (CyNode)node1;
                String nodename = (String)network.getRow((CyIdentifiable)current_node).get("name", String.class);
                this.displayLeadingEdge = true;
                if (!params.getMethod().equalsIgnoreCase("GSEA")) continue;
                HashMap<String, EnrichmentResult> results1 = this.map.getDataset("Dataset 1").getEnrichments().getEnrichments();
                if (results1.containsKey(nodename)) {
                    GSEAResult current_result = (GSEAResult)results1.get(nodename);
                    this.leadingEdgeScoreAtMax1 = current_result.getScoreAtMax();
                    if (this.leadingEdgeScoreAtMax1 == DetermineEnrichmentResultFileReader.DefaultScoreAtMax) {
                        this.leadingEdgeScoreAtMax1 = current_result.getNES();
                    }
                    this.leadingEdgeRankAtMax1 = current_result.getRankAtMax();
                }
                if (!this.map.getParams().isTwoDatasets() || !(results2 = this.map.getDataset("Dataset 2").getEnrichments().getEnrichments()).containsKey(nodename)) continue;
                GSEAResult current_result = (GSEAResult)results2.get(nodename);
                this.leadingEdgeScoreAtMax2 = current_result.getScoreAtMax();
                if (this.leadingEdgeScoreAtMax2 == DetermineEnrichmentResultFileReader.DefaultScoreAtMax) {
                    this.leadingEdgeScoreAtMax2 = current_result.getNES();
                }
                this.leadingEdgeRankAtMax2 = current_result.getRankAtMax();
            }
        }
    }

    private Ranking getEmptyRanks(HashMap<Integer, GeneExpression> expressionSet) {
        Ranking ranks = new Ranking();
        for (Integer key : expressionSet.keySet()) {
            Rank temp = new Rank(expressionSet.get(key).getName(), 0.0, 0);
            ranks.addRank(key, temp);
        }
        return ranks;
    }

    private Ranking getRanks(HashMap<Integer, GeneExpression> expressionSet) {
        Ranking ranks = null;
        if (this.hmParams.getSort() == HeatMapParameters.Sort.DEFAULT) {
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) {
                this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_rank)) {
                this.hmParams.setSort(HeatMapParameters.Sort.RANK);
                HashSet<String> ranksnames = this.map.getAllRankNames();
                if (!ranksnames.isEmpty()) {
                    this.hmParams.setRankFileIndex(ranksnames.iterator().next());
                } else {
                    this.hmParams.setSort(HeatMapParameters.Sort.NONE);
                }
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_none)) {
                this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_column)) {
                this.hmParams.setSort(HeatMapParameters.Sort.COLUMN);
                this.hmParams.setSortIndex(0);
            }
        }
        HashSet<String> all_ranks = this.map.getAllRankNames();
        if (this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            Iterator<String> j = all_ranks.iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (!ranks_name.equalsIgnoreCase(this.hmParams.getRankFileIndex())) continue;
                ranks = this.map.getRanksByName(ranks_name);
            }
            if (ranks == null) {
                throw new IllegalThreadStateException("invalid sort index for rank files.");
            }
        } else if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN || this.hmParams.getSort() == HeatMapParameters.Sort.NONE) {
            ranks = new Ranking();
            for (Integer key : expressionSet.keySet()) {
                Rank temp = new Rank(expressionSet.get(key).getName(), 0.0, 0);
                ranks.addRank(key, temp);
            }
            if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN) {
                this.hmParams.setSortbycolumn_event_triggered(true);
            }
        } else if (this.hmParams.getSort() == HeatMapParameters.Sort.CLUSTER) {
            HeatMapHierarchicalClusterTaskFactory clustertask = new HeatMapHierarchicalClusterTaskFactory(this.numConditions, this.numConditions2, this, this.map);
            ResultTaskObserver observer = new ResultTaskObserver();
            this.dialogTaskMonitor.execute(clustertask.createTaskIterator(), (TaskObserver)observer);
            while (!observer.isAllFinished()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ranks = this.ranks;
        }
        if (this.hmParams.getSort() == HeatMapParameters.Sort.NONE) {
            ranks = this.getEmptyRanks(expressionSet);
        }
        return ranks;
    }

    private void initialize_linkouts() {
    }

    private int getTopRank() {
        int topRank = 0;
        if (this.displayLeadingEdge && (this.map.getDataset("Dataset 1").getExpressionSets().haveRanks() || this.map.getDataset("Dataset 2").getExpressionSets().haveRanks()) && (this.hmParams.getSort() == HeatMapParameters.Sort.RANK || this.params.getDefaultSortMethod().equalsIgnoreCase(this.hmParams.getSort().toString()))) {
            if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 1")) {
                topRank = this.leadingEdgeRankAtMax1 + 3;
                if (this.leadingEdgeScoreAtMax1 < 0.0) {
                    if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking")) {
                        topRank = this.map.getDataset("Dataset 1").getExpressionSets().getRanksByName("Dataset 1 Ranking").getMaxRank() - topRank;
                    } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 1")) {
                        topRank = this.map.getDataset("Dataset 1").getExpressionSets().getRanksByName("GSEARanking").getMaxRank() - topRank;
                    }
                }
            } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking") || this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 2")) {
                topRank = this.leadingEdgeRankAtMax2 + 3;
                if (this.leadingEdgeScoreAtMax2 < 0.0) {
                    if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking")) {
                        topRank = this.map.getDataset("Dataset 2").getExpressionSets().getRanksByName("Dataset 2 Ranking").getMaxRank() - topRank;
                    } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("GSEARanking-Dataset 2")) {
                        topRank = this.map.getDataset("Dataset 2").getExpressionSets().getRanksByName("GSEARanking").getMaxRank() - topRank;
                    }
                }
            }
        }
        return topRank;
    }

    private boolean isNegativeGS(int dataset) {
        boolean isNegative = false;
        if (dataset == 1) {
            isNegative = this.leadingEdgeScoreAtMax1 < 0.0;
        } else if (dataset == 2) {
            isNegative = this.leadingEdgeScoreAtMax2 < 0.0;
        }
        return isNegative;
    }

    private void showValuesStateChanged(ItemEvent e) {
        JCheckBox source = (JCheckBox)e.getSource();
        if (e.getStateChange() == 2) {
            this.showValues.setSelected(false);
            this.hmParams.setShowValues(false);
        }
        if (e.getStateChange() == 1) {
            this.hmParams.setShowValues(true);
            this.showValues.setSelected(true);
        }
        this.updatePanel();
        this.revalidate();
    }

    Object[][] getExpValue() {
        return this.expValue;
    }

    public void setColumnSort() {
        this.rankOptionComboBox.addItem(HeatMapParameters.sort_column + ":" + this.hmParams.getSortbycolumnName());
        this.rankOptionComboBox.setSelectedItem(HeatMapParameters.sort_column + ":" + this.hmParams.getSortbycolumnName());
    }

    private String[] gethRow1() {
        return this.hRow1;
    }

    private void sethRow1(String[] hRow1) {
        this.hRow1 = hRow1;
    }

    private String[] gethRow2() {
        return this.hRow2;
    }

    private void sethRow2(String[] hRow2) {
        this.hRow2 = hRow2;
    }

    private void setExpValue(Object[][] expValue) {
        this.expValue = expValue;
    }

    public void clearPanel() {
        this.removeAll();
        this.revalidate();
    }

    public void setHalfRow1Length(int[] halfRow1Length) {
        this.halfRow1Length = halfRow1Length;
    }

    public int[] getHalfRow1Length() {
        return this.halfRow1Length;
    }

    public void setHalfRow2Length(int[] hRow2Length) {
        this.halfRow2Length = hRow2Length;
    }

    public int[] getHalfRow2Length() {
        return this.halfRow2Length;
    }

    public void setThemeHalfRow1(ColorGradientTheme[] themeHalfRow1) {
        this.themeHalfRow1 = themeHalfRow1;
    }

    public ColorGradientTheme[] getThemeHalfRow1() {
        return this.themeHalfRow1;
    }

    public void setThemeHalfRow2(ColorGradientTheme[] themeHalfRow2) {
        this.themeHalfRow2 = themeHalfRow2;
    }

    public ColorGradientTheme[] getThemeHalfRow2() {
        return this.themeHalfRow2;
    }

    public void setRangeHalfRow1(ColorGradientRange[] rangeHalfRow1) {
        this.rangeHalfRow1 = rangeHalfRow1;
    }

    public ColorGradientRange[] getRangeHalfRow1() {
        return this.rangeHalfRow1;
    }

    public void setRangeHalfRow2(ColorGradientRange[] rangeHalfRow2) {
        this.rangeHalfRow2 = rangeHalfRow2;
    }

    public ColorGradientRange[] getRangeHalfRow2() {
        return this.rangeHalfRow2;
    }

    public void setRowGeneName(String[] rowGeneName) {
        this.rowGeneName = rowGeneName;
    }

    public String[] getRowGeneName() {
        return this.rowGeneName;
    }

    public void setRowLength(int[] rowLength) {
        this.rowLength = rowLength;
    }

    public int[] getRowLength() {
        return this.rowLength;
    }

    private ColorGradientRange[] getRowRange() {
        return this.rowRange;
    }

    private void setRowRange(ColorGradientRange[] rowRange) {
        this.rowRange = rowRange;
    }

    public void setRowTheme(ColorGradientTheme[] rowTheme) {
        this.rowTheme = rowTheme;
    }

    public ColorGradientTheme[] getRowTheme() {
        return this.rowTheme;
    }

    public JTableHeader getTableHeader() {
        return this.tableHdr;
    }

    public JTable getjTable1() {
        return this.jTable1;
    }

    public JPanel getNorthPanel() {
        return this.northPanel;
    }

    public Component getComponent() {
        return this;
    }

    public HashMap<Integer, GeneExpression> getCurrentExpressionSet() {
        return this.currentExpressionSet;
    }

    public void setCurrentExpressionSet(HashMap<Integer, GeneExpression> currentExpressionSet) {
        this.currentExpressionSet = currentExpressionSet;
    }

    public HashMap<Integer, GeneExpression> getCurrentExpressionSet2() {
        return this.currentExpressionSet2;
    }

    public void setCurrentExpressionSet2(HashMap<Integer, GeneExpression> currentExpressionSet2) {
        this.currentExpressionSet2 = currentExpressionSet2;
    }

    public Ranking getRanks() {
        return this.ranks;
    }

    public void setRanks(Ranking ranks) {
        this.ranks = ranks;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        if (this.node) {
            return "Heat Map (nodes)";
        }
        return "Heat Map (edges)";
    }

    private class ChangeSortAction
    extends AbstractAction
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -8951978251258210440L;
        private JButton arrow;

        private ChangeSortAction(JButton arrow) {
            this.arrow = arrow;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeatMapPanel.this.hmParams.flipAscending(HeatMapPanel.this.hmParams.getSortIndex());
            if (HeatMapPanel.this.hmParams.isAscending(HeatMapPanel.this.hmParams.getSortIndex())) {
                this.arrow.setIcon(HeatMapPanel.this.iconArrow[0]);
            } else {
                this.arrow.setIcon(HeatMapPanel.this.iconArrow[1]);
            }
            HeatMapPanel.this.hmParams.getEdgeOverlapPanel().clearPanel();
            HeatMapPanel.this.hmParams.getNodeOverlapPanel().clearPanel();
            HeatMapPanel.this.hmParams.getEdgeOverlapPanel().updatePanel();
            HeatMapPanel.this.hmParams.getNodeOverlapPanel().updatePanel();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            HeatMapPanel.this.hmParams.flipAscending(HeatMapPanel.this.hmParams.getSortIndex());
        }
    }
}

