/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.UpdateAnnotationTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.VisualizeClusterAnnotationTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.UpdateClusterLabelTask;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class ExtractClusterTask
extends AbstractTask {
    private AnnotationSet annotationSet;

    public ExtractClusterTask(AnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
    }

    public void extractAction() {
        AutoAnnotationManager.getInstance().setClusterTableUpdating(true);
        CyNetworkView selectedView = this.annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        JTable clusterTable = this.annotationSet.getClusterTable();
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)selectedNetwork, (String)"selected", (boolean)true);
        for (CyNode node : selectedNodes) {
            selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
        }
        if (selectedNodes.size() < 1) {
            JOptionPane.showMessageDialog(null, "Please select at least one node", "Error Message", 0);
        } else {
            CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
            DialogTaskManager dialogTaskManager = autoAnnotationManager.getDialogTaskManager();
            Class columnType = selectedNetwork.getDefaultNodeTable().getColumn(this.annotationSet.getClusterColumnName()).getType();
            String clusterColumnName = this.annotationSet.getClusterColumnName();
            String nameColumnName = this.annotationSet.getNameColumnName();
            int newClusterNumber = this.annotationSet.getNextClusterNumber();
            if (columnType == Integer.class) {
                HashSet<Cluster> clustersChanged = new HashSet<Cluster>();
                for (Cluster cluster : this.annotationSet.getClusterMap().values()) {
                    for (CyNode node : selectedNodes) {
                        if (!cluster.getNodes().contains(node)) continue;
                        cluster.removeNode(node);
                        cluster.setCoordinatesChanged(true);
                        clustersChanged.add(cluster);
                    }
                }
                for (CyRow row : selectedNetwork.getDefaultNodeTable().getAllRows()) {
                    row.set(clusterColumnName, (Object)newClusterNumber);
                }
                for (Cluster modifiedCluster : clustersChanged) {
                    for (CyNode node : modifiedCluster.getNodesToCoordinates().keySet()) {
                        selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
                    }
                    ArrayList<String> commands = new ArrayList<String>();
                    String deleteCommand = "wordcloud delete cloudName=\"" + modifiedCluster.getCloudName() + "\"";
                    String createCommand = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodeList=\"selected\" cloudName=\"" + modifiedCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + this.annotationSet.getName() + "\"";
                    commands.add(deleteCommand);
                    commands.add(createCommand);
                    Observer observer = new Observer();
                    TaskIterator taskIterator = executor.createTaskIterator(commands, null);
                    dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
                    while (!observer.isFinished()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    for (CyNode node : modifiedCluster.getNodesToCoordinates().keySet()) {
                        selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
                    }
                    autoAnnotationManager.flushPayloadEvents();
                }
            }
            Cluster newCluster = new Cluster(newClusterNumber, this.annotationSet);
            this.annotationSet.addCluster(newCluster);
            for (CyNode node : selectedNodes) {
                View nodeView = selectedView.getNodeView(node);
                double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                double[] coordinates = new double[]{x, y};
                double nodeRadius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
                newCluster.addNodeCoordinates(node, coordinates);
                newCluster.addNodeRadius(node, nodeRadius);
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            for (CyNode node : newCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            ArrayList<String> commands = new ArrayList<String>();
            String command = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodeList=\"selected\" cloudName=\"" + newCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + this.annotationSet.getName() + "\"";
            commands.add(command);
            Observer observer = new Observer();
            TaskIterator taskIterator = executor.createTaskIterator(commands, null);
            dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            for (CyNode node : selectedNodes) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            CyTableManager tableManager = autoAnnotationManager.getTableManager();
            String annotationSetName = this.annotationSet.getName();
            Long clusterTableSUID = (Long)selectedNetwork.getDefaultNetworkTable().getRow((Object)selectedNetwork.getSUID()).get(annotationSetName, Long.class);
            CyTable clusterSetTable = tableManager.getTable(clusterTableSUID.longValue());
            TaskIterator currentTasks = new TaskIterator(new Task[0]);
            currentTasks.append((Task)new UpdateClusterLabelTask(newCluster, clusterSetTable));
            currentTasks.append(new VisualizeClusterAnnotationTaskFactory(newCluster).createTaskIterator());
            currentTasks.append((Task)new UpdateAnnotationTask(this.annotationSet));
            if (currentTasks.hasNext()) {
                dialogTaskManager.execute(currentTasks);
            }
            AutoAnnotationManager.getInstance().setClusterTableUpdating(false);
            clusterTable.clearSelection();
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }

    public void run(TaskMonitor arg0) throws Exception {
        this.extractAction();
    }
}

