/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DeleteClusterTask;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class RemoveAnnotationTask
extends AbstractTask {
    private AutoAnnotationParameters params;

    public RemoveAnnotationTask(AutoAnnotationParameters params) {
        this.params = params;
    }

    public void removeAction() {
        HeatMapParameters heatMapParameters;
        AnnotationSet annotationSet = this.params.getSelectedAnnotationSet();
        CyNetwork selectedNetwork = (CyNetwork)annotationSet.getView().getModel();
        EnrichmentMapManager emManager = EnrichmentMapManager.getInstance();
        JTable clusterTable = annotationSet.getClusterTable();
        clusterTable.getParent().getParent().getParent().remove(clusterTable.getParent().getParent());
        if (emManager != null && emManager.getMap(selectedNetwork.getSUID()) != null && (heatMapParameters = emManager.getMap(selectedNetwork.getSUID()).getParams().getHmParams()) != null) {
            heatMapParameters.setSort(HeatMapParameters.Sort.NONE);
        }
        Iterator<Cluster> clusterIterator = annotationSet.getClusterMap().values().iterator();
        ArrayList<Cluster> clusterSetCopy = new ArrayList<Cluster>();
        while (clusterIterator.hasNext()) {
            clusterSetCopy.add(clusterIterator.next());
        }
        TaskIterator clusterDeletionTasks = new TaskIterator(new Task[0]);
        for (Cluster cluster : clusterSetCopy) {
            clusterDeletionTasks.append((Task)new DeleteClusterTask(this.params, cluster));
        }
        AutoAnnotationManager.getInstance().getDialogTaskManager().execute(clusterDeletionTasks);
        this.params.removeAnnotationSet(annotationSet);
    }

    public void run(TaskMonitor arg0) throws Exception {
        this.removeAction();
    }
}

