/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.LoadSignatureGMTFilesTask;
import org.baderlab.csplugins.enrichmentmap.task.ResultTaskObserver;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskObserver;

public class LoadSignatureSetsActionListener
implements ActionListener {
    private PostAnalysisInputPanel inputPanel;
    private CySwingApplication application;
    private CyApplicationManager applicationManager;
    private TaskManager<?, ?> taskManager;
    private StreamUtil streamUtil;
    private boolean selectAll = false;

    public LoadSignatureSetsActionListener(PostAnalysisInputPanel inputPanel, CySwingApplication application, CyApplicationManager applicationManager, TaskManager<?, ?> taskManager, StreamUtil streamUtil) {
        this.inputPanel = inputPanel;
        this.application = application;
        this.applicationManager = applicationManager;
        this.taskManager = taskManager;
        this.streamUtil = streamUtil;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        EnrichmentMap current_map = EnrichmentMapManager.getInstance().getMap(this.applicationManager.getCurrentNetwork().getSUID());
        final PostAnalysisParameters paParams = this.inputPanel.getPaParams();
        String errors = paParams.checkGMTfiles();
        if (errors.isEmpty()) {
            paParams.getSignatureSetNames().clear();
            paParams.getSelectedSignatureSetNames().clear();
            paParams.getSignatureGenesets().clear();
            LoadSignatureGMTFilesTask load_GMTs = new LoadSignatureGMTFilesTask(current_map, paParams, this.streamUtil, this.inputPanel);
            if (this.selectAll) {
                ResultTaskObserver taskObserver = new ResultTaskObserver(){

                    @Override
                    public void allFinished(FinishStatus finishStatus) {
                        DefaultListModel<String> signatureSets = paParams.getSignatureSetNames();
                        DefaultListModel<String> selectedSignatureSets = paParams.getSelectedSignatureSetNames();
                        selectedSignatureSets.clear();
                        for (String name : Collections.list(signatureSets.elements())) {
                            selectedSignatureSets.addElement(name);
                        }
                        signatureSets.clear();
                    }
                };
                this.taskManager.execute(load_GMTs.createTaskIterator(), (TaskObserver)taskObserver);
            } else {
                this.taskManager.execute(load_GMTs.createTaskIterator());
            }
        } else {
            JOptionPane.showMessageDialog(this.application.getJFrame(), errors, "Invalid Input", 2);
        }
    }
}

