/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.util.HashMap;
import java.util.Properties;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.EnrichmentMapInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisPanel;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;

public class EnrichmentMapManager
implements SetCurrentNetworkListener,
NetworkAboutToBeDestroyedListener,
SetCurrentNetworkViewListener {
    private static EnrichmentMapManager manager = null;
    private HashMap<Long, EnrichmentMap> cyNetworkList = new HashMap();
    private ParametersPanel parameterPanel;
    private HeatMapPanel nodesOverlapPanel;
    private HeatMapPanel edgesOverlapPanel;
    private EnrichmentMapInputPanel inputWindow;
    private PostAnalysisPanel analysisWindow;
    private CyServiceRegistrar registrar;
    private boolean overrideHeatmapRevalidation = false;

    public static EnrichmentMapManager getInstance() {
        if (manager == null) {
            manager = new EnrichmentMapManager();
        }
        return manager;
    }

    public void initialize(ParametersPanel parameterPanel, HeatMapPanel nodesOverlapPanel, HeatMapPanel edgesOverlapPanel, CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.parameterPanel = parameterPanel;
        this.nodesOverlapPanel = nodesOverlapPanel;
        this.edgesOverlapPanel = edgesOverlapPanel;
    }

    public void registerServices() {
        if (this.nodesOverlapPanel != null) {
            this.registrar.registerService((Object)this.nodesOverlapPanel, CytoPanelComponent.class, new Properties());
        }
        if (this.edgesOverlapPanel != null) {
            this.registrar.registerService((Object)this.edgesOverlapPanel, CytoPanelComponent.class, new Properties());
        }
        if (this.parameterPanel != null) {
            this.registrar.registerService((Object)this.parameterPanel, CytoPanelComponent.class, new Properties());
        }
    }

    private EnrichmentMapManager() {
    }

    public void registerNetwork(CyNetwork cyNetwork, EnrichmentMap map) {
        if (!this.cyNetworkList.containsKey(cyNetwork.getSUID())) {
            this.cyNetworkList.put(cyNetwork.getSUID(), map);
        }
    }

    public ParametersPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public HeatMapPanel getNodesOverlapPanel() {
        return this.nodesOverlapPanel;
    }

    public HeatMapPanel getEdgesOverlapPanel() {
        return this.edgesOverlapPanel;
    }

    public HashMap<Long, EnrichmentMap> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public EnrichmentMap getMap(Long id) {
        if (this.cyNetworkList.containsKey(id)) {
            return this.cyNetworkList.get(id);
        }
        return null;
    }

    public EnrichmentMapInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(EnrichmentMapInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public PostAnalysisPanel getAnalysisWindow() {
        return this.analysisWindow;
    }

    public void setAnalysisWindow(PostAnalysisPanel analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    public boolean isEnrichmentMap(Long networkID) {
        return this.cyNetworkList.containsKey(networkID);
    }

    public void handleEvent(SetCurrentNetworkEvent event) {
        long networkId = event.getNetwork().getSUID();
        if (networkId > 0L) {
            if (this.cyNetworkList.containsKey(networkId)) {
                this.nodesOverlapPanel.clearPanel();
                this.edgesOverlapPanel.clearPanel();
                EnrichmentMap currentNetwork = this.cyNetworkList.get(networkId);
                this.parameterPanel.updatePanel(currentNetwork);
                if (this.inputWindow != null) {
                    this.inputWindow.updateContents(currentNetwork.getParams());
                }
                if (this.analysisWindow != null) {
                    this.analysisWindow.showPanelFor(currentNetwork);
                }
                this.nodesOverlapPanel.updatePanel(currentNetwork);
                this.edgesOverlapPanel.updatePanel(currentNetwork);
                this.nodesOverlapPanel.revalidate();
                this.edgesOverlapPanel.revalidate();
            } else if (this.analysisWindow != null) {
                this.analysisWindow.showPanelFor(null);
            }
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.analysisWindow != null) {
            CyNetworkView view = e.getNetworkView();
            if (view == null) {
                this.analysisWindow.showPanelFor(null);
            } else {
                EnrichmentMap currentNetwork = this.cyNetworkList.get(((CyNetwork)view.getModel()).getSUID());
                this.analysisWindow.showPanelFor(currentNetwork);
            }
        }
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        Long networkId = event.getNetwork().getSUID();
        EnrichmentMap removed = this.cyNetworkList.remove(networkId);
        if (this.analysisWindow != null && removed != null) {
            this.analysisWindow.removeEnrichmentMap(removed);
        }
    }

    public boolean isOverrideHeatmapRevalidation() {
        return this.overrideHeatmapRevalidation;
    }

    public void setOverrideHeatmapRevalidation(boolean overrideHeatmapRevalidation) {
        this.overrideHeatmapRevalidation = overrideHeatmapRevalidation;
    }
}

