/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.text.InternationalFormatter;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapBuildProperties;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.actions.BulkEMCreationAction;
import org.baderlab.csplugins.enrichmentmap.actions.ShowAboutPanelAction;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.task.EnrichmentMapBuildMapTaskFactory;
import org.baderlab.csplugins.enrichmentmap.task.ResultTaskObserver;
import org.baderlab.csplugins.enrichmentmap.util.SwingUtil;
import org.baderlab.csplugins.enrichmentmap.view.BulkEMCreationPanel;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class EnrichmentMapInputPanel
extends JPanel
implements CytoPanelComponent {
    private StreamUtil streamUtil;
    private CyApplicationManager applicationManager;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager networkViewManager;
    private CyNetworkViewFactory networkViewFactory;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private VisualMappingManager visualMappingManager;
    private VisualStyleFactory visualStyleFactory;
    private VisualMappingFunctionFactory vmfFactoryContinuous;
    private VisualMappingFunctionFactory vmfFactoryDiscrete;
    private VisualMappingFunctionFactory vmfFactoryPassthrough;
    private CyLayoutAlgorithmManager layoutManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;
    private DialogTaskManager dialog;
    private CySessionManager sessionManager;
    private CySwingApplication application;
    private OpenBrowser browser;
    private FileUtil fileUtil;
    private CyServiceRegistrar registrar;
    private EnrichmentMapInputPanel empanel;
    private BulkEMCreationPanel bulkEmInput;
    private static final long serialVersionUID = -7837369382106745874L;
    CollapsiblePanel Parameters;
    CollapsiblePanel datasets;
    CollapsiblePanel dataset1;
    CollapsiblePanel dataset2;
    JPanel DatasetsPanel;
    DecimalFormat decFormat;
    private EnrichmentMapParameters params;
    private DataSetFiles dataset1files = new DataSetFiles();
    private DataSetFiles dataset2files = new DataSetFiles();
    private JFormattedTextField GMTFileNameTextField;
    private JFormattedTextField GCTFileName1TextField;
    private JFormattedTextField GCTFileName2TextField;
    private JFormattedTextField Dataset1FileNameTextField;
    private JFormattedTextField Dataset1FileName2TextField;
    private JFormattedTextField Dataset2FileNameTextField;
    private JFormattedTextField Dataset2FileName2TextField;
    private JFormattedTextField Dataset1RankFileTextField;
    private JFormattedTextField Dataset2RankFileTextField;
    private JFormattedTextField Dataset1ClassFileTextField;
    private JFormattedTextField Dataset2ClassFileTextField;
    private JFormattedTextField Dataset1Phenotype1TextField;
    private JFormattedTextField Dataset1Phenotype2TextField;
    private JFormattedTextField Dataset2Phenotype1TextField;
    private JFormattedTextField Dataset2Phenotype2TextField;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField combinedConstantTextField;
    private JRadioButton gsea;
    private JRadioButton generic;
    private JRadioButton david;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    private JCheckBox scinot;
    private int defaultColumns = 15;
    public static String gct_instruction = "Please select the expression file (.gct), (.rpt)...";
    public static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    public static String dataset_instruction = "Please select the GSEA Result file (.txt)...";
    public static String rank_instruction = "Please select the rank file (.txt), (.rnk)...";
    private static String gmtTip = "File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...";
    private static String gctTip = "File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...";
    private static String datasetTip = "File specifying enrichment results.\n";
    private static String rankTip = "File specifying ranked genes.\nFormat: gene <tab> score or statistic";
    private static String classTip = "File specifying the classes of each sample in expression file.\nformat: see GSEA website";
    private boolean similarityCutOffChanged = false;
    private boolean LoadedFromRpt_dataset1 = false;
    private boolean LoadedFromRpt_dataset2 = false;
    private boolean panelUpdate = false;

    public EnrichmentMapInputPanel(CyNetworkFactory networkFactory, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyTableFactory tableFactory, CyTableManager tableManager, CyNetworkViewFactory networkViewFactory, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough, DialogTaskManager dialog, CySessionManager sessionManager, CySwingApplication application, OpenBrowser browser, FileUtil fileUtil, StreamUtil streamUtil, CyServiceRegistrar registrar, CyLayoutAlgorithmManager layoutManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable, BulkEMCreationPanel bulkEmInput) {
        this.empanel = this;
        this.decFormat = new DecimalFormat();
        this.decFormat.setParseIntegerOnly(false);
        this.networkFactory = networkFactory;
        this.applicationManager = applicationManager;
        this.networkManager = networkManager;
        this.networkViewManager = networkViewManager;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.networkViewFactory = networkViewFactory;
        this.streamUtil = streamUtil;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.layoutManager = layoutManager;
        this.mapTableToNetworkTable = mapTableToNetworkTable;
        this.dialog = dialog;
        this.sessionManager = sessionManager;
        this.application = application;
        this.browser = browser;
        this.fileUtil = fileUtil;
        this.streamUtil = streamUtil;
        this.registrar = registrar;
        this.bulkEmInput = bulkEmInput;
        this.setLayout(new BorderLayout());
        this.params = new EnrichmentMapParameters(sessionManager, streamUtil, applicationManager);
        JPanel AnalysisTypePanel = this.createAnalysisTypePanel();
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JScrollPane scroll = new JScrollPane(OptionsPanel);
        JPanel bottomPanel = this.createBottomPanel();
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)scroll, "Center");
        this.add((Component)AnalysisTypePanel, "North");
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.browser.openURL(EnrichmentMapBuildProperties.USER_MANUAL_URL);
            }
        });
        JButton about = new JButton("About");
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("inMenuBar", "true");
        serviceProperties.put("preferredMenu", "Apps.EnrichmentMap");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction(serviceProperties, this.applicationManager, this.networkViewManager, this.application, this.browser)));
        JButton bulk = new JButton("Bulk EM");
        bulk.addActionListener((ActionListener)((Object)new BulkEMCreationAction(serviceProperties, this.applicationManager, this.networkViewManager, this.application, this.bulkEmInput, this.registrar)));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        c_buttons.gridy = 2;
        gridbag_buttons.setConstraints(bulk, c_buttons);
        buttonsPanel.add(bulk);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Analysis Type"));
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea = new JRadioButton("GSEA", true);
            this.generic = new JRadioButton("generic(ex: gProfiler)", false);
            this.david = new JRadioButton("DAVID/BiNGO/Great", false);
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic(ex: gProfiler)", true);
            this.david = new JRadioButton("DAVID/BiNGO/Great", false);
        } else if (this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic(ex: gProfiler)", false);
            this.david = new JRadioButton("DAVID/BiNGO/Great", true);
        }
        this.gsea.setActionCommand("GSEA");
        this.generic.setActionCommand("generic");
        this.david.setActionCommand("DAVID/BiNGO/Great");
        this.gsea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.generic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.david.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.gsea);
        analysisOptions.add(this.generic);
        analysisOptions.add(this.david);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.gsea, c);
        panel.add(this.gsea);
        c.gridy = 1;
        gridbag.setConstraints(this.generic, c);
        panel.add(this.generic);
        c.gridy = 2;
        gridbag.setConstraints(this.david, c);
        panel.add(this.david);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTcollapsiblePanel = this.createGMTPanel();
        GMTcollapsiblePanel.setCollapsed(false);
        this.DatasetsPanel = new JPanel();
        this.DatasetsPanel.setLayout(new BoxLayout(this.DatasetsPanel, 1));
        this.datasets = new CollapsiblePanel("Datasets");
        this.datasets.setLayout(new BorderLayout());
        this.dataset1 = this.createDataset1Panel();
        this.dataset1.setCollapsed(false);
        this.dataset2 = this.createDataset2Panel();
        this.datasets.setCollapsed(false);
        this.DatasetsPanel.add(this.dataset1);
        this.DatasetsPanel.add(this.dataset2);
        this.datasets.getContentPane().add((Component)this.DatasetsPanel, "North");
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        panel.add(GMTcollapsiblePanel);
        panel.add(this.datasets);
        panel.add(ParametersPanel2);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("GMT:"){
            private static final long serialVersionUID = -122741876830022713L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GMTLabel.setToolTipText(gmtTip);
        JButton selectGMTFileButton = new JButton();
        this.GMTFileNameTextField = new JFormattedTextField();
        this.GMTFileNameTextField.setColumns(this.defaultColumns);
        this.GMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel newGMTPanel = new JPanel();
        newGMTPanel.setLayout(new BorderLayout());
        newGMTPanel.add((Component)GMTLabel, "West");
        newGMTPanel.add((Component)this.GMTFileNameTextField, "Center");
        newGMTPanel.add((Component)selectGMTFileButton, "East");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            panel.add(newGMTPanel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createDataset1Panel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Dataset 1");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GCTLabel = new JLabel("Expression:"){
            private static final long serialVersionUID = -1021506153608619217L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GCTLabel.setToolTipText(gctTip);
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(this.defaultColumns);
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 10));
        this.GCTFileName1TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGCTFileButtonActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)GCTLabel, "West");
        GCTPanel.add((Component)this.GCTFileName1TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        JLabel Results1Label = new JLabel("Enrichments 1:"){
            private static final long serialVersionUID = 4890287742836119482L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results1Label.setToolTipText(datasetTip);
        if (!this.params.getMethod().equalsIgnoreCase("GSEA")) {
            Results1Label.setText("Enrichments:");
        }
        JButton selectResults1FileButton = new JButton();
        this.Dataset1FileNameTextField = new JFormattedTextField();
        this.Dataset1FileNameTextField.setColumns(this.defaultColumns);
        this.Dataset1FileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.Dataset1FileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectResults1FileButton.setText("...");
        selectResults1FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults1FileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset1FileButtonActionPerformed(evt);
            }
        });
        JPanel Results1Panel = new JPanel();
        Results1Panel.setLayout(new BorderLayout());
        Results1Panel.add((Component)Results1Label, "West");
        Results1Panel.add((Component)this.Dataset1FileNameTextField, "Center");
        Results1Panel.add((Component)selectResults1FileButton, "East");
        JLabel Results2Label = new JLabel("Enrichments 2:"){
            private static final long serialVersionUID = 8462720651589188103L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results2Label.setToolTipText(datasetTip);
        JButton selectResults2FileButton = new JButton();
        this.Dataset1FileName2TextField = new JFormattedTextField();
        this.Dataset1FileName2TextField.setColumns(this.defaultColumns);
        this.Dataset1FileName2TextField.setFont(new Font("Dialog", 1, 10));
        this.Dataset1FileName2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectResults2FileButton.setText("...");
        selectResults2FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults2FileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset1File2ButtonActionPerformed(evt);
            }
        });
        JPanel Results2Panel = new JPanel();
        Results2Panel.setLayout(new BorderLayout());
        Results2Panel.add((Component)Results2Label, "West");
        Results2Panel.add((Component)this.Dataset1FileName2TextField, "Center");
        Results2Panel.add((Component)selectResults2FileButton, "East");
        panel.add(GCTPanel);
        panel.add(Results1Panel);
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            panel.add(Results2Panel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            collapsiblePanel.getContentPane().add((Component)this.createAdvancedDatasetOptions(1), "South");
        }
        return collapsiblePanel;
    }

    private CollapsiblePanel createDataset2Panel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Dataset 2");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GCTLabel = new JLabel("Expression:"){
            private static final long serialVersionUID = 2369686770191667604L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GCTLabel.setToolTipText(gctTip);
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName2TextField = new JFormattedTextField();
        this.GCTFileName2TextField.setColumns(this.defaultColumns);
        this.GCTFileName2TextField.setFont(new Font("Dialog", 1, 10));
        this.GCTFileName2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGCTFileButton2ActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)GCTLabel, "West");
        GCTPanel.add((Component)this.GCTFileName2TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        JLabel Results1Label = new JLabel("Enrichments 1:"){
            private static final long serialVersionUID = -1405865291417154L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        if (!this.params.getMethod().equalsIgnoreCase("GSEA")) {
            Results1Label.setText("Enrichments:");
        }
        Results1Label.setToolTipText(datasetTip);
        JButton selectResults1FileButton = new JButton();
        this.Dataset2FileNameTextField = new JFormattedTextField();
        this.Dataset2FileNameTextField.setColumns(this.defaultColumns);
        this.Dataset2FileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.Dataset2FileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectResults1FileButton.setText("...");
        selectResults1FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults1FileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset2FileButtonActionPerformed(evt);
            }
        });
        JPanel Results1Panel = new JPanel();
        Results1Panel.setLayout(new BorderLayout());
        Results1Panel.add((Component)Results1Label, "West");
        Results1Panel.add((Component)this.Dataset2FileNameTextField, "Center");
        Results1Panel.add((Component)selectResults1FileButton, "East");
        JLabel Results2Label = new JLabel("Enrichments 2:"){
            private static final long serialVersionUID = -5178668573493553453L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results2Label.setToolTipText(datasetTip);
        JButton selectResults2FileButton = new JButton();
        this.Dataset2FileName2TextField = new JFormattedTextField();
        this.Dataset2FileName2TextField.setColumns(this.defaultColumns);
        this.Dataset2FileName2TextField.setFont(new Font("Dialog", 1, 10));
        this.Dataset2FileName2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectResults2FileButton.setText("...");
        selectResults2FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults2FileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset2File2ButtonActionPerformed(evt);
            }
        });
        JPanel Results2Panel = new JPanel();
        Results2Panel.setLayout(new BorderLayout());
        Results2Panel.add((Component)Results2Label, "West");
        Results2Panel.add((Component)this.Dataset2FileName2TextField, "Center");
        Results2Panel.add((Component)selectResults2FileButton, "East");
        panel.add(GCTPanel);
        panel.add(Results1Panel);
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            panel.add(Results2Panel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            collapsiblePanel.getContentPane().add((Component)this.createAdvancedDatasetOptions(2), "South");
        }
        return collapsiblePanel;
    }

    private CollapsiblePanel createAdvancedDatasetOptions(int dataset) {
        CollapsiblePanel Advanced = new CollapsiblePanel("Advanced");
        Advanced.setCollapsed(false);
        JPanel advancedpanel = new JPanel();
        advancedpanel.setLayout(new BorderLayout());
        JLabel RanksLabel = new JLabel("Ranks:"){
            private static final long serialVersionUID = 4549754054012943869L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        RanksLabel.setToolTipText(rankTip);
        JButton selectRanksFileButton = new JButton();
        JLabel ClassLabel = new JLabel("Classes"){
            private static final long serialVersionUID = 4549754054012943869L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        ClassLabel.setToolTipText(classTip);
        JButton selectClassFileButton = new JButton();
        if (dataset == 1) {
            this.Dataset1RankFileTextField = new JFormattedTextField();
            this.Dataset1RankFileTextField.setColumns(this.defaultColumns);
            this.Dataset1RankFileTextField.setFont(new Font("Dialog", 1, 10));
            this.Dataset1RankFileTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            selectRanksFileButton.setText("...");
            selectRanksFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectRanksFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectRank1FileButtonActionPerformed(evt);
                }
            });
            this.Dataset1ClassFileTextField = new JFormattedTextField();
            this.Dataset1ClassFileTextField.setColumns(this.defaultColumns);
            this.Dataset1ClassFileTextField.setFont(new Font("Dialog", 1, 10));
            this.Dataset1ClassFileTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            selectClassFileButton.setText("...");
            selectClassFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectClassFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectClass1FileButtonActionPerformed(evt);
                }
            });
        } else {
            this.Dataset2RankFileTextField = new JFormattedTextField();
            this.Dataset2RankFileTextField.setColumns(this.defaultColumns);
            this.Dataset2RankFileTextField.setFont(new Font("Dialog", 1, 10));
            this.Dataset2RankFileTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            selectRanksFileButton.setText("...");
            selectRanksFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectRanksFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectRank2FileButtonActionPerformed(evt);
                }
            });
            this.Dataset2ClassFileTextField = new JFormattedTextField();
            this.Dataset2ClassFileTextField.setColumns(this.defaultColumns);
            this.Dataset2ClassFileTextField.setFont(new Font("Dialog", 1, 10));
            this.Dataset2ClassFileTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            selectClassFileButton.setText("...");
            selectClassFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectClassFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectClass2FileButtonActionPerformed(evt);
                }
            });
        }
        JPanel RanksPanel = new JPanel();
        RanksPanel.setLayout(new BorderLayout());
        RanksPanel.add((Component)RanksLabel, "West");
        if (dataset == 1) {
            RanksPanel.add((Component)this.Dataset1RankFileTextField, "Center");
        } else {
            RanksPanel.add((Component)this.Dataset2RankFileTextField, "Center");
        }
        RanksPanel.add((Component)selectRanksFileButton, "East");
        JPanel ClassPanel = new JPanel();
        ClassPanel.setLayout(new BorderLayout());
        ClassPanel.add((Component)ClassLabel, "West");
        if (dataset == 1) {
            ClassPanel.add((Component)this.Dataset1ClassFileTextField, "Center");
        } else {
            ClassPanel.add((Component)this.Dataset2ClassFileTextField, "Center");
        }
        ClassPanel.add((Component)selectClassFileButton, "East");
        JLabel PhenotypesLabel = new JLabel("Phenotypes:");
        JLabel vsLabel = new JLabel("VS.");
        if (dataset == 1) {
            this.Dataset1Phenotype1TextField = new JFormattedTextField((Object)"UP");
            this.Dataset1Phenotype1TextField.setColumns(4);
            this.Dataset1Phenotype1TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            this.Dataset1Phenotype2TextField = new JFormattedTextField((Object)"DOWN");
            this.Dataset1Phenotype2TextField.setColumns(4);
            this.Dataset1Phenotype2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        } else {
            this.Dataset2Phenotype1TextField = new JFormattedTextField((Object)"UP");
            this.Dataset2Phenotype1TextField.setColumns(4);
            this.Dataset2Phenotype1TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            this.Dataset2Phenotype2TextField = new JFormattedTextField((Object)"DOWN");
            this.Dataset2Phenotype2TextField.setColumns(4);
            this.Dataset2Phenotype2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        }
        JPanel PhenotypesPanel = new JPanel();
        PhenotypesPanel.setLayout(new FlowLayout());
        PhenotypesPanel.add(PhenotypesLabel);
        if (dataset == 1) {
            PhenotypesPanel.add(this.Dataset1Phenotype1TextField);
            PhenotypesPanel.add(vsLabel);
            PhenotypesPanel.add(this.Dataset1Phenotype2TextField);
        } else {
            PhenotypesPanel.add(this.Dataset2Phenotype1TextField);
            PhenotypesPanel.add(vsLabel);
            PhenotypesPanel.add(this.Dataset2Phenotype2TextField);
        }
        advancedpanel.add((Component)RanksPanel, "North");
        advancedpanel.add((Component)ClassPanel, "Center");
        advancedpanel.add((Component)PhenotypesPanel, "South");
        Advanced.getContentPane().add((Component)advancedpanel, "North");
        return Advanced;
    }

    private CollapsiblePanel createParametersPanel() {
        int precision = 6;
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        this.scinot = new JCheckBox("Scientific notation");
        this.scinot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectScientificNotationActionPerformed(evt);
            }
        });
        JLabel scinotLabel = new JLabel("");
        JPanel scinotPanel = new JPanel();
        scinotPanel.setLayout(new BorderLayout());
        scinotPanel.setToolTipText("Allows pvalue and q-value to be entered in scientific notation, i.e. 5E-3 instead of 0.005");
        scinotPanel.add((Component)scinotLabel, "West");
        scinotPanel.add((Component)this.scinot, "East");
        JLabel pvalueCutOffLabel = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(precision);
        this.pvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String pvalueCutOffTip = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(pvalueCutOffTip);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel pvalueCutOffPanel = new JPanel();
        pvalueCutOffPanel.setLayout(new BorderLayout());
        pvalueCutOffPanel.setToolTipText(pvalueCutOffTip);
        pvalueCutOffPanel.add((Component)pvalueCutOffLabel, "West");
        pvalueCutOffPanel.add((Component)this.pvalueTextField, "East");
        JLabel qvalueCutOffLabel = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(precision);
        this.qvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String qvalueCutOffTip = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(qvalueCutOffTip);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel qvalueCutOffPanel = new JPanel();
        qvalueCutOffPanel.setLayout(new BorderLayout());
        qvalueCutOffPanel.setToolTipText(qvalueCutOffTip);
        qvalueCutOffPanel.add((Component)qvalueCutOffLabel, "West");
        qvalueCutOffPanel.add((Component)this.qvalueTextField, "East");
        this.jaccard = new JRadioButton("Jaccard Coefficient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.overlap = new JRadioButton("Overlap Coefficient");
        this.overlap.setActionCommand("overlap");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(this.jaccard);
        jaccardOrOverlap.add(this.overlap);
        jaccardOrOverlap.add(this.combined);
        this.jaccard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.overlap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.combined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        JPanel index_buttons = new JPanel();
        index_buttons.setLayout(new BorderLayout());
        index_buttons.add((Component)this.jaccard, "North");
        index_buttons.add((Component)this.overlap, "Center");
        index_buttons.add((Component)this.combined, "South");
        JLabel coeffecientCutOffLabel = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(precision);
        this.coeffecientTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String coeffecientCutOffTip = "Sets the Jaccard or Overlap coefficient cutoff \nonly edges with a Jaccard or Overlap coefficient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(coeffecientCutOffTip);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        JLabel combinedCutoff = new JLabel("Combined Constant");
        this.combinedConstantTextField = new JFormattedTextField(this.decFormat);
        this.combinedConstantTextField.setColumns(precision);
        this.combinedConstantTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.combinedConstantTextField.setValue(0.5);
        JPanel kconstantPanel = new JPanel();
        kconstantPanel.setLayout(new BorderLayout());
        kconstantPanel.add((Component)combinedCutoff, "West");
        kconstantPanel.add((Component)this.combinedConstantTextField, "East");
        JPanel coeffecientCutOffPanel = new JPanel();
        coeffecientCutOffPanel.setLayout(new BorderLayout());
        coeffecientCutOffPanel.setToolTipText(coeffecientCutOffTip);
        JLabel similarityCutoff = new JLabel("Similarity Cutoff:");
        coeffecientCutOffPanel.add((Component)similarityCutoff, "North");
        coeffecientCutOffPanel.add((Component)index_buttons, "West");
        coeffecientCutOffPanel.add((Component)coeffecientCutOffLabel, "Center");
        coeffecientCutOffPanel.add((Component)this.coeffecientTextField, "East");
        coeffecientCutOffPanel.add((Component)kconstantPanel, "South");
        panel.add(pvalueCutOffPanel);
        panel.add(qvalueCutOffPanel);
        panel.add(scinotPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        collapsiblePanel.getContentPane().add((Component)coeffecientCutOffPanel, "South");
        return collapsiblePanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Build");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameters new_params = new EnrichmentMapParameters(EnrichmentMapInputPanel.this.sessionManager, EnrichmentMapInputPanel.this.streamUtil, EnrichmentMapInputPanel.this.applicationManager);
                new_params.copy(EnrichmentMapInputPanel.this.empanel.getParams());
                new_params.addFiles("Dataset 1", EnrichmentMapInputPanel.this.dataset1files);
                if (!EnrichmentMapInputPanel.this.dataset2files.isEmpty()) {
                    new_params.addFiles("Dataset 2", EnrichmentMapInputPanel.this.dataset2files);
                }
                EnrichmentMap map = new EnrichmentMap(new_params);
                ResultTaskObserver observer = new ResultTaskObserver();
                EnrichmentMapBuildMapTaskFactory buildmap = new EnrichmentMapBuildMapTaskFactory(map, EnrichmentMapInputPanel.this.applicationManager, EnrichmentMapInputPanel.this.application, EnrichmentMapInputPanel.this.networkManager, EnrichmentMapInputPanel.this.networkViewManager, EnrichmentMapInputPanel.this.networkViewFactory, EnrichmentMapInputPanel.this.networkFactory, EnrichmentMapInputPanel.this.tableFactory, EnrichmentMapInputPanel.this.tableManager, EnrichmentMapInputPanel.this.visualMappingManager, EnrichmentMapInputPanel.this.visualStyleFactory, EnrichmentMapInputPanel.this.vmfFactoryContinuous, EnrichmentMapInputPanel.this.vmfFactoryDiscrete, EnrichmentMapInputPanel.this.vmfFactoryPassthrough, EnrichmentMapInputPanel.this.dialog, EnrichmentMapInputPanel.this.streamUtil, EnrichmentMapInputPanel.this.layoutManager, EnrichmentMapInputPanel.this.mapTableToNetworkTable);
                EnrichmentMapInputPanel.this.dialog.execute(buildmap.createTaskIterator(), (TaskObserver)observer);
                EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
                manager.registerServices();
            }
        });
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    public void close() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    private void populateFieldsFromEdb(File edbFile, boolean dataset1) {
        boolean AutoPopulate;
        String gmt = "";
        String cls = "";
        String rnk = "";
        String currentDir = edbFile.getParent();
        File temp = new File(currentDir, "gene_sets.gmt");
        if (temp.exists()) {
            gmt = temp.getAbsolutePath();
        }
        File[] filenames = edbFile.getParentFile().listFiles();
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i].getName().endsWith(".cls")) {
                cls = filenames[i].getAbsolutePath();
            }
            if (!filenames[i].getName().endsWith(".rnk")) continue;
            rnk = filenames[i].getAbsolutePath();
        }
        if (dataset1) {
            if (this.dataset1files.getGMTFileName() == null || this.dataset1files.getGMTFileName().equalsIgnoreCase("")) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.dataset1files.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            AutoPopulate = true;
            if (!this.dataset1files.getGMTFileName().equalsIgnoreCase(gmt)) {
                File currentGMTFilename = new File(this.dataset1files.getGMTFileName());
                File newGMTFilename = new File(gmt);
                if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                    int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                    if (answer == 1) {
                        this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                        this.GMTFileNameTextField.setText(gmt);
                        this.dataset1files.setGMTFileName(gmt);
                        this.GMTFileNameTextField.setToolTipText(gmt);
                    } else if (answer == 2) {
                        AutoPopulate = false;
                    }
                }
            }
            if (AutoPopulate) {
                this.Dataset1RankFileTextField.setForeground(this.checkFile(rnk));
                this.Dataset1RankFileTextField.setText(rnk);
                this.dataset1files.setRankedFile(rnk);
                this.Dataset1RankFileTextField.setToolTipText(rnk);
                this.dataset1files.setEnrichmentFileName1(edbFile.getAbsolutePath());
                this.setDatasetnames(edbFile.getAbsolutePath(), "", dataset1);
            }
        } else {
            if (this.dataset1files.getGMTFileName() == null || this.dataset1files.getGMTFileName().equalsIgnoreCase("")) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.dataset1files.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            AutoPopulate = true;
            if (!this.dataset1files.getGMTFileName().equalsIgnoreCase(gmt)) {
                File currentGMTFilename = new File(this.dataset1files.getGMTFileName());
                File newGMTFilename = new File(gmt);
                if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                    int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                    if (answer == 1) {
                        this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                        this.GMTFileNameTextField.setText(gmt);
                        this.dataset1files.setGMTFileName(gmt);
                        this.GMTFileNameTextField.setToolTipText(gmt);
                    } else if (answer == 2) {
                        AutoPopulate = false;
                    }
                }
            }
            if (AutoPopulate) {
                this.Dataset2RankFileTextField.setForeground(this.checkFile(rnk));
                this.Dataset2RankFileTextField.setText(rnk);
                this.dataset2files.setRankedFile(rnk);
                this.Dataset2RankFileTextField.setToolTipText(rnk);
                this.dataset2files.setGMTFileName(gmt);
                this.dataset2files.setEnrichmentFileName1(edbFile.getAbsolutePath());
                this.setDatasetnames(edbFile.getAbsolutePath(), "", dataset1);
            }
        }
    }

    private void populateFieldsFromRpt(File rptFile, boolean dataset1) {
        if (dataset1) {
            this.LoadedFromRpt_dataset1 = true;
        } else {
            this.LoadedFromRpt_dataset2 = true;
        }
        try {
            File temp;
            InputStream reader = this.streamUtil.getInputStream(rptFile.getAbsolutePath());
            String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
            HashMap<String, String> rpt = new HashMap<String, String>();
            String[] lines = fullText.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (tokens.length == 2) {
                    rpt.put(tokens[0], tokens[1]);
                    continue;
                }
                if (tokens.length != 3) continue;
                rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
            }
            String timestamp = (String)rpt.get("producer_timestamp");
            String method = (String)rpt.get("producer_class");
            method = method.split("\\p{Punct}")[2];
            String out_dir = (String)rpt.get("param out");
            String job_dir_name = null;
            String data = (String)rpt.get("param res");
            String label = (String)rpt.get("param rpt_label");
            String classes = (String)rpt.get("param cls");
            String gmt = (String)rpt.get("param gmx");
            String currentDir = rptFile.getParent();
            if (!new File(gmt).exists() && (temp = new File(currentDir, "edb/gene_sets.gmt")).exists()) {
                gmt = temp.getAbsolutePath();
            }
            String gseaHtmlReportFile = (String)rpt.get("file");
            String phenotype1 = "na";
            String phenotype2 = "na";
            if (classes != null && method.equalsIgnoreCase("Gsea")) {
                String phenotypes;
                String[] phenotypes_split;
                String[] classes_split = classes.split("#");
                if (classes_split.length >= 2 && (phenotypes_split = (phenotypes = classes_split[1]).split("_versus_")).length >= 2) {
                    phenotype1 = phenotypes_split[0];
                    phenotype2 = phenotypes_split[1];
                    if (dataset1) {
                        this.dataset1files.setClassFile(classes_split[0]);
                        this.dataset1files.setTemp_class1(this.setClasses(classes_split[0]));
                        this.dataset1files.setPhenotype1(phenotype1);
                        this.dataset1files.setPhenotype2(phenotype2);
                        this.Dataset1Phenotype1TextField.setText(phenotype1);
                        this.Dataset1Phenotype1TextField.setValue(phenotype1);
                        this.Dataset1Phenotype2TextField.setText(phenotype2);
                        this.Dataset1Phenotype2TextField.setValue(phenotype2);
                        this.Dataset1ClassFileTextField.setValue(classes_split[0]);
                        this.Dataset1ClassFileTextField.setForeground(this.checkFile(classes_split[0]));
                    } else {
                        this.dataset2files.setClassFile(classes_split[0]);
                        this.dataset2files.setTemp_class1(this.setClasses(classes_split[0]));
                        this.dataset2files.setPhenotype1(phenotype1);
                        this.dataset2files.setPhenotype2(phenotype2);
                        this.Dataset2Phenotype1TextField.setText(phenotype1);
                        this.Dataset2Phenotype2TextField.setText(phenotype2);
                        this.Dataset2Phenotype1TextField.setValue(phenotype1);
                        this.Dataset2Phenotype2TextField.setValue(phenotype2);
                        this.Dataset2ClassFileTextField.setValue(classes_split[0]);
                        this.Dataset2ClassFileTextField.setForeground(this.checkFile(classes_split[0]));
                    }
                }
            } else if (method.equalsIgnoreCase("GseaPreranked")) {
                data = (String)rpt.get("param rnk");
                phenotype1 = "na_pos";
                phenotype2 = "na_neg";
                if (dataset1) {
                    this.dataset1files.setPhenotype1(phenotype1);
                    this.dataset1files.setPhenotype2(phenotype2);
                    this.Dataset1Phenotype1TextField.setText(phenotype1);
                    this.Dataset1Phenotype2TextField.setText(phenotype2);
                    this.Dataset1Phenotype1TextField.setValue(phenotype1);
                    this.Dataset1Phenotype2TextField.setValue(phenotype2);
                } else {
                    this.dataset2files.setPhenotype1(phenotype1);
                    this.dataset2files.setPhenotype2(phenotype2);
                    this.Dataset2Phenotype1TextField.setText(phenotype1);
                    this.Dataset2Phenotype2TextField.setText(phenotype2);
                    this.Dataset2Phenotype1TextField.setValue(phenotype1);
                    this.Dataset2Phenotype2TextField.setValue(phenotype2);
                }
                if (rpt.containsKey("param phenotypes")) {
                    String phenotypes = (String)rpt.get("param phenotypes");
                    String[] phenotypes_split = phenotypes.split("_versus_");
                    if (dataset1) {
                        this.Dataset1Phenotype1TextField.setValue(phenotypes_split[0]);
                        this.Dataset1Phenotype2TextField.setValue(phenotypes_split[1]);
                    } else {
                        this.Dataset2Phenotype1TextField.setValue(phenotypes_split[0]);
                        this.Dataset2Phenotype2TextField.setValue(phenotypes_split[1]);
                    }
                }
                if (rpt.containsKey("param expressionMatrix")) {
                    data = (String)rpt.get("param expressionMatrix");
                }
            } else {
                JOptionPane.showMessageDialog(this, "The class field in the rpt file has been modified or doesn't specify a class file\n but the analysis is a classic GSEA not PreRanked.  ");
            }
            String results1 = "";
            String results2 = "";
            String ranks = "";
            job_dir_name = label + "." + method + "." + timestamp;
            results1 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
            results2 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
            ranks = "" + out_dir + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
            if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
                String out_dir_new = rptFile.getAbsolutePath();
                out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator));
                if (!(out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator))).equalsIgnoreCase(out_dir)) {
                    results1 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                    results2 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                    ranks = out_dir_new + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                    gseaHtmlReportFile = "" + out_dir_new + File.separator + job_dir_name + File.separator + "index.html";
                    if (this.checkFile(results1) != Color.BLACK) {
                        results1 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                    }
                    if (this.checkFile(results2) != Color.BLACK) {
                        results2 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                    }
                    if (this.checkFile(ranks) != Color.BLACK) {
                        ranks = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                    }
                    if (this.checkFile(gseaHtmlReportFile) != Color.BLACK) {
                        gseaHtmlReportFile = "" + out_dir + File.separator + job_dir_name + File.separator + "index.html";
                    }
                }
            }
            if (dataset1) {
                if (this.dataset1files.getGMTFileName() == null || this.dataset1files.getGMTFileName().equalsIgnoreCase("")) {
                    this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                    this.GMTFileNameTextField.setText(gmt);
                    this.dataset1files.setGMTFileName(gmt);
                    this.GMTFileNameTextField.setToolTipText(gmt);
                }
                boolean AutoPopulate = true;
                if (!this.dataset1files.getGMTFileName().equalsIgnoreCase(gmt)) {
                    File currentGMTFilename = new File(this.dataset1files.getGMTFileName());
                    File newGMTFilename = new File(gmt);
                    if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                        int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                        if (answer == 1) {
                            this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                            this.GMTFileNameTextField.setText(gmt);
                            this.dataset1files.setGMTFileName(gmt);
                            this.GMTFileNameTextField.setToolTipText(gmt);
                        } else if (answer == 2) {
                            AutoPopulate = false;
                        }
                    }
                }
                if (AutoPopulate) {
                    this.GCTFileName1TextField.setForeground(this.checkFile(data));
                    this.GCTFileName1TextField.setText(data);
                    this.dataset1files.setExpressionFileName(data);
                    this.params.setData(true);
                    this.GCTFileName1TextField.setToolTipText(data);
                    this.Dataset1RankFileTextField.setForeground(this.checkFile(ranks));
                    this.Dataset1RankFileTextField.setText(ranks);
                    this.dataset1files.setRankedFile(ranks);
                    this.Dataset1RankFileTextField.setToolTipText(ranks);
                    this.dataset1files.setEnrichmentFileName1(results1);
                    this.dataset1files.setEnrichmentFileName2(results2);
                    this.dataset1files.setGseaHtmlReportFile(gseaHtmlReportFile);
                    this.setDatasetnames(results1, results2, dataset1);
                }
            } else {
                if (this.dataset1files.getGMTFileName() == null || this.dataset1files.getGMTFileName().equalsIgnoreCase("")) {
                    this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                    this.GMTFileNameTextField.setText(gmt);
                    this.dataset1files.setGMTFileName(gmt);
                    this.GMTFileNameTextField.setToolTipText(gmt);
                }
                boolean AutoPopulate = true;
                if (!this.dataset1files.getGMTFileName().equalsIgnoreCase(gmt)) {
                    File currentGMTFilename = new File(this.dataset1files.getGMTFileName());
                    File newGMTFilename = new File(gmt);
                    if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                        int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                        if (answer == 1) {
                            this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                            this.GMTFileNameTextField.setText(gmt);
                            this.dataset1files.setGMTFileName(gmt);
                            this.GMTFileNameTextField.setToolTipText(gmt);
                        } else if (answer == 2) {
                            AutoPopulate = false;
                        }
                    }
                }
                if (AutoPopulate) {
                    this.dataset2files.setGMTFileName(gmt);
                    this.GCTFileName2TextField.setForeground(this.checkFile(data));
                    this.GCTFileName2TextField.setText(data);
                    this.dataset2files.setExpressionFileName(data);
                    this.params.setData2(true);
                    this.GCTFileName2TextField.setToolTipText(data);
                    this.Dataset2RankFileTextField.setForeground(this.checkFile(ranks));
                    this.Dataset2RankFileTextField.setText(ranks);
                    this.dataset2files.setRankedFile(ranks);
                    this.Dataset2RankFileTextField.setToolTipText(ranks);
                    this.dataset2files.setEnrichmentFileName1(results1);
                    this.dataset2files.setEnrichmentFileName2(results2);
                    this.dataset2files.setGseaHtmlReportFile(gseaHtmlReportFile);
                    this.setDatasetnames(results1, results2, dataset1);
                }
            }
        }
        catch (IOException ie) {
            System.out.println("unable to open rpt file: " + rptFile);
        }
    }

    protected void setDatasetnames(String file1, String file2, boolean dataset1) {
        if (dataset1) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset1FileNameTextField.setText(file1);
            this.Dataset1FileNameTextField.setToolTipText(file1);
            this.Dataset1FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset1FileName2TextField.setText(file2);
            this.Dataset1FileName2TextField.setToolTipText(file2);
        } else {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset2FileNameTextField.setText(file1);
            this.Dataset2FileNameTextField.setToolTipText(file1);
            this.Dataset2FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset2FileName2TextField.setText(file2);
            this.Dataset2FileName2TextField.setToolTipText(file2);
        }
    }

    private String[] setClasses(String classFile) {
        File f = new File(classFile);
        if (!f.exists()) {
            return null;
        }
        if (!classFile.equalsIgnoreCase(null)) {
            try {
                InputStream reader = this.streamUtil.getInputStream(classFile);
                String fullText2 = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
                String[] lines2 = fullText2.split("\r\n?|\n");
                String[] classes = null;
                if (lines2.length >= 3) {
                    classes = lines2[2].split("\\s");
                } else if (lines2.length == 1) {
                    classes = lines2[0].split("\\s");
                }
                return classes;
            }
            catch (IOException ie) {
                System.out.println("unable to open class file: " + classFile);
                return null;
            }
        }
        String[] def_pheno = new String[]{"Na_pos", "NA_neg"};
        return def_pheno;
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("GSEA")) {
            this.params.setMethod("GSEA");
        } else if (analysisType.equalsIgnoreCase("generic")) {
            this.params.setMethod("generic");
        } else if (analysisType.equalsIgnoreCase("DAVID/BiNGO/Great")) {
            this.params.setMethod("DAVID/BiNGO/Great");
        }
        boolean datasets_collapsed = this.datasets.isCollapsed();
        boolean dataset1_collapsed = this.dataset1.isCollapsed();
        boolean dataset2_collapsed = this.dataset2.isCollapsed();
        this.datasets.remove(this.DatasetsPanel);
        this.DatasetsPanel.remove(this.dataset1);
        this.DatasetsPanel.remove(this.dataset2);
        this.dataset1 = this.createDataset1Panel();
        this.dataset1.setCollapsed(dataset1_collapsed);
        this.DatasetsPanel.add(this.dataset1);
        this.dataset2 = this.createDataset2Panel();
        this.dataset2.setCollapsed(dataset2_collapsed);
        this.DatasetsPanel.add(this.dataset2);
        this.DatasetsPanel.revalidate();
        this.datasets.getContentPane().add((Component)this.DatasetsPanel, "North");
        this.datasets.setCollapsed(datasets_collapsed);
        this.datasets.revalidate();
        this.UpdatePanel();
    }

    private void UpdatePanel() {
        String file;
        if (this.dataset1files != null) {
            if (this.dataset1files.getEnrichmentFileName1() != null) {
                file = this.dataset1files.getEnrichmentFileName1();
                this.Dataset1FileNameTextField.setText(file);
                this.Dataset1FileNameTextField.setToolTipText(file);
                this.Dataset1FileNameTextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset1files.getExpressionFileName() != null) {
                this.GCTFileName1TextField.setText(this.dataset1files.getExpressionFileName());
                this.GCTFileName1TextField.setToolTipText(this.dataset1files.getExpressionFileName());
            }
            if (this.dataset1files.getRankedFile() != null) {
                this.Dataset1RankFileTextField.setText(this.dataset1files.getRankedFile());
                this.Dataset1RankFileTextField.setToolTipText(this.dataset1files.getRankedFile());
            }
            if (this.dataset2files.getEnrichmentFileName1() != null) {
                this.Dataset2FileNameTextField.setText(this.dataset2files.getEnrichmentFileName1());
                this.Dataset2FileNameTextField.setToolTipText(this.dataset2files.getEnrichmentFileName1());
            }
            if (this.dataset2files.getExpressionFileName() != null) {
                this.GCTFileName2TextField.setText(this.dataset2files.getExpressionFileName());
                this.GCTFileName2TextField.setToolTipText(this.dataset2files.getExpressionFileName());
            }
            if (this.dataset2files.getRankedFile() != null) {
                this.Dataset2RankFileTextField.setText(this.dataset2files.getRankedFile());
                this.Dataset2RankFileTextField.setToolTipText(this.dataset2files.getRankedFile());
            }
            if (this.dataset1files.getExpressionFileName() != null) {
                file = this.dataset1files.getExpressionFileName();
                this.GCTFileName1TextField.setText(file);
                this.GCTFileName1TextField.setToolTipText(file);
                this.GCTFileName1TextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset1files.getRankedFile() != null) {
                file = this.dataset1files.getRankedFile();
                this.Dataset1RankFileTextField.setText(file);
                this.Dataset1RankFileTextField.setToolTipText(file);
                this.Dataset1RankFileTextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset1files.getPhenotype1() != null) {
                this.Dataset1Phenotype1TextField.setText(this.dataset1files.getPhenotype1());
                this.Dataset1Phenotype1TextField.setValue(this.dataset1files.getPhenotype1());
                this.Dataset1Phenotype1TextField.setToolTipText(this.dataset1files.getPhenotype1());
            }
            if (this.dataset1files.getPhenotype2() != null) {
                this.Dataset1Phenotype2TextField.setText(this.dataset1files.getPhenotype2());
                this.Dataset1Phenotype2TextField.setValue(this.dataset1files.getPhenotype2());
                this.Dataset1Phenotype2TextField.setToolTipText(this.dataset1files.getPhenotype2());
            }
            if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
                if (this.dataset1files.getEnrichmentFileName2() != null) {
                    file = this.dataset1files.getEnrichmentFileName2();
                    this.Dataset1FileName2TextField.setText(file);
                    this.Dataset1FileName2TextField.setToolTipText(file);
                    this.Dataset1FileName2TextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
                }
            } else if (this.dataset1files.getEnrichmentFileName2() != null) {
                JOptionPane.showMessageDialog(this, "Running Enrichment Map with Generic input allows for only one enrichment results file.\n  The second file specified has been removed.");
                if (this.dataset1files.getEnrichmentFileName2() != null) {
                    this.dataset1files.setEnrichmentFileName2(null);
                }
            }
        }
        if (this.dataset2files != null) {
            if (this.dataset2files.getEnrichmentFileName1() != null) {
                file = this.dataset2files.getEnrichmentFileName1();
                this.Dataset2FileNameTextField.setText(file);
                this.Dataset2FileNameTextField.setToolTipText(file);
                this.Dataset2FileNameTextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset2files.getExpressionFileName() != null) {
                file = this.dataset2files.getExpressionFileName();
                this.GCTFileName2TextField.setText(file);
                this.GCTFileName2TextField.setToolTipText(file);
                this.GCTFileName2TextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset2files.getRankedFile() != null) {
                file = this.dataset2files.getRankedFile();
                this.Dataset2RankFileTextField.setText(file);
                this.Dataset2RankFileTextField.setToolTipText(file);
                this.Dataset2RankFileTextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
            }
            if (this.dataset2files.getPhenotype1() != null) {
                this.Dataset2Phenotype1TextField.setText(this.dataset2files.getPhenotype1());
                this.Dataset2Phenotype1TextField.setValue(this.dataset2files.getPhenotype1());
                this.Dataset2Phenotype1TextField.setToolTipText(this.dataset2files.getPhenotype1());
            }
            if (this.dataset2files.getPhenotype2() != null) {
                this.Dataset2Phenotype2TextField.setText(this.dataset2files.getPhenotype2());
                this.Dataset2Phenotype2TextField.setValue(this.dataset2files.getPhenotype2());
                this.Dataset2Phenotype2TextField.setToolTipText(this.dataset2files.getPhenotype2());
            }
            if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
                if (this.dataset2files.getEnrichmentFileName2() != null) {
                    file = this.dataset2files.getEnrichmentFileName2();
                    this.Dataset2FileName2TextField.setText(file);
                    this.Dataset2FileName2TextField.setToolTipText(file);
                    this.Dataset2FileName2TextField.setForeground(this.checkFile(new File(file).getAbsolutePath()));
                }
            } else if (this.dataset2files.getEnrichmentFileName2() != null && this.dataset2files.getEnrichmentFileName2() != null) {
                this.dataset2files.setEnrichmentFileName2(null);
            }
        }
    }

    private void selectScientificNotationActionPerformed(ActionEvent evt) {
        if (this.scinot.isSelected()) {
            this.pvalueTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    DecimalFormat format = new DecimalFormat("0.######E00");
                    ((NumberFormat)format).setMinimumFractionDigits(0);
                    ((NumberFormat)format).setMaximumFractionDigits(12);
                    InternationalFormatter formatter = new InternationalFormatter(format);
                    formatter.setAllowsInvalid(true);
                    return formatter;
                }
            });
            this.qvalueTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    DecimalFormat format = new DecimalFormat("0.######E00");
                    ((NumberFormat)format).setMinimumFractionDigits(0);
                    ((NumberFormat)format).setMaximumFractionDigits(12);
                    InternationalFormatter formatter = new InternationalFormatter(format);
                    formatter.setAllowsInvalid(true);
                    return formatter;
                }
            });
        } else {
            this.pvalueTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    DecimalFormat format = new DecimalFormat();
                    ((NumberFormat)format).setMinimumFractionDigits(1);
                    ((NumberFormat)format).setMaximumFractionDigits(12);
                    InternationalFormatter formatter = new InternationalFormatter(format);
                    formatter.setAllowsInvalid(true);
                    return formatter;
                }
            });
            this.qvalueTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    DecimalFormat format = new DecimalFormat();
                    ((NumberFormat)format).setMinimumFractionDigits(1);
                    ((NumberFormat)format).setMaximumFractionDigits(12);
                    InternationalFormatter formatter = new InternationalFormatter(format);
                    formatter.setAllowsInvalid(true);
                    return formatter;
                }
            });
        }
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.params.setSimilarityMetric("JACCARD");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("combined")) {
            this.params.setSimilarityMetric("COMBINED");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import GMT File", 0, all_filters);
        if (file != null) {
            this.GMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.GMTFileNameTextField.setText(file.getAbsolutePath());
            this.dataset1files.setGMTFileName(file.getAbsolutePath());
            this.GMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectGCTFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_gct = new FileChooserFilter("gct Files", "gct");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_rnk = new FileChooserFilter("rnk Files", "rnk");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_gct);
        all_filters.add(filter_rpt);
        all_filters.add(filter_rnk);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import GCT File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, true);
            } else {
                this.GCTFileName1TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName1TextField.setText(file.getAbsolutePath());
                this.dataset1files.setExpressionFileName(file.getAbsolutePath());
                this.GCTFileName1TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setData(true);
        }
    }

    private void selectGCTFileButton2ActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_gct = new FileChooserFilter("gct Files", "gct");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_rnk = new FileChooserFilter("rnk Files", "rnk");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_gct);
        all_filters.add(filter_rpt);
        all_filters.add(filter_rnk);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import GCT File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, false);
            } else {
                this.GCTFileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName2TextField.setText(file.getAbsolutePath());
                this.dataset2files.setExpressionFileName(file.getAbsolutePath());
                this.GCTFileName2TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
            this.params.setData2(true);
        }
    }

    private void selectDataset1FileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_xls = new FileChooserFilter("gct Files", "xls");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_bgo = new FileChooserFilter("rnk Files", "bgo");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        FileChooserFilter filter_tsv = new FileChooserFilter("tsv Files", "tsv");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_xls);
        all_filters.add(filter_rpt);
        all_filters.add(filter_bgo);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        all_filters.add(filter_tsv);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import dataset result File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, true);
            } else {
                this.Dataset1FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset1FileNameTextField.setText(file.getAbsolutePath());
                this.dataset1files.setEnrichmentFileName1(file.getAbsolutePath());
                this.Dataset1FileNameTextField.setToolTipText(file.getAbsolutePath());
            }
        }
    }

    private void selectDataset1File2ButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_xls = new FileChooserFilter("gct Files", "xls");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_bgo = new FileChooserFilter("rnk Files", "bgo");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        FileChooserFilter filter_tsv = new FileChooserFilter("tsv Files", "tsv");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_xls);
        all_filters.add(filter_rpt);
        all_filters.add(filter_bgo);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        all_filters.add(filter_tsv);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import dataset result File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, true);
            } else {
                this.Dataset1FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset1FileName2TextField.setText(file.getAbsolutePath());
                this.dataset1files.setEnrichmentFileName2(file.getAbsolutePath());
                this.Dataset1FileName2TextField.setToolTipText(file.getAbsolutePath());
            }
        }
    }

    private void selectDataset2FileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_xls = new FileChooserFilter("gct Files", "xls");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_bgo = new FileChooserFilter("rnk Files", "bgo");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        FileChooserFilter filter_tsv = new FileChooserFilter("tsv Files", "tsv");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_xls);
        all_filters.add(filter_rpt);
        all_filters.add(filter_bgo);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        all_filters.add(filter_tsv);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import dataset result File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, false);
            } else {
                this.Dataset2FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset2FileNameTextField.setText(file.getAbsolutePath());
                this.dataset2files.setEnrichmentFileName1(file.getAbsolutePath());
                this.Dataset2FileNameTextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
        }
    }

    private void selectDataset2File2ButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_xls = new FileChooserFilter("gct Files", "xls");
        FileChooserFilter filter_rpt = new FileChooserFilter("rpt Files", "rpt");
        FileChooserFilter filter_bgo = new FileChooserFilter("rnk Files", "bgo");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        FileChooserFilter filter_edb = new FileChooserFilter("edb Files", "edb");
        FileChooserFilter filter_tsv = new FileChooserFilter("tsv Files", "tsv");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_xls);
        all_filters.add(filter_rpt);
        all_filters.add(filter_bgo);
        all_filters.add(filter_txt);
        all_filters.add(filter_edb);
        all_filters.add(filter_tsv);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import dataset result File", 0, all_filters);
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else if (file.getPath().endsWith(".edb")) {
                this.populateFieldsFromEdb(file, false);
            } else {
                this.Dataset2FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset2FileName2TextField.setText(file.getAbsolutePath());
                this.dataset2files.setEnrichmentFileName2(file.getAbsolutePath());
                this.Dataset2FileName2TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
        }
    }

    private void selectRank1FileButtonActionPerformed(ActionEvent evt) {
        if (this.params.getMethod().equalsIgnoreCase("GSEA") && this.LoadedFromRpt_dataset1 && !this.Dataset1RankFileTextField.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this.application.getJFrame(), "GSEA defined rank file is in a specific order and is used to calculate the leading edge.  \n If you change this file the leading edges will be calculated incorrectly.", "Trying to change pre-defined GSEA rank file", 2);
        }
        FileChooserFilter filter_rnk = new FileChooserFilter("rnk Files", "rnk");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_rnk);
        all_filters.add(filter_txt);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import rank File", 0, all_filters);
        if (file != null) {
            this.Dataset1RankFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1RankFileTextField.setText(file.getAbsolutePath());
            this.dataset1files.setRankedFile(file.getAbsolutePath());
            this.Dataset1RankFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectClass1FileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_cls = new FileChooserFilter("cls Files", "cls");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_cls);
        all_filters.add(filter_txt);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import class file", 0, all_filters);
        if (file != null) {
            this.Dataset1ClassFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1ClassFileTextField.setText(file.getAbsolutePath());
            this.dataset1files.setClassFile(file.getAbsolutePath());
            this.dataset1files.setTemp_class1(this.setClasses(file.getAbsolutePath()));
            this.Dataset1ClassFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectClass2FileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter_cls = new FileChooserFilter("cls Files", "cls");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_cls);
        all_filters.add(filter_txt);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import class file", 0, all_filters);
        if (file != null) {
            this.Dataset2ClassFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2ClassFileTextField.setText(file.getAbsolutePath());
            this.dataset2files.setClassFile(file.getAbsolutePath());
            this.dataset2files.setTemp_class1(this.setClasses(file.getAbsolutePath()));
            this.Dataset2ClassFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectRank2FileButtonActionPerformed(ActionEvent evt) {
        if (this.params.getMethod().equalsIgnoreCase("GSEA") && this.LoadedFromRpt_dataset2 && !this.Dataset2RankFileTextField.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this.application.getJFrame(), "GSEA defined rank file is in a specific order and is used to calculate the leading edge.  \n If you change this file the leading edges will be calculated incorrectly.", "Trying to change pre-defined GSEA rank file", 2);
        }
        FileChooserFilter filter_rnk = new FileChooserFilter("rnk Files", "rnk");
        FileChooserFilter filter_txt = new FileChooserFilter("txt Files", "txt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter_rnk);
        all_filters.add(filter_txt);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import rank File", 0, all_filters);
        if (file != null) {
            this.Dataset2RankFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2RankFileTextField.setText(file.getAbsolutePath());
            this.dataset2files.setRankedFile(file.getAbsolutePath());
            this.Dataset2RankFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void resetPanel() {
        this.params = new EnrichmentMapParameters(this.sessionManager, this.streamUtil, this.applicationManager);
        this.panelUpdate = false;
        this.dataset1files = new DataSetFiles();
        this.dataset2files = new DataSetFiles();
        this.GMTFileNameTextField.setText("");
        this.GMTFileNameTextField.setToolTipText(null);
        this.GMTFileNameTextField.setForeground(Color.black);
        this.GCTFileName1TextField.setText("");
        this.GCTFileName1TextField.setToolTipText(null);
        this.GCTFileName1TextField.setForeground(Color.black);
        this.GCTFileName2TextField.setText("");
        this.GCTFileName2TextField.setToolTipText(null);
        this.GCTFileName2TextField.setForeground(Color.black);
        this.Dataset1FileNameTextField.setText("");
        this.Dataset1FileNameTextField.setToolTipText(null);
        this.Dataset1FileNameTextField.setForeground(Color.black);
        this.Dataset1FileName2TextField.setText("");
        this.Dataset1FileName2TextField.setToolTipText(null);
        this.Dataset1FileName2TextField.setForeground(Color.black);
        this.Dataset2FileNameTextField.setText("");
        this.Dataset2FileNameTextField.setToolTipText(null);
        this.Dataset2FileNameTextField.setForeground(Color.black);
        this.Dataset2FileName2TextField.setText("");
        this.Dataset2FileName2TextField.setToolTipText(null);
        this.Dataset2FileName2TextField.setForeground(Color.black);
        this.Dataset1RankFileTextField.setText("");
        this.Dataset1RankFileTextField.setToolTipText(null);
        this.Dataset1RankFileTextField.setForeground(Color.black);
        this.Dataset2RankFileTextField.setText("");
        this.Dataset2RankFileTextField.setToolTipText(null);
        this.Dataset2RankFileTextField.setForeground(Color.black);
        this.Dataset1Phenotype1TextField.setText("UP");
        this.Dataset1Phenotype2TextField.setText("DOWN");
        this.Dataset2Phenotype1TextField.setText("UP");
        this.Dataset2Phenotype2TextField.setText("DOWN");
        this.Dataset1Phenotype1TextField.setValue("UP");
        this.Dataset1Phenotype2TextField.setValue("DOWN");
        this.Dataset2Phenotype1TextField.setValue("UP");
        this.Dataset2Phenotype2TextField.setValue("DOWN");
        this.Dataset1ClassFileTextField.setText("");
        this.Dataset2ClassFileTextField.setText("");
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(this.params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        this.qvalueTextField.setValue(this.params.getQvalue());
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea.setSelected(true);
            this.generic.setSelected(false);
            this.david.setSelected(false);
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(true);
            this.david.setSelected(false);
        } else if (this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(false);
            this.david.setSelected(true);
        }
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public void updateContents(EnrichmentMapParameters current_params) {
        this.resetPanel();
        this.params = new EnrichmentMapParameters(this.sessionManager, this.streamUtil, this.applicationManager);
        this.params.copy(current_params);
        this.panelUpdate = true;
        if (this.params.getFiles().containsKey("Dataset 1")) {
            this.dataset1files = this.params.getFiles().get("Dataset 1");
        }
        if (this.params.getFiles().containsKey("Dataset 2")) {
            this.dataset2files = this.params.getFiles().get("Dataset 2");
        }
        this.GMTFileNameTextField.setText(this.dataset1files.getGMTFileName() == null ? "" : this.dataset1files.getGMTFileName());
        this.GMTFileNameTextField.setForeground(this.checkFile(this.GMTFileNameTextField.getText()));
        this.GCTFileName1TextField.setText(this.dataset1files.getExpressionFileName() == null ? "" : this.dataset1files.getExpressionFileName());
        this.GCTFileName1TextField.setForeground(this.checkFile(this.GCTFileName1TextField.getText()));
        this.Dataset1FileNameTextField.setText(this.dataset1files.getEnrichmentFileName1() == null ? "" : this.dataset1files.getEnrichmentFileName1());
        this.Dataset1FileNameTextField.setForeground(this.checkFile(this.Dataset1FileNameTextField.getText()));
        this.Dataset1FileName2TextField.setText(this.dataset1files.getEnrichmentFileName2() == null ? "" : this.dataset1files.getEnrichmentFileName2());
        this.Dataset1FileName2TextField.setForeground(this.checkFile(this.Dataset1FileName2TextField.getText()));
        this.Dataset1RankFileTextField.setText(this.dataset1files.getRankedFile() == null ? "" : this.dataset1files.getRankedFile());
        this.Dataset1RankFileTextField.setForeground(this.checkFile(this.Dataset1RankFileTextField.getText()));
        this.GCTFileName2TextField.setText(this.dataset2files.getExpressionFileName() == null ? "" : this.dataset2files.getExpressionFileName());
        this.GCTFileName2TextField.setForeground(this.checkFile(this.GCTFileName2TextField.getText()));
        this.Dataset2FileNameTextField.setText(this.dataset2files.getEnrichmentFileName1() == null ? "" : this.dataset2files.getEnrichmentFileName1());
        this.Dataset2FileNameTextField.setForeground(this.checkFile(this.Dataset2FileNameTextField.getText()));
        this.Dataset2FileName2TextField.setText(this.dataset2files.getEnrichmentFileName2() == null ? "" : this.dataset2files.getEnrichmentFileName2());
        this.Dataset2FileName2TextField.setForeground(this.checkFile(this.Dataset2FileName2TextField.getText()));
        this.Dataset2RankFileTextField.setText(this.dataset2files.getRankedFile() == null ? "" : this.dataset2files.getRankedFile());
        this.Dataset2RankFileTextField.setForeground(this.checkFile(this.Dataset2RankFileTextField.getText()));
        this.Dataset1Phenotype1TextField.setText(this.dataset1files.getPhenotype1());
        this.Dataset1Phenotype2TextField.setText(this.dataset1files.getPhenotype2());
        this.Dataset2Phenotype1TextField.setText(this.dataset2files.getPhenotype1());
        this.Dataset2Phenotype2TextField.setText(this.dataset2files.getPhenotype2());
        this.Dataset1Phenotype1TextField.setValue(this.dataset1files.getPhenotype1());
        this.Dataset1Phenotype2TextField.setValue(this.dataset1files.getPhenotype2());
        this.Dataset2Phenotype1TextField.setValue(this.dataset2files.getPhenotype1());
        this.Dataset2Phenotype2TextField.setValue(this.dataset2files.getPhenotype2());
        this.Dataset1ClassFileTextField.setValue(this.dataset1files.getClassFile());
        this.Dataset2ClassFileTextField.setValue(this.dataset2files.getClassFile());
        this.pvalueTextField.setText(Double.toString(current_params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(current_params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(current_params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(current_params.getPvalue());
        this.qvalueTextField.setValue(current_params.getQvalue());
        this.coeffecientTextField.setValue(current_params.getSimilarityCutOff());
        this.combinedConstantTextField.setValue(current_params.getCombinedConstant());
        if (current_params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea.setSelected(true);
            this.generic.setSelected(false);
            this.david.setSelected(false);
        } else if (current_params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(true);
            this.david.setSelected(false);
        } else if (current_params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(false);
            this.david.setSelected(true);
        }
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public EnrichmentMapParameters getParams() {
        return this.params;
    }

    public void setParams(EnrichmentMapParameters params) {
        this.params = params;
    }

    public DataSetFiles getDataset1files() {
        if (!this.GCTFileName1TextField.getText().equalsIgnoreCase(this.dataset1files.getExpressionFileName())) {
            this.dataset1files.setExpressionFileName(this.GCTFileName1TextField.getText());
        }
        if (!this.Dataset1FileNameTextField.getText().equalsIgnoreCase(this.dataset1files.getEnrichmentFileName1())) {
            this.dataset1files.setEnrichmentFileName1(this.Dataset1FileNameTextField.getText());
        }
        if (!this.Dataset1FileName2TextField.getText().equalsIgnoreCase(this.dataset1files.getEnrichmentFileName2())) {
            this.dataset1files.setEnrichmentFileName2(this.Dataset1FileName2TextField.getText());
        }
        if (!this.Dataset1RankFileTextField.getText().equalsIgnoreCase(this.dataset1files.getRankedFile())) {
            this.dataset1files.setRankedFile(this.Dataset1RankFileTextField.getText());
        }
        if (!this.Dataset1ClassFileTextField.getText().equalsIgnoreCase(this.dataset1files.getClassFile())) {
            this.dataset1files.setClassFile(this.Dataset1ClassFileTextField.getText());
        }
        if (!this.Dataset1Phenotype1TextField.getText().equalsIgnoreCase(this.dataset1files.getPhenotype1())) {
            this.dataset1files.setPhenotype1(this.Dataset1Phenotype1TextField.getText());
        }
        if (!this.Dataset1Phenotype2TextField.getText().equalsIgnoreCase(this.dataset1files.getPhenotype2())) {
            this.dataset1files.setPhenotype2(this.Dataset1Phenotype2TextField.getText());
        }
        return this.dataset1files;
    }

    public void setDataset1files(DataSetFiles dataset1files) {
        this.dataset1files = dataset1files;
    }

    public DataSetFiles getDataset2files() {
        if (!this.dataset2files.isEmpty() && this.dataset1files.getGMTFileName() != null && !this.dataset1files.getGMTFileName().equalsIgnoreCase("")) {
            this.dataset2files.setGMTFileName(this.dataset1files.getGMTFileName());
        }
        if (!this.GCTFileName2TextField.getText().equalsIgnoreCase(this.dataset2files.getExpressionFileName())) {
            this.dataset2files.setExpressionFileName(this.GCTFileName2TextField.getText());
        }
        if (!this.Dataset2FileNameTextField.getText().equalsIgnoreCase(this.dataset2files.getEnrichmentFileName1())) {
            this.dataset2files.setEnrichmentFileName1(this.Dataset2FileNameTextField.getText());
        }
        if (!this.Dataset2FileName2TextField.getText().equalsIgnoreCase(this.dataset2files.getEnrichmentFileName2())) {
            this.dataset2files.setEnrichmentFileName2(this.Dataset2FileName2TextField.getText());
        }
        if (!this.Dataset2RankFileTextField.getText().equalsIgnoreCase(this.dataset2files.getRankedFile())) {
            this.dataset2files.setRankedFile(this.Dataset2RankFileTextField.getText());
        }
        if (!this.Dataset2ClassFileTextField.getText().equalsIgnoreCase(this.dataset2files.getClassFile())) {
            this.dataset2files.setClassFile(this.Dataset2ClassFileTextField.getText());
        }
        if (!this.Dataset2Phenotype1TextField.getText().equalsIgnoreCase(this.dataset2files.getPhenotype1())) {
            this.dataset2files.setPhenotype1(this.Dataset2Phenotype1TextField.getText());
        }
        if (!this.Dataset2Phenotype2TextField.getText().equalsIgnoreCase(this.dataset2files.getPhenotype2())) {
            this.dataset2files.setPhenotype2(this.Dataset2Phenotype2TextField.getText());
        }
        return this.dataset2files;
    }

    public void setDataset2files(DataSetFiles dataset2files) {
        this.dataset2files = dataset2files;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Enrichment Map Input Panel";
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == EnrichmentMapInputPanel.this.pvalueTextField || source == EnrichmentMapInputPanel.this.qvalueTextField || source == EnrichmentMapInputPanel.this.coeffecientTextField || source == EnrichmentMapInputPanel.this.combinedConstantTextField) {
                if (source == EnrichmentMapInputPanel.this.pvalueTextField) {
                    Number value = (Number)EnrichmentMapInputPanel.this.pvalueTextField.getValue();
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        EnrichmentMapInputPanel.this.params.setPvalue(value.doubleValue());
                    } else {
                        source.setValue(EnrichmentMapInputPanel.this.params.getPvalue());
                        message = message + "The pvalue cutoff must be greater than or equal 0 and less than or equal to 1.";
                        invalid = true;
                    }
                } else if (source == EnrichmentMapInputPanel.this.qvalueTextField) {
                    Number value = (Number)EnrichmentMapInputPanel.this.qvalueTextField.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0) {
                        EnrichmentMapInputPanel.this.params.setQvalue(value.doubleValue());
                    } else {
                        source.setValue(EnrichmentMapInputPanel.this.params.getQvalue());
                        message = message + "The FDR q-value cutoff must be between 0 and 100.";
                        invalid = true;
                    }
                } else if (source == EnrichmentMapInputPanel.this.coeffecientTextField) {
                    Number value = (Number)EnrichmentMapInputPanel.this.coeffecientTextField.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        EnrichmentMapInputPanel.this.params.setSimilarityCutOff(value.doubleValue());
                        EnrichmentMapInputPanel.this.similarityCutOffChanged = true;
                    } else {
                        source.setValue(EnrichmentMapInputPanel.this.params.getSimilarityCutOff());
                        message = message + "The Overlap/Jaccard Coefficient cutoff must be between 0 and 1.";
                        invalid = true;
                    }
                } else if (source == EnrichmentMapInputPanel.this.combinedConstantTextField) {
                    Number value = (Number)EnrichmentMapInputPanel.this.combinedConstantTextField.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        EnrichmentMapInputPanel.this.params.setCombinedConstant(value.doubleValue());
                        if (!EnrichmentMapInputPanel.this.similarityCutOffChanged && EnrichmentMapInputPanel.this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
                            EnrichmentMapInputPanel.this.params.setSimilarityCutOff(EnrichmentMapInputPanel.this.params.getDefaultOverlapCutOff() * value.doubleValue() + (1.0 - value.doubleValue()) * EnrichmentMapInputPanel.this.params.getDefaultJaccardCutOff());
                        }
                    } else {
                        source.setValue(0.5);
                        message = message + "The combined Overlap/Jaccard Coefficient constant must be between 0 and 1.";
                        invalid = true;
                    }
                }
                if (invalid) {
                    JOptionPane.showMessageDialog(EnrichmentMapInputPanel.this.application.getJFrame(), message, "Parameter out of bounds", 2);
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset1Phenotype1TextField || source == EnrichmentMapInputPanel.this.Dataset1Phenotype2TextField || source == EnrichmentMapInputPanel.this.Dataset2Phenotype1TextField || source == EnrichmentMapInputPanel.this.Dataset2Phenotype2TextField) {
                if (source == EnrichmentMapInputPanel.this.Dataset1Phenotype1TextField) {
                    String value = EnrichmentMapInputPanel.this.Dataset1Phenotype1TextField.getText();
                    EnrichmentMapInputPanel.this.dataset1files.setPhenotype1(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset1Phenotype2TextField) {
                    String value = EnrichmentMapInputPanel.this.Dataset1Phenotype2TextField.getText();
                    EnrichmentMapInputPanel.this.dataset1files.setPhenotype2(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2Phenotype1TextField) {
                    String value = EnrichmentMapInputPanel.this.Dataset2Phenotype1TextField.getText();
                    EnrichmentMapInputPanel.this.dataset2files.setPhenotype1(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2Phenotype2TextField) {
                    String value = EnrichmentMapInputPanel.this.Dataset2Phenotype2TextField.getText();
                    EnrichmentMapInputPanel.this.dataset2files.setPhenotype2(value);
                }
            } else {
                String value = source.getText();
                if (source == EnrichmentMapInputPanel.this.GCTFileName1TextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setExpressionFileName(value);
                    if (value.equalsIgnoreCase("")) {
                        EnrichmentMapInputPanel.this.params.setData(false);
                    }
                } else if (source == EnrichmentMapInputPanel.this.GCTFileName2TextField) {
                    EnrichmentMapInputPanel.this.dataset2files.setExpressionFileName(value);
                    if (value.equalsIgnoreCase("")) {
                        EnrichmentMapInputPanel.this.params.setData2(false);
                    }
                } else if (source == EnrichmentMapInputPanel.this.Dataset1FileNameTextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setEnrichmentFileName1(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset1FileName2TextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setEnrichmentFileName2(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2FileNameTextField) {
                    EnrichmentMapInputPanel.this.dataset2files.setEnrichmentFileName1(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2FileName2TextField) {
                    EnrichmentMapInputPanel.this.dataset2files.setEnrichmentFileName2(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset1RankFileTextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setRankedFile(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2RankFileTextField) {
                    EnrichmentMapInputPanel.this.dataset2files.setRankedFile(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset1ClassFileTextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setClassFile(value);
                } else if (source == EnrichmentMapInputPanel.this.Dataset2ClassFileTextField) {
                    EnrichmentMapInputPanel.this.dataset2files.setClassFile(value);
                } else if (source == EnrichmentMapInputPanel.this.GMTFileNameTextField) {
                    EnrichmentMapInputPanel.this.dataset1files.setGMTFileName(value);
                }
                Color found = Color.black;
                if (!value.equalsIgnoreCase("")) {
                    found = EnrichmentMapInputPanel.this.checkFile(value);
                    source.setForeground(found);
                }
                if (found.equals(Color.RED) && !EnrichmentMapInputPanel.this.LoadedFromRpt_dataset1 && !EnrichmentMapInputPanel.this.LoadedFromRpt_dataset2 && !EnrichmentMapInputPanel.this.panelUpdate) {
                    JOptionPane.showMessageDialog(EnrichmentMapInputPanel.this.application.getJFrame(), message, "File name change entered is not a valid file name", 2);
                }
            }
        }
    }
}

