/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.util.SwingUtil;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

public class BulkEMCreationPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 7233557042420194604L;
    private FileUtil fileUtil;
    private CySwingApplication application;
    private CyServiceRegistrar registrar;
    private StreamUtil streamUtil;
    private CyApplicationManager applicationManager;
    private CySessionManager cySessionManager;
    private EnrichmentMapParameters params;
    private JFormattedTextField GSEAResultsDirTextField;
    private JFormattedTextField GMTDirectoryTextField;
    private JFormattedTextField GCTDirectoryTextField;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField lowerLimitField;
    private JFormattedTextField upperLimitField;
    private JRadioButton gsea;
    private JRadioButton generic;
    private JRadioButton david;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    private JRadioButton onesession;
    private JRadioButton multisession;
    private boolean sessions = true;
    DecimalFormat decFormat;
    NumberFormat numFormat;
    private int defaultColumns = 15;
    private boolean similarityCutOffChanged = false;

    public BulkEMCreationPanel(CySwingApplication application, FileUtil fileUtil, CyServiceRegistrar registrar, CySessionManager sessionManager, StreamUtil streamUtil, CyApplicationManager applicationManager) {
        this.params = new EnrichmentMapParameters(sessionManager, streamUtil, applicationManager);
        this.streamUtil = streamUtil;
        this.cySessionManager = this.cySessionManager;
        this.applicationManager = applicationManager;
        this.application = application;
        this.fileUtil = fileUtil;
        this.registrar = registrar;
        JPanel AnalysisTypePanel = this.createAnalysisTypePanel();
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)OptionsPanel, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)AnalysisTypePanel, "North");
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTcollapsiblePanel = this.createGMTPanel();
        GMTcollapsiblePanel.setCollapsed(false);
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        CollapsiblePanel GMTDirPanel = this.createDiffGMTGCTDirectory();
        GMTDirPanel.setCollapsed(true);
        panel.add(GMTcollapsiblePanel);
        panel.add(ParametersPanel2);
        panel.add(GMTDirPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createDiffGMTGCTDirectory() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Advanced");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("Directory containing GMT file:"){
            private static final long serialVersionUID = -122741876830022713L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGMTDirButton = new JButton();
        this.GMTDirectoryTextField = new JFormattedTextField();
        this.GMTDirectoryTextField.setColumns(this.defaultColumns);
        this.GMTDirectoryTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTDirectoryTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTDirButton.setText("...");
        selectGMTDirButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGMTDirButtonActionPerformed(evt);
            }
        });
        JPanel newGMTDirPanel = new JPanel();
        newGMTDirPanel.setLayout(new BorderLayout());
        newGMTDirPanel.add((Component)GMTLabel, "West");
        newGMTDirPanel.add((Component)this.GMTDirectoryTextField, "Center");
        newGMTDirPanel.add((Component)selectGMTDirButton, "East");
        panel.add(newGMTDirPanel);
        JLabel GCTLabel = new JLabel("Directory containing GCT file:"){
            private static final long serialVersionUID = -122741876830022713L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGCTDirButton = new JButton();
        this.GCTDirectoryTextField = new JFormattedTextField();
        this.GCTDirectoryTextField.setColumns(this.defaultColumns);
        this.GCTDirectoryTextField.setFont(new Font("Dialog", 1, 10));
        this.GCTDirectoryTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGCTDirButton.setText("...");
        selectGCTDirButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGCTDirButtonActionPerformed(evt);
            }
        });
        JPanel newGCTDirPanel = new JPanel();
        newGCTDirPanel.setLayout(new BorderLayout());
        newGCTDirPanel.add((Component)GCTLabel, "West");
        newGCTDirPanel.add((Component)this.GCTDirectoryTextField, "Center");
        newGCTDirPanel.add((Component)selectGCTDirButton, "East");
        panel.add(newGCTDirPanel);
        JLabel lowerlimitLabel = new JLabel("Lower limit:");
        this.lowerLimitField = new JFormattedTextField(this.numFormat);
        this.lowerLimitField.setColumns(3);
        this.lowerLimitField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String lowerTip = "Sets the lower limit \nof the directory number you want to  \nuse when creating networks.";
        this.lowerLimitField.setToolTipText(lowerTip);
        this.lowerLimitField.setText("1");
        this.lowerLimitField.setValue(1);
        JPanel lowerLimitPanel = new JPanel();
        lowerLimitPanel.setLayout(new BorderLayout());
        lowerLimitPanel.setToolTipText(lowerTip);
        lowerLimitPanel.add((Component)lowerlimitLabel, "West");
        lowerLimitPanel.add((Component)this.lowerLimitField, "East");
        JLabel upperlimitLabel = new JLabel("Upper limit:");
        this.upperLimitField = new JFormattedTextField(this.numFormat);
        this.upperLimitField.setColumns(3);
        this.upperLimitField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String upperTip = "Sets the upper limit \nof the directory number you want to  \nuse when creating networks.";
        this.upperLimitField.setToolTipText(upperTip);
        this.upperLimitField.setText("1");
        this.upperLimitField.setValue(1);
        JPanel upperLimitPanel = new JPanel();
        upperLimitPanel.setLayout(new BorderLayout());
        upperLimitPanel.setToolTipText(upperTip);
        upperLimitPanel.add((Component)upperlimitLabel, "West");
        upperLimitPanel.add((Component)this.upperLimitField, "East");
        panel.add(lowerLimitPanel);
        panel.add(upperLimitPanel);
        this.onesession = new JRadioButton("One session File");
        this.onesession.setActionCommand("onesession");
        this.onesession.setSelected(true);
        this.multisession = new JRadioButton("Multiple session files");
        this.multisession.setActionCommand("multisession");
        this.multisession.setSelected(true);
        this.onesession.setSelected(false);
        ButtonGroup sessionsgroup = new ButtonGroup();
        sessionsgroup.add(this.onesession);
        sessionsgroup.add(this.multisession);
        this.onesession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectOneMultiSessionActionPerformed(evt);
            }
        });
        this.multisession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectOneMultiSessionActionPerformed(evt);
            }
        });
        JPanel session_buttons = new JPanel();
        session_buttons.setLayout(new BorderLayout());
        session_buttons.add((Component)this.onesession, "North");
        session_buttons.add((Component)this.multisession, "South");
        panel.add(session_buttons);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("GSEA Results directory:"){
            private static final long serialVersionUID = -122741876830022713L;

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGMTFileButton = new JButton();
        this.GSEAResultsDirTextField = new JFormattedTextField();
        this.GSEAResultsDirTextField.setColumns(this.defaultColumns);
        this.GSEAResultsDirTextField.setFont(new Font("Dialog", 1, 10));
        this.GSEAResultsDirTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel newGMTPanel = new JPanel();
        newGMTPanel.setLayout(new BorderLayout());
        newGMTPanel.add((Component)GMTLabel, "West");
        newGMTPanel.add((Component)this.GSEAResultsDirTextField, "Center");
        newGMTPanel.add((Component)selectGMTFileButton, "East");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            panel.add(newGMTPanel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createParametersPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel pvalueCutOffLabel = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(3);
        this.pvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String pvalueCutOffTip = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(pvalueCutOffTip);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel pvalueCutOffPanel = new JPanel();
        pvalueCutOffPanel.setLayout(new BorderLayout());
        pvalueCutOffPanel.setToolTipText(pvalueCutOffTip);
        pvalueCutOffPanel.add((Component)pvalueCutOffLabel, "West");
        pvalueCutOffPanel.add((Component)this.pvalueTextField, "East");
        JLabel qvalueCutOffLabel = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(3);
        this.qvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String qvalueCutOffTip = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(qvalueCutOffTip);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel qvalueCutOffPanel = new JPanel();
        qvalueCutOffPanel.setLayout(new BorderLayout());
        qvalueCutOffPanel.setToolTipText(qvalueCutOffTip);
        qvalueCutOffPanel.add((Component)qvalueCutOffLabel, "West");
        qvalueCutOffPanel.add((Component)this.qvalueTextField, "East");
        this.jaccard = new JRadioButton("Jaccard Coeffecient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.overlap = new JRadioButton("Overlap Coeffecient");
        this.overlap.setActionCommand("overlap");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(this.jaccard);
        jaccardOrOverlap.add(this.overlap);
        jaccardOrOverlap.add(this.combined);
        this.jaccard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.overlap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.combined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        JPanel index_buttons = new JPanel();
        index_buttons.setLayout(new BorderLayout());
        index_buttons.add((Component)this.jaccard, "North");
        index_buttons.add((Component)this.overlap, "South");
        JLabel coeffecientCutOffLabel = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(3);
        this.coeffecientTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String coeffecientCutOffTip = "Sets the Jaccard or Overlap coeffecient cutoff \nonly edges with a Jaccard or Overlap coffecient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(coeffecientCutOffTip);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        JPanel coeffecientCutOffPanel = new JPanel();
        coeffecientCutOffPanel.setLayout(new BorderLayout());
        coeffecientCutOffPanel.setToolTipText(coeffecientCutOffTip);
        coeffecientCutOffPanel.add((Component)index_buttons, "West");
        coeffecientCutOffPanel.add((Component)coeffecientCutOffLabel, "Center");
        coeffecientCutOffPanel.add((Component)this.coeffecientTextField, "East");
        panel.add(pvalueCutOffPanel);
        panel.add(qvalueCutOffPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        collapsiblePanel.getContentPane().add((Component)coeffecientCutOffPanel, "South");
        return collapsiblePanel;
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectOneMultiSessionActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("onesession")) {
            this.params.setSessions(false);
        } else if (evt.getActionCommand().equalsIgnoreCase("multisession")) {
            this.params.setSessions(true);
        }
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.params.setSimilarityMetric("JACCARD");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("combined")) {
            this.params.setSimilarityMetric("COMBINED");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import gmt file", 0, all_filters);
        if (file != null) {
            this.GSEAResultsDirTextField.setText(file.getParent());
            this.params.setGSEAResultsDirName(file.getParent());
        }
    }

    private void selectGMTDirButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        FileChooserFilter filter_gct = new FileChooserFilter("All GMT Files", "gct");
        FileChooserFilter filter_txt = new FileChooserFilter("All GMT Files", "txt");
        FileChooserFilter filter_xls = new FileChooserFilter("All GMT Files", "xls");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        all_filters.add(filter_gct);
        all_filters.add(filter_txt);
        all_filters.add(filter_xls);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "GMT directory", 0, all_filters);
        if (file != null) {
            this.GMTDirectoryTextField.setText(file.getParent());
            this.params.setGMTDirName(file.getParent());
        }
    }

    private void selectGCTDirButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        FileChooserFilter filter_gct = new FileChooserFilter("All GMT Files", "gct");
        FileChooserFilter filter_txt = new FileChooserFilter("All GMT Files", "txt");
        FileChooserFilter filter_xls = new FileChooserFilter("All GMT Files", "xls");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        all_filters.add(filter_gct);
        all_filters.add(filter_txt);
        all_filters.add(filter_xls);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "GCT directory", 0, all_filters);
        if (file != null) {
            this.GCTDirectoryTextField.setText(file.getParent());
            this.params.setGCTDirName(file.getParent());
        }
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Build");
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    public void close() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    private void resetPanel() {
        this.params = new EnrichmentMapParameters(this.cySessionManager, this.streamUtil, this.applicationManager);
        this.GSEAResultsDirTextField.setText("");
        this.GSEAResultsDirTextField.setToolTipText(null);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(this.params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        this.qvalueTextField.setValue(this.params.getQvalue());
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public EnrichmentMapParameters getParams() {
        return this.params;
    }

    public void setParams(EnrichmentMapParameters params) {
        this.params = params;
    }

    private JPanel createAnalysisTypePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Analysis Type"));
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea = new JRadioButton("GSEA", true);
            this.generic = new JRadioButton("generic", false);
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic", true);
        } else if (this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO/Great")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic", false);
        }
        this.gsea.setActionCommand("GSEA");
        this.generic.setActionCommand("generic");
        this.gsea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.generic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.gsea);
        analysisOptions.add(this.generic);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.gsea, c);
        panel.add(this.gsea);
        c.gridy = 1;
        gridbag.setConstraints(this.generic, c);
        panel.add(this.generic);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("GSEA")) {
            this.params.setMethod("GSEA");
        } else if (analysisType.equalsIgnoreCase("generic")) {
            this.params.setMethod("generic");
        }
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "Bulk Enrichment Map Input Panel";
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == BulkEMCreationPanel.this.pvalueTextField) {
                Number value = (Number)BulkEMCreationPanel.this.pvalueTextField.getValue();
                if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                    BulkEMCreationPanel.this.params.setPvalue(value.doubleValue());
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getPvalue());
                    message = message + "The pvalue cutoff must be greater than or equal 0 and less than or equal to 1.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.qvalueTextField) {
                Number value = (Number)BulkEMCreationPanel.this.qvalueTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0) {
                    BulkEMCreationPanel.this.params.setQvalue(value.doubleValue());
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getQvalue());
                    message = message + "The FDR q-value cutoff must be between 0 and 100.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.coeffecientTextField) {
                Number value = (Number)BulkEMCreationPanel.this.coeffecientTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    BulkEMCreationPanel.this.params.setSimilarityCutOff(value.doubleValue());
                    BulkEMCreationPanel.this.similarityCutOffChanged = true;
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getSimilarityCutOff());
                    message = message + "The Overlap/Jaccard Coeffecient cutoff must be between 0 and 1.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.lowerLimitField) {
                Number value = (Number)BulkEMCreationPanel.this.lowerLimitField.getValue();
                if (value != null && value.intValue() >= 0) {
                    BulkEMCreationPanel.this.params.setLowerlimit(value.intValue());
                } else {
                    source.setValue("1");
                    message = message + "The lower limit must be greater than 0.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.upperLimitField) {
                Number value = (Number)BulkEMCreationPanel.this.upperLimitField.getValue();
                if (value != null && value.intValue() >= 0) {
                    BulkEMCreationPanel.this.params.setUpperlimit(value.intValue());
                } else {
                    source.setValue("1");
                    message = message + "The upper limit must be greater than 0.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.GSEAResultsDirTextField) {
                String value = BulkEMCreationPanel.this.GSEAResultsDirTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGSEAResultsDirName(value);
                } else if (!BulkEMCreationPanel.this.GSEAResultsDirTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(BulkEMCreationPanel.this.application.getJFrame(), message, "File name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GSEAResultsDirTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.getFiles().get("Dataset 1").setGMTFileName(value);
                    }
                }
            } else if (source == BulkEMCreationPanel.this.GMTDirectoryTextField) {
                String value = BulkEMCreationPanel.this.GMTDirectoryTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGMTDirName(value);
                } else if (!BulkEMCreationPanel.this.GMTDirectoryTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(BulkEMCreationPanel.this.application.getJFrame(), message, "Directory name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GMTDirectoryTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.getFiles().get("Dataset 1").setGMTFileName(value);
                    }
                }
            } else if (source == BulkEMCreationPanel.this.GCTDirectoryTextField) {
                String value = BulkEMCreationPanel.this.GCTDirectoryTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGCTDirName(value);
                } else if (!BulkEMCreationPanel.this.GCTDirectoryTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(BulkEMCreationPanel.this.application.getJFrame(), message, "Directory name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GCTDirectoryTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.getFiles().get("Dataset 1").setGMTFileName(value);
                    }
                }
            }
            if (invalid) {
                JOptionPane.showMessageDialog(BulkEMCreationPanel.this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

