/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class NetworkUtil {
    private NetworkUtil() {
    }

    public static CyNode getNodeWithValue(CyNetwork net, CyTable table, String colname, String value) {
        return NetworkUtil.getObjectWithValue(net, table, colname, value, new NetworkGetter<CyNode>(){

            @Override
            public CyNode get(CyNetwork network, Long suid) {
                return network.getNode(suid.longValue());
            }
        });
    }

    public static CyEdge getEdgeWithValue(CyNetwork net, CyTable table, String colname, String value) {
        return NetworkUtil.getObjectWithValue(net, table, colname, value, new NetworkGetter<CyEdge>(){

            @Override
            public CyEdge get(CyNetwork network, Long suid) {
                return network.getEdge(suid.longValue());
            }
        });
    }

    private static <T> T getObjectWithValue(CyNetwork net, CyTable table, String colname, String value, NetworkGetter<T> getter) {
        T nodeOrEdge = null;
        Collection matchingRows = table.getMatchingRows(colname, (Object)value);
        for (CyRow row : matchingRows) {
            Long id = (Long)row.get("SUID", Long.class);
            if (id == null) continue;
            T currentNodeOrEdge = getter.get(net, id);
            if (nodeOrEdge == null) {
                nodeOrEdge = currentNodeOrEdge;
                continue;
            }
            if (currentNodeOrEdge == null) continue;
            return null;
        }
        return nodeOrEdge;
    }

    public static List<Long> keys(Collection<? extends CyIdentifiable> nodesOrEdges) {
        ArrayList<Long> keys = new ArrayList<Long>(nodesOrEdges.size());
        for (CyIdentifiable cyIdentifiable : nodesOrEdges) {
            keys.add(cyIdentifiable.getSUID());
        }
        return keys;
    }

    private static interface NetworkGetter<T> {
        public T get(CyNetwork var1, Long var2);
    }
}

