/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.awt.Color;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CreatePublicationVisualStyleTask
extends AbstractTask {
    private static final String SUFFIX = "_publication";
    private final CyApplicationManager applicationManager;
    private final VisualMappingManager visualMappingManager;
    private final VisualStyleFactory visualStyleFactory;
    private final CyEventHelper eventHelper;

    public CreatePublicationVisualStyleTask(CyApplicationManager applicationManager, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, CyEventHelper eventHelper) {
        this.applicationManager = applicationManager;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.eventHelper = eventHelper;
    }

    private VisualStyle attemptToGetExistingStyle(String vs_name) {
        for (VisualStyle vs : this.visualMappingManager.getAllVisualStyles()) {
            if (vs.getTitle() == null || !vs.getTitle().equals(vs_name)) continue;
            return vs;
        }
        return null;
    }

    public void run(TaskMonitor taskMonitor) {
        String title;
        taskMonitor.setTitle("EnrichmentMap");
        taskMonitor.setStatusMessage("Create Publication-Ready Visual Style");
        VisualStyle currentStyle = this.visualMappingManager.getCurrentVisualStyle();
        if (currentStyle == null) {
            return;
        }
        String currentTitle = currentStyle.getTitle();
        if (currentTitle.endsWith(SUFFIX)) {
            title = currentTitle.substring(0, currentTitle.length() - SUFFIX.length());
            VisualStyle existingStyle = this.attemptToGetExistingStyle(title);
            if (existingStyle != null) {
                this.visualMappingManager.setCurrentVisualStyle(existingStyle);
            }
        } else {
            title = currentTitle + SUFFIX;
            VisualStyle visualStyle = this.attemptToGetExistingStyle(title);
            if (visualStyle == null) {
                visualStyle = this.visualStyleFactory.createVisualStyle(currentStyle);
                visualStyle.setTitle(title);
                visualStyle.removeVisualMappingFunction(BasicVisualLexicon.NODE_LABEL);
                visualStyle.setDefaultValue(BasicVisualLexicon.NODE_LABEL, (Object)"");
                visualStyle.removeVisualMappingFunction(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT);
                visualStyle.setDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)Color.WHITE);
                this.visualMappingManager.addVisualStyle(visualStyle);
            }
            this.visualMappingManager.setCurrentVisualStyle(visualStyle);
        }
        this.eventHelper.flushPayloadEvents();
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        view.updateView();
    }
}

