/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.io.File;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.EnrichmentMapBuildMapTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.util.ListSingleSelection;

public class BuildEnrichmentMapTuneableTask
extends AbstractTask {
    private EnrichmentMap map;
    private EnrichmentMapParameters params;
    private DataSetFiles dataset1files = new DataSetFiles();
    private DataSetFiles dataset2files = new DataSetFiles();
    @Tunable(description="Analysis Type", groups={"Analysis Type"}, gravity=1.0)
    public ListSingleSelection<String> analysisType;
    @Tunable(description="GMT", groups={"User Input", "Gene Sets"}, gravity=2.0, dependsOn="analysisType=generic", params="fileCategory=table;input=true", tooltip="File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...")
    public File gmtFile;
    @Tunable(description="Expression", groups={"User Input", "Datasets", "Dataset 1"}, gravity=3.0, params="fileCategory=table;input=true", tooltip="File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...")
    public File expressionDataset1;
    @Tunable(description="Enrichments", groups={"User Input", "Datasets", "Dataset 1"}, gravity=4.0, dependsOn="analysisType=generic", params="fileCategory=table;input=true", tooltip="File specifying enrichment results.\n")
    public File enrichmentsDataset1;
    @Tunable(description="Enrichments 2", groups={"User Input", "Datasets", "Dataset 1"}, gravity=5.0, dependsOn="analysisType=GSEA", params="fileCategory=table;input=true", tooltip="File specifying enrichment results.\n")
    public File enrichments2Dataset1;
    @Tunable(description="Ranks", groups={"User Input", "Datasets", "Dataset 1", "Advanced"}, gravity=6.0, params="fileCategory=table;input=true", tooltip="File specifying ranked genes.\nFormat: gene <tab> score or statistic")
    public File ranksDataset1;
    @Tunable(description="Classes", groups={"User Input", "Datasets", "Dataset 1", "Advanced"}, gravity=7.0, params="fileCategory=table;input=true", tooltip="File specifying the classes of each sample in expression file.\nformat: see GSEA website")
    public File classDataset1;
    @Tunable(description="Phenotype1", groups={"User Input", "Datasets", "Dataset 1", "Advanced"}, gravity=8.0, tooltip="Dataset1 phenotype/class")
    public String phenotype1Dataset1;
    @Tunable(description="Phenotype2", groups={"User Input", "Datasets", "Dataset 1", "Advanced"}, gravity=9.0, tooltip="Dataset1 phenotype/class")
    public String phenotype2Dataset1;
    @Tunable(description="Expression", groups={"User Input", "Datasets", "Dataset 2"}, gravity=10.0, params="fileCategory=table;input=true;displayState=callapsed", tooltip="File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...")
    public File expressionDataset2;
    @Tunable(description="Enrichments", groups={"User Input", "Datasets", "Dataset 2"}, gravity=11.0, dependsOn="analysisType=generic", params="fileCategory=table;input=true;displayState=callapsed", tooltip="File specifying enrichment results.\n")
    public File enrichmentsDataset2;
    @Tunable(description="Enrichments 2", groups={"User Input", "Datasets", "Dataset 2"}, gravity=12.0, dependsOn="analysisType=GSEA", params="fileCategory=table;input=true;displayState=callapsed", tooltip="File specifying enrichment results.\n")
    public File enrichments2Dataset2;
    @Tunable(description="Ranks", groups={"User Input", "Datasets", "Dataset 2", "Advanced"}, gravity=13.0, params="fileCategory=table;input=true;displayState=callapsed", tooltip="File specifying ranked genes.\nFormat: gene <tab> score or statistic")
    public File ranksDataset2;
    @Tunable(description="Classes", groups={"User Input", "Datasets", "Dataset 2", "Advanced"}, gravity=14.0, params="fileCategory=table;input=true;displayState=callapsed", tooltip="File specifying the classes of each sample in expression file.\nformat: see GSEA website")
    public File classDataset2;
    @Tunable(description="Phenotype1", groups={"User Input", "Datasets", "Dataset 2", "Advanced"}, gravity=15.0, params="displayState=callapsed", tooltip="Dataset2 phenotype/class")
    public String phenotype1Dataset2;
    @Tunable(description="Phenotype2", groups={"User Input", "Datasets", "Dataset 2", "Advanced"}, gravity=16.0, params="displayState=callapsed", tooltip="Dataset2 phenotype/class")
    public String phenotype2Dataset2;
    @Tunable(description="P-value Cutoff", groups={"User Input", "Parameters"}, gravity=17.0, tooltip="P-value between 0 and 1.")
    public Double pvalue = 0.005;
    @Tunable(description="FDR Q-value Cutoff", groups={"User Input", "Parameters"}, gravity=18.0, tooltip="FDR Q-value between 0 and 1.")
    public Double qvalue = 0.1;
    @Tunable(description="Similarity Cutoff", groups={"User Input", "Parameters"}, gravity=19.0, tooltip="coeffecient between 0 and 1.")
    public Double similaritycutoff = 0.25;
    @Tunable(description="Similarity Coeffecient", groups={"User Input", "Parameters"}, gravity=20.0, tooltip="coeffecient between 0 and 1.")
    public ListSingleSelection<String> coeffecients;
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private CyApplicationManager applicationManager;
    private CySwingApplication swingApplication;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager networkViewManager;
    private CyNetworkViewFactory networkViewFactory;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private VisualMappingManager visualMappingManager;
    private VisualStyleFactory visualStyleFactory;
    private VisualMappingFunctionFactory vmfFactoryContinuous;
    private VisualMappingFunctionFactory vmfFactoryDiscrete;
    private VisualMappingFunctionFactory vmfFactoryPassthrough;
    private CyLayoutAlgorithmManager layoutManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;
    private DialogTaskManager dialog;

    public BuildEnrichmentMapTuneableTask(CySessionManager sessionManager, StreamUtil streamUtil, CyApplicationManager applicationManager, CySwingApplication swingApplication, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyNetworkViewFactory networkViewFactory, CyNetworkFactory networkFactory, CyTableFactory tableFactory, CyTableManager tableManager, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough, CyLayoutAlgorithmManager layoutManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable, DialogTaskManager dialog) {
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.applicationManager = applicationManager;
        this.swingApplication = swingApplication;
        this.networkManager = networkManager;
        this.networkViewManager = networkViewManager;
        this.networkViewFactory = networkViewFactory;
        this.networkFactory = networkFactory;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.layoutManager = layoutManager;
        this.mapTableToNetworkTable = mapTableToNetworkTable;
        this.dialog = dialog;
        this.analysisType = new ListSingleSelection((Object[])new String[]{"GSEA", "generic", "DAVID/BiNGO/Great"});
        this.coeffecients = new ListSingleSelection((Object[])new String[]{"OVERLAP", "JACCARD", "COMBINED"});
    }

    public void buildEnrichmentMap() {
        EnrichmentMapParameters new_params = new EnrichmentMapParameters(this.sessionManager, this.streamUtil, this.applicationManager);
        if (this.analysisType.getSelectedValue() == "DAVID/BiNGO/Great") {
            new_params.setMethod("DAVID/BiNGO/Great");
        }
        if (this.analysisType.getSelectedValue() == "GSEA") {
            new_params.setMethod("GSEA");
        }
        if (this.analysisType.getSelectedValue() == "generic") {
            new_params.setMethod("generic");
        }
        if (this.gmtFile != null) {
            this.dataset1files.setGMTFileName(this.gmtFile.getAbsolutePath());
        }
        if (this.expressionDataset1 != null) {
            this.dataset1files.setExpressionFileName(this.expressionDataset1.getAbsolutePath());
        }
        if (this.enrichmentsDataset1 != null) {
            this.dataset1files.setEnrichmentFileName1(this.enrichmentsDataset1.getAbsolutePath());
        }
        if (this.enrichments2Dataset1 != null) {
            this.dataset1files.setEnrichmentFileName2(this.enrichments2Dataset1.getAbsolutePath());
        }
        if (this.ranksDataset1 != null) {
            this.dataset1files.setRankedFile(this.ranksDataset1.getAbsolutePath());
        }
        if (this.classDataset1 != null) {
            this.dataset1files.setClassFile(this.classDataset1.getAbsolutePath());
        }
        if (this.phenotype1Dataset1 != null) {
            this.dataset1files.setPhenotype1(this.phenotype1Dataset1);
        }
        if (this.phenotype2Dataset1 != null) {
            this.dataset1files.setPhenotype2(this.phenotype2Dataset1);
        }
        new_params.addFiles("Dataset 1", this.dataset1files);
        new_params.setPvalue(this.pvalue);
        new_params.setQvalue(this.qvalue);
        new_params.setSimilarityCutOff(this.similaritycutoff);
        if (this.coeffecients.getSelectedValue() == "JACCARD") {
            new_params.setSimilarityMetric("JACCARD");
        }
        if (this.coeffecients.getSelectedValue() == "OVERLAP") {
            new_params.setSimilarityMetric("OVERLAP");
        }
        if (this.coeffecients.getSelectedValue() == "COMBINED") {
            new_params.setSimilarityMetric("COMBINED");
        }
        if (this.expressionDataset2 != null) {
            this.dataset2files.setExpressionFileName(this.expressionDataset2.getAbsolutePath());
        }
        if (this.enrichmentsDataset2 != null) {
            this.dataset2files.setEnrichmentFileName1(this.enrichmentsDataset2.getAbsolutePath());
        }
        if (this.enrichments2Dataset2 != null) {
            this.dataset2files.setEnrichmentFileName2(this.enrichments2Dataset2.getAbsolutePath());
        }
        if (this.ranksDataset2 != null) {
            this.dataset2files.setRankedFile(this.ranksDataset2.getAbsolutePath());
        }
        if (this.classDataset2 != null) {
            this.dataset2files.setClassFile(this.classDataset2.getAbsolutePath());
        }
        if (this.phenotype1Dataset2 != null) {
            this.dataset2files.setPhenotype1(this.phenotype1Dataset2);
        }
        if (this.phenotype2Dataset2 != null) {
            this.dataset2files.setPhenotype2(this.phenotype2Dataset2);
        }
        if (!this.dataset2files.isEmpty()) {
            new_params.addFiles("Dataset 2", this.dataset2files);
        }
        EnrichmentMap map = new EnrichmentMap(new_params);
        EnrichmentMapBuildMapTaskFactory buildmap = new EnrichmentMapBuildMapTaskFactory(map, this.applicationManager, this.swingApplication, this.networkManager, this.networkViewManager, this.networkViewFactory, this.networkFactory, this.tableFactory, this.tableManager, this.visualMappingManager, this.visualStyleFactory, this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough, this.dialog, this.streamUtil, this.layoutManager, this.mapTableToNetworkTable);
        this.insertTasksAfterCurrentTask(buildmap.createTaskIterator());
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        manager.registerServices();
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public String getTitle() {
        return new String("Enrichment Map Tuneable build");
    }

    public boolean isReady() {
        return true;
    }

    public void run(TaskMonitor arg0) throws Exception {
        this.buildEnrichmentMap();
    }
}

