/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;

public class BuildDiseaseSignatureTaskResult {
    private final Set<CyEdge> existingEdgesFailingCutoff;
    private final Set<CyEdge> newEdges;
    private final Set<CyNode> newNodes;
    private final CyNetwork network;
    private final CyNetworkView networkView;
    private final int passedCutoffCount;
    private final boolean cancelled;

    private BuildDiseaseSignatureTaskResult(Builder builder) {
        this.existingEdgesFailingCutoff = builder.existingEdgesFailingCutoff;
        this.newEdges = builder.newEdges;
        this.newNodes = builder.newNodes;
        this.network = builder.network;
        this.networkView = builder.networkView;
        this.passedCutoffCount = builder.passedCutoffCount;
        this.cancelled = builder.cancelled;
    }

    public Set<CyEdge> getExistingEdgesFailingCutoff() {
        return Collections.unmodifiableSet(this.existingEdgesFailingCutoff);
    }

    public Set<CyEdge> getNewEdges() {
        return Collections.unmodifiableSet(this.newEdges);
    }

    public Set<CyNode> getNewNodes() {
        return Collections.unmodifiableSet(this.newNodes);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public int getPassedCutoffCount() {
        return this.passedCutoffCount;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static class Builder {
        private Set<CyEdge> existingEdgesFailingCutoff = new HashSet<CyEdge>();
        private Set<CyEdge> newEdges = new HashSet<CyEdge>();
        private Set<CyNode> newNodes = new HashSet<CyNode>();
        private CyNetwork network;
        private CyNetworkView networkView;
        private int passedCutoffCount = 0;
        private boolean cancelled = false;
        private BuildDiseaseSignatureTaskResult result = null;

        public void addExistingEdgeFailsCutoff(CyEdge edge) {
            if (edge != null) {
                this.existingEdgesFailingCutoff.add(edge);
            }
        }

        public void addNewEdge(CyEdge edge) {
            if (edge != null) {
                this.newEdges.add(edge);
            }
        }

        public void addNewNode(CyNode node) {
            if (node != null) {
                this.newNodes.add(node);
            }
        }

        public void incrementPassedCutoffCount() {
            ++this.passedCutoffCount;
        }

        public void setNetwork(CyNetwork network) {
            this.network = network;
        }

        public void setNetworkView(CyNetworkView networkView) {
            this.networkView = networkView;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public BuildDiseaseSignatureTaskResult build() {
            if (this.result == null) {
                this.result = new BuildDiseaseSignatureTaskResult(this);
            }
            return this.result;
        }
    }
}

