/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.action.AnnotateButtonActionListener;
import org.baderlab.csplugins.enrichmentmap.autoannotate.action.ClusterTableSelctionAction;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.ClusterTableModel;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.RemoveAnnotationTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.UpdateAnnotationTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.VisualizeClusterAnnotationTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DeleteClusterTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.ExtractClusterTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.MergeClustersTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.UpdateClusterLabelTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.DisplayOptionsPanel;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class AutoAnnotationPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 7901088595186775935L;
    private static final String defaultButtonString = "Use clusterMaker defaults";
    private static final String specifyColumnButtonString = "Select cluster column";
    private JComboBox<String> nameColumnDropdown;
    private JComboBox<String> clusterColumnDropdown;
    private JComboBox<String> clusterAlgorithmDropdown;
    private ButtonGroup clusterButtonGroup;
    private JRadioButton defaultButton;
    private JRadioButton specifyColumnButton;
    private JLabel networkLabel;
    private HashMap<CyNetworkView, JComboBox<AnnotationSet>> networkViewToClusterSetDropdown = new HashMap();
    private JPanel outputPanel;
    private JPanel bottomButtonPanel;
    private CyNetworkView selectedView;
    private CyNetwork selectedNetwork;
    private EnrichmentMapManager emManager;
    private AutoAnnotationManager autoAnnotationManager;
    private AutoAnnotationParameters params;
    private JCheckBox layoutCheckBox;
    private JCheckBox groupsCheckBox;
    private DisplayOptionsPanel displayOptionsPanel;
    private boolean selecting = false;
    private boolean annotating = false;

    public AutoAnnotationPanel(CySwingApplication application, DisplayOptionsPanel displayOptionsPanel) {
        this.displayOptionsPanel = displayOptionsPanel;
        this.emManager = EnrichmentMapManager.getInstance();
        this.autoAnnotationManager = AutoAnnotationManager.getInstance();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 500));
        JPanel inputPanel = this.createInputPanel();
        this.bottomButtonPanel = this.createBottomButtonPanel();
        this.bottomButtonPanel.setAlignmentX(0.0f);
        this.outputPanel = this.createOutputPanel();
        JScrollPane clusterTableScrollPane = new JScrollPane(this.outputPanel);
        this.add((Component)inputPanel, "North");
        this.add((Component)clusterTableScrollPane, "Center");
        this.add((Component)this.bottomButtonPanel, "South");
    }

    private JPanel createInputPanel() {
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        this.networkLabel = new JLabel("No network selected");
        Font font = this.networkLabel.getFont();
        this.networkLabel.setFont(new Font(font.getFamily(), font.getStyle(), 18));
        JLabel nameColumnDropdownLabel = new JLabel("   Select the column with the gene set descriptions:");
        this.nameColumnDropdown = new JComboBox();
        BasicCollapsiblePanel advancedOptionsPanel = this.createAdvancedOptionsPanel();
        JButton annotateButton = new JButton("Annotate!");
        AnnotateButtonActionListener annotateAction = new AnnotateButtonActionListener(this);
        annotateButton.addActionListener(annotateAction);
        annotateButton.setToolTipText("Create a new annotation set");
        inputPanel.add(this.networkLabel);
        inputPanel.add(nameColumnDropdownLabel);
        inputPanel.add(this.nameColumnDropdown);
        inputPanel.add((Component)advancedOptionsPanel);
        inputPanel.add(annotateButton);
        this.networkLabel.setAlignmentX(0.5f);
        nameColumnDropdownLabel.setAlignmentX(0.5f);
        this.nameColumnDropdown.setAlignmentX(0.5f);
        advancedOptionsPanel.setAlignmentX(0.5f);
        annotateButton.setAlignmentX(0.5f);
        return inputPanel;
    }

    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel(new BorderLayout());
        JButton extractButton = new JButton("Extract");
        ActionListener extractActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                ExtractClusterTask extract = new ExtractClusterTask(annotationSet);
                AutoAnnotationPanel.this.autoAnnotationManager.getDialogTaskManager().execute(new TaskIterator(new Task[]{extract}));
            }
        };
        extractButton.addActionListener(extractActionListener);
        extractButton.setToolTipText("Create a new cluster");
        JButton mergeButton = new JButton("Merge");
        ActionListener mergeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                MergeClustersTask merge = new MergeClustersTask(annotationSet);
                AutoAnnotationPanel.this.autoAnnotationManager.getDialogTaskManager().execute(new TaskIterator(new Task[]{merge}));
            }
        };
        mergeButton.addActionListener(mergeActionListener);
        mergeButton.setToolTipText("Merge clusters into one");
        ActionListener deletActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new TaskIterator(new Task[]{new DeleteClusterTask(AutoAnnotationPanel.this.params)}));
            }
        };
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(deletActionListener);
        deleteButton.setToolTipText("Delete selected cluster(s)");
        JPanel outputButtonPanel = new JPanel();
        outputButtonPanel.add(new JLabel("Clusters:"));
        outputButtonPanel.add(extractButton);
        outputButtonPanel.add(mergeButton);
        outputButtonPanel.add(deleteButton);
        JPanel outputBottomPanel = new JPanel();
        outputBottomPanel.setLayout(new BoxLayout(outputBottomPanel, 3));
        outputBottomPanel.add(outputButtonPanel);
        outputPanel.add((Component)outputBottomPanel, "South");
        return outputPanel;
    }

    private JPanel createBottomButtonPanel() {
        JPanel bottomButtonPanel = new JPanel();
        JButton removeButton = new JButton("Remove");
        ActionListener clearActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirmation = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove this annotation set? This cannot be undone.", "Remove confirmation", 0);
                if (confirmation == 0) {
                    JComboBox clusterSetDropdown = (JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView);
                    AnnotationSet annotationSet = (AnnotationSet)clusterSetDropdown.getSelectedItem();
                    AutoAnnotationPanel.this.remove(annotationSet.getClusterTable().getParent());
                    RemoveAnnotationTask remove = new RemoveAnnotationTask(AutoAnnotationPanel.this.params);
                    AutoAnnotationPanel.this.autoAnnotationManager.getDialogTaskManager().execute(new TaskIterator(new Task[]{remove}));
                    clusterSetDropdown.removeItem(annotationSet);
                }
            }
        };
        removeButton.addActionListener(clearActionListener);
        removeButton.setToolTipText("Remove Annotation Set");
        JButton updateButton = new JButton("Update");
        ActionListener updateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationSet annotationSet = (AnnotationSet)((JComboBox)AutoAnnotationPanel.this.networkViewToClusterSetDropdown.get(AutoAnnotationPanel.this.selectedView)).getSelectedItem();
                UpdateAnnotationTask update = new UpdateAnnotationTask(annotationSet);
                AutoAnnotationPanel.this.autoAnnotationManager.getDialogTaskManager().execute(new TaskIterator(new Task[]{update}));
            }
        };
        updateButton.addActionListener(updateActionListener);
        updateButton.setToolTipText("Update Annotation Set");
        bottomButtonPanel = new JPanel();
        bottomButtonPanel.add(new JLabel("Annotation Sets:"));
        bottomButtonPanel.add(removeButton);
        bottomButtonPanel.add(updateButton);
        return bottomButtonPanel;
    }

    private BasicCollapsiblePanel createAdvancedOptionsPanel() {
        BasicCollapsiblePanel optionsPanel = new BasicCollapsiblePanel("Advanced Options");
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.defaultButton = new JRadioButton(defaultButtonString);
        this.specifyColumnButton = new JRadioButton(specifyColumnButtonString);
        this.defaultButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AutoAnnotationPanel.this.clusterAlgorithmDropdown.setVisible(true);
                    AutoAnnotationPanel.this.clusterColumnDropdown.setVisible(false);
                } else if (e.getStateChange() == 2) {
                    AutoAnnotationPanel.this.clusterAlgorithmDropdown.setVisible(false);
                    AutoAnnotationPanel.this.clusterColumnDropdown.setVisible(true);
                }
            }
        });
        this.clusterButtonGroup = new ButtonGroup();
        this.clusterButtonGroup.add(this.defaultButton);
        this.clusterButtonGroup.add(this.specifyColumnButton);
        JPanel clusterButtonPanel = new JPanel();
        clusterButtonPanel.setLayout(new BoxLayout(clusterButtonPanel, 3));
        clusterButtonPanel.add(this.defaultButton);
        clusterButtonPanel.add(this.specifyColumnButton);
        DefaultComboBoxModel<String> clusterDropdownModel = new DefaultComboBoxModel<String>();
        for (String algorithm : this.autoAnnotationManager.getAlgorithmToColumnName().keySet()) {
            clusterDropdownModel.addElement(algorithm);
        }
        this.clusterAlgorithmDropdown = new JComboBox(clusterDropdownModel);
        this.clusterAlgorithmDropdown.setPreferredSize(new Dimension(135, 30));
        this.clusterColumnDropdown = new JComboBox();
        this.clusterColumnDropdown.setPreferredSize(new Dimension(135, 30));
        this.clusterAlgorithmDropdown.setVisible(true);
        this.clusterColumnDropdown.setVisible(false);
        this.clusterAlgorithmDropdown.setSelectedItem("MCL Cluster");
        JPanel dropdownPanel = new JPanel();
        dropdownPanel.add(this.clusterAlgorithmDropdown);
        dropdownPanel.add(this.clusterColumnDropdown);
        this.defaultButton.setSelected(true);
        this.layoutCheckBox = new JCheckBox("Layout nodes by cluster");
        this.layoutCheckBox.setSelected(false);
        this.groupsCheckBox = new JCheckBox("Create Groups for clusters");
        this.groupsCheckBox.setSelected(false);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 1));
        checkBoxPanel.add(this.layoutCheckBox);
        checkBoxPanel.add(this.groupsCheckBox);
        JPanel nonClusterOptionPanel = new JPanel();
        nonClusterOptionPanel.add(checkBoxPanel);
        JPanel clusterOptionPanel = new JPanel(new BorderLayout());
        clusterOptionPanel.setBorder(BorderFactory.createTitledBorder("ClusterMaker Options"));
        clusterOptionPanel.add((Component)clusterButtonPanel, "West");
        clusterOptionPanel.add((Component)dropdownPanel, "East");
        innerPanel.add((Component)clusterOptionPanel, "North");
        innerPanel.add((Component)nonClusterOptionPanel, "South");
        optionsPanel.add((Component)innerPanel);
        return optionsPanel;
    }

    private JTable createClusterTable(AnnotationSet annotationSet) {
        Object[][] data = new Object[annotationSet.getClusterMap().size()][2];
        int i = 0;
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            data[i][0] = cluster;
            data[i][1] = cluster.getSize();
            ++i;
        }
        String[] columnNames = new String[]{"Cluster", "Number of nodes"};
        ClusterTableModel model = new ClusterTableModel(columnNames, data, annotationSet.getClusterMap());
        JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(320, 250));
        table.getColumnModel().getColumn(0).setPreferredWidth(210);
        table.getColumnModel().getColumn(1).setPreferredWidth(100);
        annotationSet.setClusterTable(table);
        table.getSelectionModel().addListSelectionListener(new ClusterTableSelctionAction(annotationSet));
        table.getSelectionModel().setSelectionMode(2);
        table.setAutoCreateRowSorter(true);
        return table;
    }

    public void addClusters(AnnotationSet annotationSet, AutoAnnotationParameters params) {
        params.addAnnotationSet(annotationSet);
        CyNetworkView clusterView = params.getNetworkView();
        if (!this.networkViewToClusterSetDropdown.containsKey(clusterView)) {
            this.addNetworkView(clusterView);
        }
        JTable clusterTable = this.createClusterTable(annotationSet);
        JScrollPane clusterTableScroll = new JScrollPane(clusterTable);
        clusterTableScroll.setHorizontalScrollBarPolicy(30);
        this.outputPanel.add((Component)clusterTableScroll, "Center");
        annotationSet.setClusterTable(clusterTable);
        JComboBox<AnnotationSet> clusterSetDropdown = this.networkViewToClusterSetDropdown.get(clusterView);
        clusterSetDropdown.addItem(annotationSet);
        clusterSetDropdown.setSelectedIndex(clusterSetDropdown.getItemCount() - 1);
    }

    private void addNetworkView(CyNetworkView view) {
        JComboBox annotationSetDropdown = new JComboBox();
        annotationSetDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CyGroupManager groupManager = AutoAnnotationPanel.this.autoAnnotationManager.getGroupManager();
                CyGroupFactory groupFactory = AutoAnnotationPanel.this.autoAnnotationManager.getGroupFactory();
                if (itemEvent.getStateChange() == 1) {
                    AnnotationSet annotationSet = (AnnotationSet)itemEvent.getItem();
                    AutoAnnotationPanel.this.params.setSelectedAnnotationSet(annotationSet);
                    AutoAnnotationPanel.this.displayOptionsPanel.setSelectedAnnotationSet();
                    annotationSet.updateCoordinates();
                    String annotationSetName = annotationSet.getName();
                    Long clusterTableSUID = (Long)AutoAnnotationPanel.this.selectedNetwork.getDefaultNetworkTable().getRow((Object)AutoAnnotationPanel.this.selectedNetwork.getSUID()).get(annotationSetName, Long.class);
                    CyTable clusterSetTable = AutoAnnotationPanel.this.autoAnnotationManager.getTableManager().getTable(clusterTableSUID.longValue());
                    TaskIterator currentTasks = new TaskIterator(new Task[0]);
                    for (Cluster cluster : annotationSet.getClusterMap().values()) {
                        if (cluster.getEllipse() == null && cluster.getTextAnnotation() == null) {
                            currentTasks.append((Task)new UpdateClusterLabelTask(cluster, clusterSetTable));
                        }
                        VisualizeClusterAnnotationTaskFactory visualizeCluster = new VisualizeClusterAnnotationTaskFactory(cluster);
                        currentTasks.append(visualizeCluster.createTaskIterator());
                    }
                    AutoAnnotationManager.getInstance().getDialogTaskManager().execute(currentTasks);
                    AutoAnnotationPanel.this.setOutputVisibility(true);
                    annotationSet.getClusterTable().getParent().getParent().setVisible(true);
                    AutoAnnotationPanel.this.updateUI();
                } else if (itemEvent.getStateChange() == 2) {
                    AnnotationSet clusters = (AnnotationSet)itemEvent.getItem();
                    for (Cluster cluster : clusters.getClusterMap().values()) {
                        cluster.erase();
                        CyGroup group = cluster.getGroup();
                        if (group != null) {
                            if (cluster.isCollapsed()) {
                                cluster.getGroup().expand(AutoAnnotationPanel.this.selectedNetwork);
                            }
                            group.removeGroupFromNetwork(AutoAnnotationPanel.this.selectedNetwork);
                            groupManager.destroyGroup(group);
                            cluster.removeGroup();
                        }
                        clusters.getClusterTable().getParent().getParent().setVisible(false);
                    }
                    AutoAnnotationPanel.this.setOutputVisibility(false);
                    AutoAnnotationPanel.this.updateUI();
                }
            }
        });
        this.outputPanel.add(annotationSetDropdown, "North");
        this.networkViewToClusterSetDropdown.put(view, annotationSetDropdown);
        this.selectedView = view;
        this.selectedNetwork = this.autoAnnotationManager.getApplicationManager().getCurrentNetwork();
        this.params = this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(view);
        this.networkLabel.setText(this.selectedNetwork.toString());
        this.updateUI();
    }

    public void setOutputVisibility(boolean b) {
        this.outputPanel.getParent().getParent().setVisible(b);
        this.bottomButtonPanel.setVisible(b);
        if (b) {
            this.autoAnnotationManager.getDisplayOptionsPanelAction().actionPerformed(new ActionEvent("", 0, ""));
        } else {
            this.displayOptionsPanel.setVisible(b);
        }
    }

    public void updateSelectedView(CyNetworkView view) {
        this.selectedView = view;
        this.selectedNetwork = this.autoAnnotationManager.getApplicationManager().getCurrentNetwork();
        if (this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().containsKey(this.selectedView)) {
            this.params = this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(this.selectedView);
            if (!this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
                for (AnnotationSet annotationSet : this.params.getAnnotationSets().values()) {
                    this.addClusters(annotationSet, this.params);
                }
                if (this.params.getSelectedAnnotationSet() != null) {
                    this.networkViewToClusterSetDropdown.get(this.selectedView).setSelectedItem(this.params.getSelectedAnnotationSet());
                }
            }
            this.setOutputVisibility(true);
        } else {
            this.setOutputVisibility(false);
        }
        this.nameColumnDropdown.removeAllItems();
        this.clusterColumnDropdown.removeAllItems();
        for (CyColumn column : ((CyNetwork)view.getModel()).getDefaultNodeTable().getColumns()) {
            if (column.getType() == String.class) {
                this.nameColumnDropdown.addItem(column.getName());
                continue;
            }
            if (column.getType() == List.class && column.getListElementType() == String.class) {
                this.nameColumnDropdown.addItem(column.getName());
                continue;
            }
            if (column.getType() != Integer.class && (column.getType() != List.class || column.getListElementType() != Integer.class)) continue;
            this.clusterColumnDropdown.addItem(column.getName());
        }
        for (int i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
            if (this.nameColumnDropdown.getItemAt(i).getClass() != String.class || !this.nameColumnDropdown.getItemAt(i).contains("GS_DESCR")) continue;
            this.nameColumnDropdown.setSelectedIndex(i);
        }
        this.networkLabel.setText("  " + this.selectedNetwork.toString());
        this.updateUI();
        if (this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
            JComboBox<AnnotationSet> currentDropdown = this.networkViewToClusterSetDropdown.get(this.selectedView);
            currentDropdown.setVisible(false);
            this.getCurrentSelectedTable(this.selectedView).getParent().getParent().setVisible(false);
        }
        if (this.networkViewToClusterSetDropdown.containsKey(this.selectedView)) {
            this.networkViewToClusterSetDropdown.get(this.selectedView).setVisible(true);
            this.getCurrentSelectedTable(this.selectedView).getParent().getParent().setVisible(true);
        }
    }

    public JTable getClusterTable(AnnotationSet annotationSet) {
        return annotationSet.getClusterTable();
    }

    public void updateColumnName(CyTable source, String oldColumnName, String newColumnName) {
        if (source == this.selectedNetwork.getDefaultNodeTable()) {
            int i;
            for (i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
                if (this.nameColumnDropdown.getModel().getElementAt(i) != oldColumnName) continue;
                this.nameColumnDropdown.removeItem(oldColumnName);
                this.nameColumnDropdown.insertItemAt(newColumnName, i);
            }
            for (i = 0; i < this.clusterColumnDropdown.getItemCount(); ++i) {
                if (this.clusterColumnDropdown.getModel().getElementAt(i) != oldColumnName) continue;
                this.clusterColumnDropdown.removeItem(oldColumnName);
                this.clusterColumnDropdown.insertItemAt(newColumnName, i);
            }
        }
    }

    private JTable getCurrentSelectedTable(CyNetworkView view) {
        if (view != null && this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters() != null && this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().containsKey(view) && this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(view).getSelectedAnnotationSet() != null) {
            return this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(view).getSelectedAnnotationSet().getClusterTable();
        }
        return null;
    }

    public void removeNetworkView(CyNetworkView view) {
        if (this.networkViewToClusterSetDropdown.size() == 1 && this.networkViewToClusterSetDropdown.containsKey(view)) {
            this.networkLabel.setText("No network selected");
            this.nameColumnDropdown.removeAllItems();
            this.clusterColumnDropdown.removeAllItems();
            this.updateUI();
            if (this.networkViewToClusterSetDropdown.containsKey(view)) {
                JComboBox<AnnotationSet> clusterSetDropdown = this.networkViewToClusterSetDropdown.get(view);
                Container clusterTable = this.getCurrentSelectedTable(view).getParent().getParent();
                clusterSetDropdown.getParent().remove(clusterSetDropdown);
                clusterTable.getParent().remove(clusterTable);
                this.networkViewToClusterSetDropdown.remove(view);
            }
            this.selectedView = null;
            this.selectedNetwork = null;
            this.params = null;
        }
    }

    public void columnDeleted(CyTable source, String columnName) {
        if (source == this.selectedNetwork.getDefaultNodeTable()) {
            int i;
            for (i = 0; i < this.nameColumnDropdown.getItemCount(); ++i) {
                if (this.nameColumnDropdown.getModel().getElementAt(i) != columnName) continue;
                this.nameColumnDropdown.removeItem(columnName);
            }
            for (i = 0; i < this.clusterColumnDropdown.getItemCount(); ++i) {
                if (this.clusterColumnDropdown.getModel().getElementAt(i) != columnName) continue;
                this.clusterColumnDropdown.removeItem(columnName);
            }
        }
    }

    public void columnCreated(CyTable source, String columnName) {
        CyTable nodeTable = this.selectedNetwork.getDefaultNodeTable();
        if (source == nodeTable) {
            CyColumn column = nodeTable.getColumn(columnName);
            if (column.getType() == String.class) {
                if (((DefaultComboBoxModel)this.nameColumnDropdown.getModel()).getIndexOf(column) == -1) {
                    this.nameColumnDropdown.addItem(column.getName());
                }
            } else if ((column.getType() == Integer.class || column.getType() == List.class && column.getListElementType() == Integer.class) && ((DefaultComboBoxModel)this.clusterColumnDropdown.getModel()).getIndexOf(column) == -1) {
                this.clusterColumnDropdown.addItem(column.getName());
            }
        }
    }

    public void setHeatMapNoSort() {
        try {
            HeatMapParameters heatMapParameters = this.emManager.getMap(this.selectedNetwork.getSUID()).getParams().getHmParams();
            if (heatMapParameters != null) {
                heatMapParameters.setSort(HeatMapParameters.Sort.NONE);
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public void setDisableHeatMapAutoFocus(boolean b) {
        try {
            this.emManager.getMap(this.selectedNetwork.getSUID()).getParams().setDisableHeatmapAutofocus(b);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Annotation Panel";
    }

    public AnnotationSet getSelectedAnnotationSet() {
        return this.params.getSelectedAnnotationSet();
    }

    public void setDisplayOptionsPanel(DisplayOptionsPanel displayOptionsPanel) {
        this.displayOptionsPanel = displayOptionsPanel;
    }

    public void setAnnotating(boolean b) {
        this.annotating = b;
    }

    public CyNetworkView getCurrentView() {
        return this.selectedView;
    }

    public boolean isLayoutNodeSelected() {
        return this.layoutCheckBox.isSelected();
    }

    public boolean isGroupsSelected() {
        return this.groupsCheckBox.isSelected();
    }

    public boolean isClusterMaker() {
        return this.defaultButton.isSelected();
    }

    public String getAnnotationColumnName() {
        return (String)this.nameColumnDropdown.getSelectedItem();
    }

    public String getAlgorithm() {
        return (String)this.clusterAlgorithmDropdown.getSelectedItem();
    }

    public String getClusterColumnName(AutoAnnotationParameters currentParams) {
        if (this.isClusterMaker()) {
            String clusteringColumnName1 = (String)AutoAnnotationManager.algorithmToColumnName.get(this.getAlgorithm());
            CyTable defaultNodetable = this.autoAnnotationManager.getApplicationManager().getCurrentNetwork().getDefaultNodeTable();
            return currentParams.nextClusterColumnName(clusteringColumnName1, defaultNodetable);
        }
        return (String)this.clusterColumnDropdown.getSelectedItem();
    }

    public void updateParameters() {
        this.params = this.autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(this.selectedView);
    }
}

