/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import org.baderlab.csplugins.enrichmentmap.actions.EnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.action.DisplayOptionsPanelAction;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.AutoAnnotationPanel;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.DisplayOptionsPanel;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetSelectedNetworkViewsEvent;
import org.cytoscape.application.events.SetSelectedNetworkViewsListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class AutoAnnotationManager
implements SetSelectedNetworkViewsListener,
ColumnCreatedListener,
ColumnDeletedListener,
ColumnNameChangedListener,
NetworkViewAboutToBeDestroyedListener,
RowsSetListener {
    private static AutoAnnotationManager instance = null;
    private CySwingApplication application;
    private AutoAnnotationPanel annotationPanel;
    private DisplayOptionsPanelAction displayOptionsPanelAction;
    private HashMap<CyNetworkView, AutoAnnotationParameters> networkViewToAutoAnnotationParameters = new HashMap();
    public static final SortedMap<String, String> algorithmToColumnName;
    private CyTableManager tableManager;
    private CommandExecutorTaskFactory commandExecutor;
    private DialogTaskManager dialogTaskManager;
    private SynchronousTaskManager<?> syncTaskManager;
    private CyApplicationManager applicationManager;
    private AnnotationManager annotationManager;
    private CyLayoutAlgorithmManager layoutManager;
    private AnnotationFactory<ShapeAnnotation> shapeFactory;
    private AnnotationFactory<TextAnnotation> textFactory;
    private CyGroupFactory groupFactory;
    private CyGroupManager groupManager;
    private HeatMapPanel heatmapPanel;
    private EnrichmentMapActionListener EMActionListener;
    private CyEventHelper eventHelper;
    private DisplayOptionsPanel displayOptionsPanel;
    private boolean clusterTableUpdating = false;

    public static AutoAnnotationManager getInstance() {
        if (instance == null) {
            instance = new AutoAnnotationManager();
        }
        return instance;
    }

    public void initialize(CySwingApplication application, CyTableManager tableManager, CommandExecutorTaskFactory commandExecutor, DialogTaskManager dialogTaskManager, SynchronousTaskManager<?> syncTaskManager, AnnotationManager annotationManager, CyLayoutAlgorithmManager layoutManager, AnnotationFactory<ShapeAnnotation> shapeFactory, AnnotationFactory<TextAnnotation> textFactory, CyGroupFactory groupFactory, CyGroupManager groupManager, HeatMapPanel heatMapPanel_node, EnrichmentMapActionListener EMActionListener, CyEventHelper eventHelper, CyApplicationManager applicationManager) {
        this.application = application;
        this.tableManager = tableManager;
        this.commandExecutor = commandExecutor;
        this.dialogTaskManager = dialogTaskManager;
        this.syncTaskManager = syncTaskManager;
        this.annotationManager = annotationManager;
        this.layoutManager = layoutManager;
        this.shapeFactory = shapeFactory;
        this.textFactory = textFactory;
        this.groupFactory = groupFactory;
        this.groupManager = groupManager;
        this.heatmapPanel = heatMapPanel_node;
        this.EMActionListener = EMActionListener;
        this.eventHelper = eventHelper;
        this.applicationManager = applicationManager;
    }

    public void handleEvent(SetSelectedNetworkViewsEvent e) {
        if (this.annotationPanel != null) {
            this.annotationPanel.updateSelectedView((CyNetworkView)e.getNetworkViews().get(0));
        }
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        if (this.annotationPanel != null) {
            this.annotationPanel.updateColumnName((CyTable)e.getSource(), e.getOldColumnName(), e.getNewColumnName());
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        if (this.annotationPanel != null) {
            this.annotationPanel.columnDeleted((CyTable)e.getSource(), e.getColumnName());
        }
    }

    public void handleEvent(ColumnCreatedEvent e) {
        if (this.annotationPanel != null) {
            this.annotationPanel.columnCreated((CyTable)e.getSource(), e.getColumnName());
        }
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent e) {
        if (this.annotationPanel != null) {
            this.annotationPanel.removeNetworkView(e.getNetworkView());
        }
    }

    public void handleEvent(RowsSetEvent e) {
        if (this.annotationPanel != null && e.getColumnRecords("selected").size() > 0) {
            HashMap<CyNetworkView, AutoAnnotationParameters> annotations;
            CyNetwork network = this.applicationManager.getCurrentNetwork();
            CyNetworkView view = this.applicationManager.getCurrentNetworkView();
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
            if (AutoAnnotationManager.getInstance().getAnnotationPanel() != null && !AutoAnnotationManager.getInstance().isClusterTableUpdating() && e.getSource() == network.getDefaultNodeTable() && (annotations = AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters()).containsKey(view)) {
                AnnotationSet currentAnnotation = annotations.get(view).getSelectedAnnotationSet();
                TableModel clusterTableModel = currentAnnotation.getClusterTable().getModel();
                ListSelectionModel clusterListSelectionModel = currentAnnotation.getClusterTable().getSelectionModel();
                clusterListSelectionModel.setValueIsAdjusting(true);
                TreeMap<Integer, Cluster> clusters = currentAnnotation.getClusterMap();
                block0: for (Cluster cluster : clusters.values()) {
                    boolean select = true;
                    boolean unselectCluster = false;
                    for (CyNode node : cluster.getNodes()) {
                        if (!selectedNodes.contains(node) && cluster.isSelected()) {
                            unselectCluster = true;
                            break;
                        }
                        if (selectedNodes.contains(node)) continue;
                        select = false;
                        break;
                    }
                    if (select && cluster.isSelected()) {
                        select = false;
                    }
                    if (select) {
                        currentAnnotation.setManualSelection(true);
                        for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                            if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                            clusterListSelectionModel.addSelectionInterval(rowIndex, rowIndex);
                            break;
                        }
                    }
                    if (!unselectCluster) continue;
                    currentAnnotation.setManualSelection(true);
                    for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                        if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                        clusterListSelectionModel.removeSelectionInterval(rowIndex, rowIndex);
                        continue block0;
                    }
                }
                clusterListSelectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public HashMap<CyNetworkView, AutoAnnotationParameters> getNetworkViewToAutoAnnotationParameters() {
        return this.networkViewToAutoAnnotationParameters;
    }

    public void setNetworkViewToAutoAnnotation(HashMap<CyNetworkView, AutoAnnotationParameters> networkViewToAutoAnnotationParameters) {
        this.networkViewToAutoAnnotationParameters = networkViewToAutoAnnotationParameters;
    }

    public CySwingApplication getApplication() {
        return this.application;
    }

    public CyTableManager getTableManager() {
        return this.tableManager;
    }

    public CommandExecutorTaskFactory getCommandExecutor() {
        return this.commandExecutor;
    }

    public DialogTaskManager getDialogTaskManager() {
        return this.dialogTaskManager;
    }

    public SynchronousTaskManager<?> getSyncTaskManager() {
        return this.syncTaskManager;
    }

    public AutoAnnotationPanel getAnnotationPanel() {
        return this.annotationPanel;
    }

    public void setAnnotationPanel(AutoAnnotationPanel inputPanel) {
        this.annotationPanel = inputPanel;
    }

    public DisplayOptionsPanelAction getDisplayOptionsPanelAction() {
        return this.displayOptionsPanelAction;
    }

    public void setDisplayOptionsPanelAction(DisplayOptionsPanelAction displayOptionsPanelAction) {
        this.displayOptionsPanelAction = displayOptionsPanelAction;
    }

    public DisplayOptionsPanel getDisplayOptionsPanel() {
        return this.displayOptionsPanel;
    }

    public void setDisplayOptionsPanel(DisplayOptionsPanel displayOptionsPanel) {
        this.displayOptionsPanel = displayOptionsPanel;
    }

    public SortedMap<String, String> getAlgorithmToColumnName() {
        return algorithmToColumnName;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public CyLayoutAlgorithmManager getLayoutManager() {
        return this.layoutManager;
    }

    public CyApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public AnnotationFactory<ShapeAnnotation> getShapeFactory() {
        return this.shapeFactory;
    }

    public AnnotationFactory<TextAnnotation> getTextFactory() {
        return this.textFactory;
    }

    public CyGroupFactory getGroupFactory() {
        return this.groupFactory;
    }

    public CyGroupManager getGroupManager() {
        return this.groupManager;
    }

    public HeatMapPanel getHeatmapPanel() {
        return this.heatmapPanel;
    }

    public CytoPanel getWestPanel() {
        return this.application.getCytoPanel(CytoPanelName.WEST);
    }

    public CytoPanel getSouthPanel() {
        return this.application.getCytoPanel(CytoPanelName.SOUTH);
    }

    public void flushPayloadEvents() {
        this.eventHelper.flushPayloadEvents();
    }

    public boolean isClusterTableUpdating() {
        return this.clusterTableUpdating;
    }

    public void setClusterTableUpdating(boolean clusterTableUpdating) {
        this.clusterTableUpdating = clusterTableUpdating;
    }

    public AutoAnnotationParameters getParams() {
        CyNetworkView selectedView = this.annotationPanel.getCurrentView();
        if (this.networkViewToAutoAnnotationParameters.containsKey(selectedView)) {
            return this.networkViewToAutoAnnotationParameters.get(selectedView);
        }
        return null;
    }

    static {
        TreeMap<String, String> aMap = new TreeMap<String, String>();
        aMap.put("Affinity Propagation Cluster", "__APCluster");
        aMap.put("Cluster Fuzzifier", "__fuzzifierCluster");
        aMap.put("Community cluster (GLay)", "__glayCluster");
        aMap.put("ConnectedComponents Cluster", "__ccCluster");
        aMap.put("Fuzzy C-Means Cluster", "__fcmlCluster");
        aMap.put("MCL Cluster", "__mclCluster");
        aMap.put("SCPS Cluster", "__scpsCluster");
        algorithmToColumnName = Collections.unmodifiableSortedMap(aMap);
    }
}

