/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.util.ArrayList;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.task.UpdateHeatMapTask;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class EnrichmentMapActionListener
implements RowsSetListener {
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private CyApplicationManager applicationManager;
    private SynchronousTaskManager syncTaskManager;
    private final CytoPanel cytoPanelSouth;
    private FileUtil fileUtil;
    private StreamUtil streamUtil;

    public EnrichmentMapActionListener(HeatMapPanel heatMapPanel_node, HeatMapPanel heatMapPanel_edge, CyApplicationManager applicationManager, CySwingApplication application, FileUtil fileUtil, StreamUtil streamUtil, SynchronousTaskManager syncTaskManager) {
        this.applicationManager = applicationManager;
        this.fileUtil = fileUtil;
        this.streamUtil = streamUtil;
        this.syncTaskManager = syncTaskManager;
        this.edgeOverlapPanel = heatMapPanel_edge;
        this.nodeOverlapPanel = heatMapPanel_node;
        this.cytoPanelSouth = application.getCytoPanel(CytoPanelName.SOUTH);
    }

    private EnrichmentMap getAndInitializeEnrichmentMap(CyNetwork network) {
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        EnrichmentMap map = manager.getMap(network.getSUID());
        if (map != null && map.getParams().isData() && map.getParams().getHmParams() == null) {
            HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel);
            if (map.getParams().isData2() && map.getDataset("Dataset 2").getExpressionSets() != null && !map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                hmParams.initColorGradients(map.getDataset("Dataset 1").getExpressionSets(), map.getDataset("Dataset 2").getExpressionSets());
            } else {
                hmParams.initColorGradients(map.getDataset("Dataset 1").getExpressionSets());
            }
            map.getParams().setHmParams(hmParams);
        }
        return map;
    }

    public void handleEvent(RowsSetEvent e) {
        EnrichmentMap map;
        boolean override_revalidate_heatmap = EnrichmentMapManager.getInstance().isOverrideHeatmapRevalidation();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (!(network == null || e == null || e.getSource() != network.getDefaultEdgeTable() && e.getSource() != network.getDefaultNodeTable() || (map = this.getAndInitializeEnrichmentMap(network)) == null || override_revalidate_heatmap)) {
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
            final ArrayList<CyNode> Nodes = map.getParams().getSelectedNodes();
            final ArrayList<CyEdge> Edges = map.getParams().getSelectedEdges();
            Nodes.clear();
            Nodes.addAll(selectedNodes);
            Edges.clear();
            Edges.addAll(selectedEdges);
            new Thread(){

                @Override
                public void run() {
                    UpdateHeatMapTask updateHeatmap = new UpdateHeatMapTask(map, Nodes, Edges, EnrichmentMapActionListener.this.edgeOverlapPanel, EnrichmentMapActionListener.this.nodeOverlapPanel, EnrichmentMapActionListener.this.cytoPanelSouth, EnrichmentMapActionListener.this.applicationManager);
                    EnrichmentMapActionListener.this.syncTaskManager.execute(new TaskIterator(new Task[]{updateHeatmap}));
                }
            }.start();
        }
    }
}

