/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.work.TaskMonitor;

public class WidthFunction {
    public static final double DEFAULT_WIDTH_EM_LOWER = 1.0;
    public static final double DEFAULT_WIDTH_EM_UPPER = 5.0;
    public static final double DEFAULT_WIDTH_PA_LESS_THAN_100 = 8.0;
    public static final double DEFAULT_WIDTH_PA_LESS_THAN_10 = 4.5;
    public static final double DEFAULT_WIDTH_PA_GREATER = 1.0;
    public static final String EDGE_WIDTH_FORMULA_COLUMN = "Edge_width_formula";
    public static final String EDGE_WIDTH_PARAMETERS_COLUMN = "EM_Edge_width_parameters";
    private final VisualMappingFunctionFactory vmfFactoryContinuous;

    public WidthFunction(VisualMappingFunctionFactory vmfFactoryContinuous) {
        this.vmfFactoryContinuous = vmfFactoryContinuous;
    }

    private static boolean isSignature(String interaction) {
        return "sig".equals(interaction) || "sig_set1".equals(interaction) || "sig_set2".equals(interaction);
    }

    public static boolean appliesTo(CyNetwork network) {
        CyTable networkTable = network.getDefaultNetworkTable();
        return networkTable.getColumn(EDGE_WIDTH_PARAMETERS_COLUMN) != null;
    }

    public void setEdgeWidths(CyNetwork network, String prefix, TaskMonitor taskMonitor) {
        this.createColumns(network, prefix);
        this.calculateAndSetEdgeWidths(network, prefix, taskMonitor);
    }

    private void createColumns(CyNetwork network, String prefix) {
        CyTable networkTable = network.getDefaultNetworkTable();
        if (networkTable.getColumn(EDGE_WIDTH_PARAMETERS_COLUMN) == null) {
            networkTable.createColumn(EDGE_WIDTH_PARAMETERS_COLUMN, String.class, false);
        }
        String widthAttribute = prefix + EDGE_WIDTH_FORMULA_COLUMN;
        CyTable edgeTable = network.getDefaultEdgeTable();
        if (edgeTable.getColumn(widthAttribute) == null) {
            edgeTable.createColumn(widthAttribute, Double.class, false);
        }
    }

    private void calculateAndSetEdgeWidths(CyNetwork network, String prefix, TaskMonitor taskMonitor) {
        EdgeWidthParams edgeWidthParams = EdgeWidthParams.restore(network);
        EnrichmentMap map = EnrichmentMapManager.getInstance().getMap(network.getSUID());
        String widthAttribute = prefix + EDGE_WIDTH_FORMULA_COLUMN;
        int n = network.getDefaultEdgeTable().getRowCount();
        int i = 0;
        for (CyRow row : network.getDefaultEdgeTable().getAllRows()) {
            if (taskMonitor != null) {
                taskMonitor.setProgress((double)i / (double)n);
            }
            ++i;
            String interaction = (String)row.get("interaction", String.class);
            if (WidthFunction.isSignature(interaction)) {
                Double cutoff;
                Double pvalue;
                String cutoffType = (String)row.get(prefix + "Overlap_cutoff", String.class);
                FilterParameters.FilterType filterType = FilterParameters.FilterType.fromDisplayString(cutoffType);
                if (filterType == null) {
                    row.set(widthAttribute, null);
                    continue;
                }
                switch (filterType) {
                    case MANN_WHIT_TWO_SIDED: {
                        pvalue = (Double)row.get(prefix + "Overlap_Mann_Whit_pVal", Double.class);
                        cutoff = (Double)row.get(prefix + "Overlap_Mann_Whit_cutoff", Double.class);
                        break;
                    }
                    case MANN_WHIT_GREATER: {
                        pvalue = (Double)row.get(prefix + "Overlap_Mann_Whit_greater_pVal", Double.class);
                        cutoff = (Double)row.get(prefix + "Overlap_Mann_Whit_cutoff", Double.class);
                        break;
                    }
                    case MANN_WHIT_LESS: {
                        pvalue = (Double)row.get(prefix + "Overlap_Mann_Whit_less_pVal", Double.class);
                        cutoff = (Double)row.get(prefix + "Overlap_Mann_Whit_cutoff", Double.class);
                        break;
                    }
                    default: {
                        pvalue = (Double)row.get(prefix + "Overlap_Hypergeom_pVal", Double.class);
                        cutoff = (Double)row.get(prefix + "Overlap_Hypergeom_cutoff", Double.class);
                    }
                }
                if (pvalue == null || cutoff == null) {
                    row.set(widthAttribute, null);
                    continue;
                }
                if (pvalue <= cutoff / 100.0) {
                    row.set(widthAttribute, (Object)edgeWidthParams.pa_lessThan100);
                    continue;
                }
                if (pvalue <= cutoff / 10.0) {
                    row.set(widthAttribute, (Object)edgeWidthParams.pa_lessThan10);
                    continue;
                }
                row.set(widthAttribute, (Object)edgeWidthParams.pa_greater);
                continue;
            }
            ContinuousMapping conmapping_edgewidth = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + "similarity_coefficient", Double.class, BasicVisualLexicon.EDGE_WIDTH);
            Double under_width = 0.5;
            Double min_width = edgeWidthParams.em_lower;
            Double max_width = edgeWidthParams.em_upper;
            Double over_width = 6.0;
            BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width);
            BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width);
            conmapping_edgewidth.addPoint((Object)map.getParams().getSimilarityCutOff(), bv4);
            conmapping_edgewidth.addPoint((Object)1.0, bv5);
            Double value = (Double)conmapping_edgewidth.getMappedValue(row);
            row.set(widthAttribute, (Object)value);
        }
    }

    public static class EdgeWidthParams {
        public final double em_lower;
        public final double em_upper;
        public final double pa_lessThan100;
        public final double pa_lessThan10;
        public final double pa_greater;

        public EdgeWidthParams(double em_lower, double em_upper, double pa_lessThan100, double pa_lessThan10, double pa_greater) {
            this.em_lower = em_lower;
            this.em_upper = em_upper;
            this.pa_lessThan100 = pa_lessThan100;
            this.pa_lessThan10 = pa_lessThan10;
            this.pa_greater = pa_greater;
        }

        public static EdgeWidthParams defaultValues() {
            return new EdgeWidthParams(1.0, 5.0, 8.0, 4.5, 1.0);
        }

        public static EdgeWidthParams restore(CyNetwork network) {
            try {
                String val = (String)network.getRow((CyIdentifiable)network).get(WidthFunction.EDGE_WIDTH_PARAMETERS_COLUMN, String.class);
                String[] params = val.split(",");
                double em_lower = Double.parseDouble(params[0]);
                double em_upper = Double.parseDouble(params[1]);
                double pa_lessThan100 = Double.parseDouble(params[2]);
                double pa_lessThan10 = Double.parseDouble(params[3]);
                double pa_greater = Double.parseDouble(params[4]);
                return new EdgeWidthParams(em_lower, em_upper, pa_lessThan100, pa_lessThan10, pa_greater);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                return EdgeWidthParams.defaultValues();
            }
        }

        public void save(CyNetwork network) {
            CyRow row = network.getRow((CyIdentifiable)network);
            String val = String.format("%f,%f,%f,%f,%f", this.em_lower, this.em_upper, this.pa_lessThan100, this.pa_lessThan10, this.pa_greater);
            row.set(WidthFunction.EDGE_WIDTH_PARAMETERS_COLUMN, (Object)val);
        }
    }
}

