/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import javax.swing.DefaultListModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;

public class PostAnalysisParameters {
    private boolean isSignatureDiscovery = false;
    private boolean isKnownSignature = true;
    private FilterParameters filterParameters = new FilterParameters();
    private FilterParameters rankTestParameters = new FilterParameters();
    public static final String SIGNATURE_INTERACTION_TYPE = "sig";
    public static final String SIGNATURE_INTERACTION_TYPE_SET1 = "sig_set1";
    public static final String SIGNATURE_INTERACTION_TYPE_SET2 = "sig_set2";
    private String signatureGMTFileName = "";
    private SetOfGeneSets signatureGenesets = new SetOfGeneSets();
    private DefaultListModel<String> signatureSetNames = new DefaultListModel();
    private DefaultListModel<String> selectedSignatureSetNames = new DefaultListModel();
    private double currentNodePlacementY_Offset = 0.0;
    private String signature_rankFile;
    private String signature_dataSet;
    private int universeSize;
    private String attributePrefix = null;

    public PostAnalysisParameters() {
        this.filterParameters.setValue(FilterParameters.FilterType.HYPERGEOM, 0.25);
    }

    public PostAnalysisParameters(PostAnalysisParameters source) {
        this();
        this.isSignatureDiscovery = source.isSignatureDiscovery();
        this.isKnownSignature = source.isKnownSignature();
        this.universeSize = source.getUniverseSize();
        this.signatureGMTFileName = source.getSignatureGMTFileName();
        this.signature_dataSet = source.getSignature_dataSet();
        this.signatureGenesets = source.getSignatureGenesets();
        this.signatureSetNames = source.getSignatureSetNames();
        this.selectedSignatureSetNames = source.getSelectedSignatureSetNames();
        this.currentNodePlacementY_Offset = source.getCurrentNodePlacementY_Offset();
        this.attributePrefix = source.getAttributePrefix();
        this.filterParameters = new FilterParameters(source.getFilterParameters());
        this.rankTestParameters = new FilterParameters(source.getRankTestParameters());
    }

    public void checkMinimalRequirements(StringBuilder errors) {
        errors.append(this.checkGMTfiles());
        if (this.selectedSignatureSetNames.isEmpty()) {
            errors.append("No Signature Genesets selected \n");
        }
    }

    public FilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public FilterParameters getRankTestParameters() {
        return this.rankTestParameters;
    }

    public String checkGMTfiles() {
        String signatureGMTFileName = this.getSignatureGMTFileName();
        if (signatureGMTFileName == null || signatureGMTFileName.isEmpty() || !EnrichmentMapParameters.checkFile(signatureGMTFileName)) {
            return "Signature GMT file can not be found \n";
        }
        return "";
    }

    public void setSignatureGMTFileName(String signatureGMTFileName) {
        this.signatureGMTFileName = signatureGMTFileName;
    }

    public String getSignatureGMTFileName() {
        return this.signatureGMTFileName;
    }

    public void setSignatureHub(boolean isSignatureDiscovery) {
        this.isSignatureDiscovery = isSignatureDiscovery;
        this.isKnownSignature = !this.isSignatureDiscovery;
    }

    public boolean isSignatureDiscovery() {
        return this.isSignatureDiscovery;
    }

    public void setSignatureGenesets(SetOfGeneSets signatureGenesets) {
        this.signatureGenesets = signatureGenesets;
    }

    public SetOfGeneSets getSignatureGenesets() {
        return this.signatureGenesets;
    }

    public DefaultListModel<String> getSignatureSetNames() {
        return this.signatureSetNames;
    }

    public DefaultListModel<String> getSelectedSignatureSetNames() {
        return this.selectedSignatureSetNames;
    }

    public void setCurrentNodePlacementY_Offset(double currentNodePlacementY_Offset) {
        this.currentNodePlacementY_Offset = currentNodePlacementY_Offset;
    }

    public double getCurrentNodePlacementY_Offset() {
        return this.currentNodePlacementY_Offset;
    }

    public String getSignature_rankFile() {
        return this.signature_rankFile;
    }

    public void setSignature_rankFile(String signature_rankFile) {
        this.signature_rankFile = signature_rankFile;
    }

    public String getSignature_dataSet() {
        return this.signature_dataSet;
    }

    public void setSignature_dataSet(String signature_dataSet) {
        this.signature_dataSet = signature_dataSet;
    }

    public boolean isKnownSignature() {
        return this.isKnownSignature;
    }

    public void setKnownSignature(boolean isKnownSignature) {
        this.isKnownSignature = isKnownSignature;
    }

    public int getUniverseSize() {
        return this.universeSize;
    }

    public void setUniverseSize(int universeSize) {
        this.universeSize = universeSize;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }
}

