/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.CharArrayList;
import java.util.ArrayList;

public abstract class AbstractCharList
extends AbstractList {
    protected int size;

    protected AbstractCharList() {
    }

    public void addAllOfFromTo(AbstractCharList abstractCharList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractCharList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractCharList abstractCharList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractCharList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public char[] elements() {
        char[] cArray = new char[this.size];
        int n = this.size;
        while (--n >= 0) {
            cArray[n] = this.getQuick(n);
        }
        return cArray;
    }

    public AbstractCharList elements(char[] cArray) {
        this.clear();
        this.addAllOfFromTo(new CharArrayList(cArray), 0, cArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractCharList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractCharList abstractCharList = (AbstractCharList)object;
        if (this.size() != abstractCharList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractCharList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public char get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract char getQuick(int var1);

    public AbstractCharList partFromTo(int n, int n2) {
        AbstractCharList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        CharArrayList charArrayList = new CharArrayList(n3);
        charArrayList.addAllOfFromTo(this, n, n2);
        return charArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractCharList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractCharList abstractCharList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractCharList.checkRangeFromTo(n, n2, this.size());
            AbstractCharList.checkRangeFromTo(n3, n3 + n4 - 1, abstractCharList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractCharList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractCharList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, char var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Character> arrayList = new ArrayList<Character>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Character(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

