/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapTableModel;
import org.baderlab.csplugins.enrichmentmap.model.HyperLinkOut;
import org.cytoscape.util.swing.OpenBrowser;

public class HeatMapTableActionListener
implements MouseListener {
    private OpenBrowser openBrowser;
    private JTable jtable;
    private HeatMapTableModel model;
    private JPopupMenu rightClickPopupMenu;
    private Map<String, Map<String, String>> linkoutProps;

    public HeatMapTableActionListener(JTable jtable, HeatMapTableModel model, JPopupMenu rightClickPopupMenu, Map<String, Map<String, String>> linkoutProps, OpenBrowser openBrowser) {
        this.jtable = jtable;
        this.model = model;
        this.linkoutProps = linkoutProps;
        this.rightClickPopupMenu = rightClickPopupMenu;
        this.openBrowser = openBrowser;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int column = this.jtable.getColumnModel().getColumnIndexAtX(e.getX());
        int row = e.getY() / this.jtable.getRowHeight();
        Object value = this.jtable.getValueAt(row, column);
        if ((SwingUtilities.isRightMouseButton(e) || this.isMacPlatform() && e.isControlDown()) && value != null) {
            if (this.rightClickPopupMenu.getComponentCount() > 0) {
                this.rightClickPopupMenu.remove(this.rightClickPopupMenu.getComponentCount() - 1);
            }
            if (column == 0 || column == 1) {
                this.rightClickPopupMenu.add(new HyperLinkOut(value.toString(), this.linkoutProps, this.openBrowser));
            }
            this.rightClickPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private boolean isMacPlatform() {
        String os = System.getProperty("os.name");
        return os.regionMatches(true, 0, "mac", 0, "mac".length());
    }
}

